/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.listener;

import com.sk89q.worldedit.command.tool.brush.Brush;
import de.eldoria.gridselector.adapter.regionadapter.WorldAdapter;
import de.eldoria.gridselector.brush.SelectionBrush;
import de.eldoria.gridselector.config.Configuration;
import de.eldoria.gridselector.schematics.GridSchematics;
import de.eldoria.schematicbrush.libs.eldoutilities.messages.MessageSender;
import de.eldoria.schematicbrush.util.WorldEditBrush;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class SelectionListener
implements Listener {
    private final Map<UUID, SelectionBrush> players = new HashMap<UUID, SelectionBrush>();
    private final WorldAdapter adapter;
    private final GridSchematics schematicService;
    private final MessageSender messageSender;
    private final Configuration configuration;

    public SelectionListener(WorldAdapter adapter, GridSchematics schematicService, MessageSender messageSender, Configuration configuration) {
        this.adapter = adapter;
        this.schematicService = schematicService;
        this.messageSender = messageSender;
        this.configuration = configuration;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldChange(PlayerTeleportEvent event) {
        if (event.getFrom().getWorld() != event.getTo().getWorld() && this.players.containsKey(event.getPlayer().getUniqueId())) {
            this.players.get(event.getPlayer().getUniqueId()).clearRegions();
            this.messageSender.sendError((CommandSender)event.getPlayer(), "You changed the world. All selections will be removed.");
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.players.containsKey(player.getUniqueId())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        Brush brush = WorldEditBrush.getBrush((Player)player);
        if (!(brush instanceof SelectionBrush)) {
            return;
        }
        SelectionBrush brush2 = (SelectionBrush)brush;
        if (brush2.getRegions().isEmpty()) {
            this.messageSender.sendError((CommandSender)player, "You dont have any regions selected");
            return;
        }
        this.schematicService.saveRegions(player, brush2.getRegions());
        brush2.clearRegions();
        this.messageSender.sendMessage((CommandSender)player, "Selections saved. Use the grid Selector to use them.");
        event.setCancelled(true);
    }

    public void register(Player player) {
        SelectionBrush brush = new SelectionBrush(this.messageSender, player, this.adapter, this.configuration);
        if (!WorldEditBrush.setBrush((Player)player, (Brush)brush)) {
            return;
        }
        this.players.put(player.getUniqueId(), brush);
        this.messageSender.sendMessage((CommandSender)player, "Selection tool bound. Select schematics with right clicks. Left click when you are done.");
    }
}

