/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.command.grid.cluster;

import de.eldoria.gridselector.command.grid.cluster.Draw;
import de.eldoria.gridselector.config.Configuration;
import de.eldoria.gridselector.config.elements.cluster.GridCluster;
import de.eldoria.gridselector.util.Permissions;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.AdvancedCommand;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.CommandMeta;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.Arguments;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.CommandAssertions;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.executor.IPlayerTabExecutor;
import de.eldoria.schematicbrush.libs.eldoutilities.localization.Replacement;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Repair
extends AdvancedCommand
implements IPlayerTabExecutor {
    private final Configuration configuration;
    private final Draw draw;

    public Repair(Plugin plugin, Configuration configuration, Draw draw) {
        super(plugin, CommandMeta.builder((String)"repair").addUnlocalizedArgument("id", false).withPermission(new String[]{Permissions.Cluster.REPAIR}).build());
        this.configuration = configuration;
        this.draw = draw;
    }

    public void onCommand(@NotNull Player player, @NotNull String alias, @NotNull Arguments args) throws CommandException {
        Optional<GridCluster> cluster;
        if (args.isEmpty()) {
            cluster = this.configuration.cluster().world(player.getWorld()).getCluster(player.getLocation());
            CommandAssertions.isTrue((boolean)cluster.isPresent(), (String)"You are not inside a cluster", (Replacement[])new Replacement[0]);
        } else {
            cluster = this.configuration.cluster().world(player.getWorld()).getCluster(args.asInt(0));
            CommandAssertions.isTrue((boolean)cluster.isPresent(), (String)"Unkown cluster id", (Replacement[])new Replacement[0]);
        }
        this.draw.draw(cluster.get(), player);
        this.configuration.save();
        this.messageSender().sendMessage((CommandSender)player, "Cluster redrawn.");
    }
}

