/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.command.grid.cluster;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import de.eldoria.gridselector.adapter.worldguard.IWorldGuardAdapter;
import de.eldoria.gridselector.command.grid.cluster.Sessions;
import de.eldoria.gridselector.config.Configuration;
import de.eldoria.gridselector.config.elements.cluster.GridCluster;
import de.eldoria.gridselector.config.elements.cluster.Plot;
import de.eldoria.gridselector.util.Permissions;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.AdvancedCommand;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.CommandMeta;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.Arguments;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.executor.IPlayerTabExecutor;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Draw
extends AdvancedCommand
implements IPlayerTabExecutor {
    private final Sessions sessions;
    private final Configuration configuration;
    private final IWorldGuardAdapter worldGuardAdapter;
    private final WorldEdit worldEdit;

    public Draw(Plugin plugin, Sessions sessions, Configuration configuration, IWorldGuardAdapter worldGuardAdapter) {
        super(plugin, CommandMeta.builder((String)"draw").withPermission(new String[]{Permissions.Cluster.CREATE}).hidden().build());
        this.sessions = sessions;
        this.configuration = configuration;
        this.worldGuardAdapter = worldGuardAdapter;
        this.worldEdit = WorldEdit.getInstance();
    }

    public void draw(GridCluster cluster, Player player) {
        int y = cluster.minHeight();
        BukkitPlayer actor = BukkitAdapter.adapt((Player)player);
        EditSession session = this.worldEdit.newEditSessionBuilder().actor((Actor)actor).world(BukkitAdapter.adapt((World)player.getWorld())).build();
        try (EditSession editSession = session;){
            this.drawRegions(cluster, session, y, player);
        }
        catch (MaxChangedBlocksException e) {
            this.messageSender().sendError((CommandSender)player, "Grid exceeds maximum world edit size.");
        }
        this.worldEdit.getSessionManager().get((SessionOwner)actor).remember(session);
        this.messageSender().sendMessage((CommandSender)player, "Created grid. Changed " + session.size() + " blocks.");
    }

    private void drawRegions(GridCluster cluster, EditSession session, int y, Player player) throws MaxChangedBlocksException {
        session.setBlocks((Region)cluster.plot().as2DRegion(y), (BlockStateHolder)BukkitAdapter.adapt((BlockData)cluster.offsetMaterial().createBlockData()));
        for (Plot plot : cluster.getRegions()) {
            session.setBlocks((Region)plot.as2DRegion(y), (BlockStateHolder)BukkitAdapter.adapt((BlockData)cluster.borderMaterial().createBlockData()));
            session.setBlocks((Region)plot.borderLessPlot().as2DRegion(y), (BlockStateHolder)BukkitAdapter.adapt((BlockData)cluster.floorMaterial().createBlockData()));
        }
    }

    public void onCommand(@NotNull Player player, @NotNull String alias, @NotNull Arguments args) throws CommandException {
        GridCluster.Builder builder = this.sessions.getOrCreateSession(player);
        GridCluster cluster = builder.build();
        int y = player.getWorld().getHighestBlockYAt(player.getLocation().getBlockX(), player.getLocation().getBlockZ());
        cluster.updateMinHeight(y);
        this.configuration.cluster().world(player.getWorld()).assertOverlap(cluster);
        this.draw(cluster, player);
        this.configuration.cluster().world(player.getWorld()).register(cluster);
        this.worldGuardAdapter.register(cluster, player);
        this.configuration.save();
        this.sessions.close(player);
    }
}

