/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.brush;

import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.util.Vector;

public record MarkerResult(String identifier, CuboidRegion schematicRegion, CuboidRegion fullRegion, int minHeight) {
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MarkerResult)) {
            return false;
        }
        MarkerResult that = (MarkerResult)o;
        return this.identifier.equals(that.identifier);
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }

    public List<Vector> getCorners() {
        ArrayList<Vector> result = new ArrayList<Vector>();
        BlockVector3 max = this.schematicRegion.getMaximumPoint();
        BlockVector3 min = this.schematicRegion.getMinimumPoint();
        for (int x : new int[]{min.getX() - 1, max.getX() + 1}) {
            for (int y : new int[]{min.getY() - 1, max.getY() + 1}) {
                for (int z : new int[]{min.getZ() - 1, max.getZ() + 1}) {
                    result.add(new Vector(x, y, z));
                }
            }
        }
        return result;
    }

    public CuboidRegion getBorder() {
        CuboidRegion region = this.fullRegion.clone();
        region.setPos1(region.getMinimumPoint().withY(this.minHeight).add(-1, 0, -1));
        region.setPos2(region.getMaximumPoint().withY(this.minHeight).add(1, 0, 1));
        return region;
    }

    public Set<Vector> getBorderBlocks() {
        CuboidRegion border = this.getBorder();
        BlockVector3 min = border.getMinimumPoint();
        BlockVector3 max = border.getMaximumPoint();
        HashSet<Vector> blocks = new HashSet<Vector>();
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            blocks.add(new Vector(x, this.minHeight, min.getBlockZ()));
            blocks.add(new Vector(x, this.minHeight, max.getBlockZ()));
        }
        for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
            blocks.add(new Vector(min.getBlockX(), this.minHeight, z));
            blocks.add(new Vector(max.getBlockX(), this.minHeight, z));
        }
        return blocks;
    }
}

