/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.config.elements.cluster;

import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.World;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.SerializationUtil;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.TypeResolvingMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="gridSelectorPlot")
public class Plot
implements ConfigurationSerializable {
    private final BlockVector2 min;
    private final BlockVector2 max;

    public Plot(Map<String, Object> objectMap) {
        TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
        this.min = this.fromParserString((String)map.getValue("min"));
        this.max = this.fromParserString((String)map.getValue("max"));
    }

    private Plot(BlockVector2 min, BlockVector2 max) {
        this.min = BlockVector2.at((int)Math.min(min.getBlockX(), max.getBlockX()), (int)Math.min(min.getBlockZ(), max.getBlockZ()));
        this.max = BlockVector2.at((int)Math.max(min.getBlockX(), max.getBlockX()), (int)Math.max(min.getBlockZ(), max.getBlockZ()));
    }

    public static Plot of(int minX, int minZ, int maxX, int maxZ) {
        return new Plot(BlockVector2.at((int)minX, (int)minZ), BlockVector2.at((int)maxX, (int)maxZ));
    }

    public static Plot of(BlockVector2 min, BlockVector2 max) {
        return new Plot(min, max);
    }

    private BlockVector2 fromParserString(String val) {
        return BlockVector2.at((int)Integer.parseInt(val.split(",")[0]), (int)Integer.parseInt(val.split(",")[1]));
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationUtil.newBuilder().add("min", (Object)this.min.toParserString()).add("max", (Object)this.max.toParserString()).build();
    }

    public Plot expand(int blocks) {
        return Plot.of(this.min.subtract(blocks, blocks), this.max.add(blocks, blocks));
    }

    public Plot move(int blocks) {
        return Plot.of(this.min.add(blocks, blocks), this.max.add(blocks, blocks));
    }

    public Plot modify(Function<BlockVector2, BlockVector2> min, Function<BlockVector2, BlockVector2> max) {
        return Plot.of(min.apply(this.min), max.apply(this.max));
    }

    public Plot borderLessPlot() {
        return this.expand(-1);
    }

    public boolean contains(BlockVector2 vector2) {
        return this.min.getBlockX() <= vector2.getBlockX() && vector2.getBlockX() <= this.max.getBlockX() && this.min.getBlockZ() <= vector2.getBlockZ() && vector2.getBlockZ() <= this.max.getBlockZ();
    }

    public BlockVector2 min() {
        return this.min;
    }

    public BlockVector2 max() {
        return this.max;
    }

    public boolean overlaps(Plot plot) {
        return this.min.getBlockX() < plot.max().getBlockX() && this.max.getBlockX() > plot.min().getBlockX() && this.min.getBlockZ() < plot.max().getBlockZ() && this.max.getBlockZ() > plot.min().getBlockZ();
    }

    public CuboidRegion as2DRegion() {
        return this.as2DRegion(0);
    }

    public CuboidRegion as2DRegion(int y) {
        return new CuboidRegion(this.min.toBlockVector3(y), this.max.toBlockVector3(y));
    }

    public String toString() {
        return "Plot{min=" + String.valueOf(this.min) + ", max=" + String.valueOf(this.max) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plot)) {
            return false;
        }
        Plot plot = (Plot)o;
        if (!this.min.equals((Object)plot.min)) {
            return false;
        }
        return this.max.equals((Object)plot.max);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }

    public String id() {
        return this.min.toParserString();
    }

    public CuboidRegion asRegion(World world) {
        return new CuboidRegion(this.min.toBlockVector3(world.getMinY()), this.max.toBlockVector3(world.getMaxY()));
    }
}

