/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.config.elements;

import de.eldoria.schematicbrush.libs.eldoutilities.serialization.SerializationUtil;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.TypeResolvingMap;
import java.nio.file.Path;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="gridSelectorGeneral")
public class General
implements ConfigurationSerializable {
    private boolean createWorldGuardRegions = false;
    private String schematicPath = "SchematicBrushReborn/schematics";
    private boolean absolutePath = false;

    public General() {
    }

    public General(Map<String, Object> objectMap) {
        TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
        this.createWorldGuardRegions = (Boolean)map.getValueOrDefault("createWorldGuardRegions", (Object)false);
        this.schematicPath = (String)map.getValueOrDefault("schematicPath", (Object)this.schematicPath);
        this.absolutePath = (Boolean)map.getValueOrDefault("absolutePath", (Object)this.absolutePath);
    }

    public boolean isCreateWorldGuardRegions() {
        return this.createWorldGuardRegions;
    }

    public Path schematicPath() {
        if (this.absolutePath) {
            return Path.of(this.schematicPath, new String[0]);
        }
        return Bukkit.getUpdateFolderFile().toPath().toAbsolutePath().getParent().resolve(this.schematicPath);
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationUtil.newBuilder().add("createWorldGuardRegions", (Object)this.createWorldGuardRegions).add("schematicPath", (Object)this.schematicPath).add("absolutePath", (Object)this.absolutePath).build();
    }
}

