/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.command.grid.cluster;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Direction;
import de.eldoria.gridselector.config.elements.cluster.GridCluster;
import de.eldoria.gridselector.util.Colors;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.CommandAssertions;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.schematicbrush.libs.eldoutilities.localization.MessageComposer;
import de.eldoria.schematicbrush.libs.eldoutilities.localization.Replacement;
import de.eldoria.schematicbrush.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import de.eldoria.schematicbrush.libs.kyori.adventure.text.minimessage.MiniMessage;
import de.eldoria.schematicbrush.libs.messageblocker.blocker.MessageBlocker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Sessions {
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Map<UUID, GridCluster.Builder> sessions = new HashMap<UUID, GridCluster.Builder>();
    private final MessageBlocker messageBlocker;
    private final BukkitAudiences audience;

    public Sessions(Plugin plugin, MessageBlocker messageBlocker) {
        this.messageBlocker = messageBlocker;
        this.audience = (BukkitAudiences)BukkitAudiences.builder((Plugin)plugin).build();
    }

    public GridCluster.Builder getOrCreateSession(Player player) throws CommandException {
        if (!this.sessions.containsKey(player.getUniqueId())) {
            Direction direction = Direction.findClosest((Vector3)BukkitAdapter.adapt((Player)player).getLocation().getDirection(), (int)Direction.Flag.CARDINAL);
            CommandAssertions.isTrue((direction != null ? 1 : 0) != 0, (String)"Invalid direction. Please look in the requested direction", (Replacement[])new Replacement[0]);
            GridCluster.Builder builder = GridCluster.builder(BukkitAdapter.adapt((Location)player.getLocation()), direction);
            this.sessions.put(player.getUniqueId(), builder);
        }
        return this.sessions.get(player.getUniqueId());
    }

    public void showBuilder(Player player) throws CommandException {
        this.messageBlocker.blockPlayer(player);
        GridCluster.Builder session = this.getOrCreateSession(player);
        MessageComposer composer = MessageComposer.create().text((Object)session.asComponent());
        composer.newLine().text("<%s><click:run_command:'/sbrg cluster draw'>[Create]</click>", new Object[]{Colors.ADD});
        composer.prependLines(20);
        this.messageBlocker.ifEnabled((Object)composer, mess -> mess.newLine().text("<click:run_command:'/sbrg cluster close'><%s>[x]</click>", new Object[]{Colors.REMOVE}));
        this.messageBlocker.announce(player, "[x]");
        this.audience.player(player).sendMessage(this.miniMessage.deserialize((Object)composer.build()));
    }

    public void close(Player player) {
        this.sessions.remove(player.getUniqueId());
        this.messageBlocker.unblockPlayer(player);
    }
}

