/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.brush;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BlockType;
import de.eldoria.gridselector.adapter.regionadapter.RegionResult;
import de.eldoria.gridselector.adapter.regionadapter.WorldAdapter;
import de.eldoria.gridselector.brush.MarkerResult;
import de.eldoria.gridselector.config.Configuration;
import de.eldoria.schematicbrush.libs.eldoutilities.messages.MessageSender;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SelectionBrush
implements Brush {
    private final MessageSender messageSender;
    private final Player owner;
    private final Map<String, MarkerResult> regions = new LinkedHashMap<String, MarkerResult>();
    private final WorldAdapter worldAdapter;
    private final Configuration configuration;

    public SelectionBrush(MessageSender messageSender, Player owner, WorldAdapter worldAdapter, Configuration configuration) {
        this.messageSender = messageSender;
        this.owner = owner;
        this.worldAdapter = worldAdapter;
        this.configuration = configuration;
    }

    public void build(EditSession editSession, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        Optional<RegionResult> optRegion = this.worldAdapter.getRegion(new com.sk89q.worldedit.util.Location((Extent)editSession.getWorld(), position.toVector3()));
        if (optRegion.isEmpty()) {
            this.messageSender.sendError((CommandSender)this.owner, "No grid or plot present.");
            return;
        }
        RegionResult result = optRegion.get();
        if (this.regions.containsKey(result.identifier())) {
            MarkerResult marker = this.regions.remove(result.identifier());
            this.resolveMarker(marker, this.owner.getWorld());
            return;
        }
        CuboidRegion region = result.region();
        int yMax = this.reduceTop(editSession, region);
        int yMin = this.reduceFloor(editSession, region, result.worldHeight());
        int xMin = this.reduceEastWestSide(editSession, yMin, yMax, region, true);
        int xMax = this.reduceEastWestSide(editSession, yMin, yMax, region, false);
        int zMin = this.reduceSouthNorthSide(editSession, yMin, yMax, region, true);
        int zMax = this.reduceSouthNorthSide(editSession, yMin, yMax, region, false);
        CuboidRegion schemRegion = new CuboidRegion(editSession.getWorld(), BlockVector3.at((int)xMin, (int)yMin, (int)zMin), BlockVector3.at((int)xMax, (int)yMax, (int)zMax));
        MarkerResult marker = new MarkerResult(result.identifier(), schemRegion, region, yMin);
        this.regions.put(result.identifier(), marker);
        BlockData data = this.configuration.highlight().highlight().createBlockData();
        if (this.configuration.highlight().isHighlightBounds()) {
            for (Vector corner : marker.getCorners()) {
                this.owner.sendBlockChange(corner.toLocation(this.owner.getWorld()), data);
            }
        }
        if (this.configuration.highlight().isHighlightBorder()) {
            for (Vector borderBlock : marker.getBorderBlocks()) {
                this.owner.sendBlockChange(borderBlock.toLocation(this.owner.getWorld()), data);
            }
        }
    }

    private int reduceFloor(EditSession session, CuboidRegion region, int minHeight) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        for (int y = minHeight; y <= max.getY(); ++y) {
            if (!this.checkFlat(session, y, min, max, mat -> mat == Material.AIR)) continue;
            return y;
        }
        return region.getMinimumY();
    }

    private int reduceTop(EditSession session, CuboidRegion region) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        for (int y = max.getY(); y >= min.getY(); --y) {
            if (!this.checkFlat(session, y, min, max, mat -> mat != Material.AIR)) continue;
            return y;
        }
        return region.getMaximumY();
    }

    private boolean checkFlat(EditSession session, int y, BlockVector3 min, BlockVector3 max, Predicate<Material> check) {
        for (int x = min.getX(); x < max.getX(); ++x) {
            for (int z = min.getZ(); z < max.getZ(); ++z) {
                BlockType material = session.getBlock(BlockVector3.at((int)x, (int)y, (int)z)).getBlockType();
                if (!check.test(BukkitAdapter.adapt((BlockType)material))) continue;
                return true;
            }
        }
        return false;
    }

    private int reduceEastWestSide(EditSession session, int yMin, int yMax, CuboidRegion region, boolean east) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        int x = (east ? min : max).getX();
        while (east ? x <= max.getX() : x >= min.getX()) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = min.getZ(); z < max.getZ(); ++z) {
                    BlockType material = session.getBlock(BlockVector3.at((int)x, (int)y, (int)z)).getBlockType();
                    if (BukkitAdapter.adapt((BlockType)material) == Material.AIR) continue;
                    return x;
                }
            }
            x += east ? 1 : -1;
        }
        return (east ? min : max).getX();
    }

    private int reduceSouthNorthSide(EditSession session, int yMin, int yMax, CuboidRegion region, boolean south) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        int z = (south ? min : max).getZ();
        while (south ? z <= max.getZ() : z >= min.getZ()) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = min.getX(); x < max.getX(); ++x) {
                    BlockType material = session.getBlock(BlockVector3.at((int)x, (int)y, (int)z)).getBlockType();
                    if (BukkitAdapter.adapt((BlockType)material) == Material.AIR) continue;
                    return z;
                }
            }
            z += south ? 1 : -1;
        }
        return (south ? min : max).getZ();
    }

    public List<CuboidRegion> getRegions() {
        return this.regions.values().stream().map(MarkerResult::schematicRegion).collect(Collectors.toList());
    }

    private void clearMarker() {
        World world = this.owner.getWorld();
        for (MarkerResult region : this.regions.values()) {
            this.resolveMarker(region, world);
        }
    }

    private void resolveMarker(MarkerResult region, World world) {
        Location loc;
        for (Vector corner : region.getCorners()) {
            loc = corner.toLocation(world);
            this.owner.sendBlockChange(loc, world.getBlockAt(loc).getBlockData());
        }
        for (Vector borderBlock : region.getBorderBlocks()) {
            loc = borderBlock.toLocation(this.owner.getWorld());
            this.owner.sendBlockChange(loc, world.getBlockAt(loc).getBlockData());
        }
    }

    public void clearRegions() {
        this.clearMarker();
        this.regions.clear();
    }
}

