/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.adapter.regionadapter;

import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import de.eldoria.gridselector.adapter.regionadapter.RegionAdapter;
import de.eldoria.gridselector.adapter.regionadapter.RegionResult;
import java.util.Optional;

public class PlotWorldAdapter
implements RegionAdapter {
    private final PlotAreaManager manager;

    public PlotWorldAdapter(PlotSquared plotSquared) {
        this.manager = plotSquared.getPlotAreaManager();
    }

    @Override
    public boolean isApplicable(org.bukkit.Location location) {
        Location loc = BukkitUtil.adapt((org.bukkit.Location)location);
        return this.manager.hasPlotArea(loc.getWorldName());
    }

    @Override
    public Optional<RegionResult> getRegion(org.bukkit.Location location) {
        Location loc = BukkitUtil.adapt((org.bukkit.Location)location);
        return Optional.ofNullable(this.manager.getPlotArea(loc)).map(area -> {
            Plot p = area.getPlot(loc);
            if (p == null) {
                return null;
            }
            CuboidRegion walls = p.getLargestRegion().clone();
            walls.expand(new BlockVector3[]{BlockVector3.at((int)1, (int)0, (int)1)});
            int minHeight = p.getLargestRegion().getMinimumY();
            if (area instanceof ClassicPlotWorld) {
                ClassicPlotWorld world = (ClassicPlotWorld)area;
                minHeight = world.PLOT_HEIGHT;
            }
            return new RegionResult(p.getId().toString(), p.getLargestRegion(), walls, minHeight);
        });
    }
}

