/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector;

import com.plotsquared.core.PlotSquared;
import de.eldoria.gridselector.adapter.regionadapter.ClusterWorldAdapter;
import de.eldoria.gridselector.adapter.regionadapter.PlotWorldAdapter;
import de.eldoria.gridselector.adapter.regionadapter.RegionAdapter;
import de.eldoria.gridselector.adapter.regionadapter.WorldAdapter;
import de.eldoria.gridselector.adapter.worldguard.IWorldGuardAdapter;
import de.eldoria.gridselector.adapter.worldguard.WorldGuardAdapter;
import de.eldoria.gridselector.command.Grid;
import de.eldoria.gridselector.config.Configuration;
import de.eldoria.gridselector.config.elements.ClusterWorlds;
import de.eldoria.gridselector.config.elements.General;
import de.eldoria.gridselector.config.elements.Highlight;
import de.eldoria.gridselector.config.elements.cluster.ClusterWorld;
import de.eldoria.gridselector.config.elements.cluster.GridCluster;
import de.eldoria.gridselector.config.elements.cluster.Plot;
import de.eldoria.gridselector.listener.SelectionListener;
import de.eldoria.gridselector.schematics.GridSchematics;
import de.eldoria.gridselector.selector.GridProvider;
import de.eldoria.schematicbrush.SchematicBrushReborn;
import de.eldoria.schematicbrush.brush.config.provider.SelectorProvider;
import de.eldoria.schematicbrush.libs.eldoutilities.localization.ILocalizer;
import de.eldoria.schematicbrush.libs.eldoutilities.messages.MessageSender;
import de.eldoria.schematicbrush.libs.eldoutilities.plugin.EldoPlugin;
import de.eldoria.schematicbrush.libs.messageblocker.MessageBlockerAPI;
import de.eldoria.schematicbrush.libs.messageblocker.blocker.MessageBlocker;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GridSelector
extends EldoPlugin {
    private Configuration configuration;

    public void onPluginEnable() throws Throwable {
        this.configuration = new Configuration((Plugin)this);
        SchematicBrushReborn sbr = SchematicBrushReborn.instance();
        MessageSender messageSender = MessageSender.create((Plugin)this, (String)"\u00a73[GS]");
        MessageBlocker messageBlocker = MessageBlockerAPI.builder((Plugin)this).addWhitelisted(new String[]{"[GS]"}).build();
        GridSchematics gridSchematics = new GridSchematics((Plugin)this);
        ILocalizer iLocalizer = ILocalizer.create((Plugin)this, (String[])new String[]{"en_US"});
        iLocalizer.setLocale("en_US");
        sbr.brushSettingsRegistry().registerSelector((SelectorProvider)new GridProvider(sbr.schematics()));
        sbr.schematics().register(GridSchematics.KEY, (Object)gridSchematics);
        ArrayList<RegionAdapter> regionAdapters = new ArrayList<RegionAdapter>();
        regionAdapters.add(new ClusterWorldAdapter(this.configuration));
        if (this.getPluginManager().isPluginEnabled("PlotSquared")) {
            GridSelector.logger().info("Found plot squared. Registering plot squared world adapter");
            PlotSquared plotSquared = PlotSquared.get();
            PlotWorldAdapter plotWorldAdapter = new PlotWorldAdapter(plotSquared);
            regionAdapters.add(plotWorldAdapter);
        }
        WorldAdapter worldAdapter = new WorldAdapter(regionAdapters);
        SelectionListener selectionListener = new SelectionListener(worldAdapter, gridSchematics, messageSender, this.configuration);
        this.registerListener(new Listener[]{selectionListener});
        IWorldGuardAdapter worldGuardAdapter = IWorldGuardAdapter.DEFAULT;
        if (this.getPluginManager().isPluginEnabled("WorldGuard")) {
            worldGuardAdapter = new WorldGuardAdapter(this.configuration);
        }
        this.registerCommand(new Grid(this, selectionListener, this.configuration, gridSchematics, messageBlocker, worldGuardAdapter));
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public List<Class<? extends ConfigurationSerializable>> getConfigSerialization() {
        return List.of(GridCluster.class, Plot.class, ClusterWorld.class, ClusterWorlds.class, Highlight.class, General.class, de.eldoria.gridselector.selector.Grid.class);
    }
}

