/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.internal.serialize;

import dev.mrwere.storage.storage.internal.serialize.SimplixSerializable;
import dev.mrwere.storage.storage.shaded.jetbrains.annotations.Nullable;
import dev.mrwere.storage.storage.util.Valid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public final class SimplixSerializer {
    private static final List<SimplixSerializable<?>> serializables = Collections.synchronizedList(new ArrayList());

    public static boolean isSerializable(Class<?> clazz) {
        return SimplixSerializer.findSerializable(clazz) != null;
    }

    public static void registerSerializable(@NonNull SimplixSerializable<?> serializable) {
        if (serializable == null) {
            throw new NullPointerException("serializable is marked non-null but is null");
        }
        Valid.notNull(serializable.getClazz(), "Class of serializable mustn't be null");
        serializables.add(serializable);
    }

    @Nullable
    public static SimplixSerializable<?> findSerializable(Class<?> clazz) {
        for (SimplixSerializable<?> serializable : serializables) {
            if (!serializable.getClazz().equals(clazz)) continue;
            return serializable;
        }
        return null;
    }

    public static Object serialize(Object obj) {
        SimplixSerializable<?> serializable = SimplixSerializer.findSerializable(obj.getClass());
        Valid.notNull(serializable, "No serializable found for '" + obj.getClass().getSimpleName() + "'");
        return serializable.serialize(obj);
    }

    public static <T> T deserialize(Object raw, Class<T> type) {
        SimplixSerializable<?> serializable = SimplixSerializer.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'", "Raw: '" + raw.getClass().getSimpleName() + "'");
        return (T)serializable.deserialize(raw);
    }

    private SimplixSerializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

