/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.internal.editor.yaml;

import dev.mrwere.storage.storage.internal.editor.yaml.YamlEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class YamlParser {
    private static final String FOOTER = "FOOTER";
    private final YamlEditor yamlEditor;

    public List<String> parseLines(List<String> comments, List<String> updated) {
        ArrayList<String> out = new ArrayList<String>();
        Map<String, List<String>> parsed = this.assignCommentsToKey(comments);
        for (String line : updated) {
            List<String> rawList = this.getKeyAndRemove(line, parsed);
            if (rawList == null || rawList.isEmpty()) {
                out.add(line);
                continue;
            }
            Collections.reverse(rawList);
            out.addAll(rawList);
            if (line.equals(FOOTER)) continue;
            out.add(line);
        }
        return out;
    }

    private List<String> getKeyAndRemove(String key, Map<String, List<String>> data) {
        key = key.split(":")[0];
        for (Map.Entry<String, List<String>> entry : data.entrySet()) {
            String entryKey = entry.getKey().split(":")[0];
            if (!key.equals(entryKey) && !key.substring(1).equals(entryKey)) continue;
            data.remove(entry.getKey());
            return entry.getValue();
        }
        return new ArrayList<String>();
    }

    public Map<String, List<String>> assignCommentsToKey() {
        return this.assignCommentsToKey(this.yamlEditor.read());
    }

    public Map<String, List<String>> assignCommentsToKey(List<String> lines) {
        HashMap<String, List<String>> out = new HashMap<String, List<String>>();
        String currentKey = FOOTER;
        for (int i = lines.size() - 1; i >= 0; --i) {
            String line = lines.get(i);
            if (!line.trim().startsWith("#") && !line.isEmpty()) {
                currentKey = line;
                continue;
            }
            List storage = (List)out.get(currentKey.split(":")[0]);
            if (storage == null) {
                out.put(currentKey.split(":")[0], new ArrayList<String>(Collections.singletonList(line)));
                continue;
            }
            if (storage.contains(line)) continue;
            storage.add(line);
        }
        return out;
    }

    public YamlParser(YamlEditor yamlEditor) {
        this.yamlEditor = yamlEditor;
    }
}

