/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.util;

import dev.mrwere.storage.storage.internal.exceptions.LightningValidationException;
import dev.mrwere.storage.storage.shaded.jetbrains.annotations.Nullable;

public final class Valid {
    public static void error(Throwable cause, String ... messages) {
        throw new LightningValidationException(cause, messages);
    }

    public static void error(String ... errorMessage) {
        throw new LightningValidationException(errorMessage);
    }

    public static void checkBoolean(boolean condition) {
        Valid.checkBoolean(condition, "Valid.checkBoolean(): Condition is False.");
    }

    public static void checkBoolean(boolean condition, String ... errorMessage) {
        if (!condition) {
            throw new LightningValidationException(errorMessage);
        }
    }

    public static <T> void notNull(@Nullable T object) {
        Valid.notNull(object, "Valid.notNull(): Validated Object is null");
    }

    public static <T> void notNull(@Nullable T object, String ... message) {
        if (object != null) {
            return;
        }
        throw new LightningValidationException(message);
    }

    private Valid() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

