/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.util;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;

public final class ClassWrapper {
    public static <T> T getFromDef(Object obj, T def) {
        if (def instanceof Integer) {
            return (T)INTEGER.getInt(obj);
        }
        if (def instanceof Float) {
            return (T)FLOAT.getFloat(obj);
        }
        if (def instanceof Double) {
            return (T)DOUBLE.getDouble(obj);
        }
        if (def instanceof Long) {
            return (T)LONG.getLong(obj);
        }
        if (def instanceof Boolean) {
            return (T)Boolean.valueOf(obj.toString().equalsIgnoreCase("true"));
        }
        if (def instanceof String[]) {
            return (T)STRING.getStringArray(obj);
        }
        if (def instanceof Long[] || def instanceof long[]) {
            return (T)LONG.getLongArray(obj);
        }
        if (def instanceof Double[] || def instanceof double[]) {
            return (T)DOUBLE.getDoubleArray(obj);
        }
        if (def instanceof Float[] || def instanceof float[]) {
            return (T)FLOAT.getFloatArray(obj);
        }
        if (def instanceof Short[] || def instanceof short[]) {
            return (T)SHORT.getShortArray(obj);
        }
        if (def instanceof Byte[] || def instanceof byte[]) {
            return (T)BYTE.getByteArray(obj);
        }
        return (T)obj;
    }

    public static <T> T getFromDef(Object obj, Class<T> clazz) {
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)INTEGER.getInt(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)FLOAT.getFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)DOUBLE.getDouble(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)LONG.getLong(obj);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)Boolean.valueOf(obj.toString().equalsIgnoreCase("true"));
        }
        if (clazz == String[].class) {
            return (T)STRING.getStringArray(obj);
        }
        if (clazz == Double[].class || clazz == double[].class) {
            return (T)DOUBLE.getDoubleArray(obj);
        }
        if (clazz == Float[].class || clazz == float[].class) {
            return (T)FLOAT.getFloatArray(obj);
        }
        if (clazz == Integer[].class || clazz == int[].class) {
            return (T)INTEGER.getIntArray(obj);
        }
        if (clazz == Short[].class || clazz == short[].class) {
            return (T)SHORT.getShortArray(obj);
        }
        if (clazz == Byte[].class || clazz == byte[].class) {
            return (T)BYTE.getByteArray(obj);
        }
        return (T)obj;
    }

    private ClassWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class STRING {
        public static String[] getStringArray(Object obj) {
            if (obj instanceof List) {
                List list = (List)obj;
                return list.toArray(new String[0]);
            }
            return new String[0];
        }

        public static String getString(Object obj) {
            if (obj instanceof Collection && ((Collection)obj).size() == 1) {
                return ((List)obj).get(0).toString();
            }
            return new String(obj.toString().getBytes(), StandardCharsets.UTF_8);
        }

        private STRING() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class BYTE {
        public static Byte[] getByteArray(Object obj) {
            if (obj instanceof List) {
                List list = (List)obj;
                return list.toArray(new Byte[0]);
            }
            return new Byte[0];
        }

        public static Byte getByte(Object obj) {
            if (obj instanceof Number) {
                return ((Number)obj).byteValue();
            }
            if (obj instanceof STRING) {
                return Byte.parseByte(obj.toString());
            }
            return Byte.parseByte(obj.toString());
        }

        private BYTE() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class SHORT {
        public static Short[] getShortArray(Object obj) {
            if (obj instanceof List) {
                List list = (List)obj;
                return list.toArray(new Short[0]);
            }
            return new Short[0];
        }

        public static Short getShort(Object obj) {
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            if (obj instanceof String) {
                return Short.parseShort((String)obj);
            }
            return Short.parseShort(obj.toString());
        }

        private SHORT() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class INTEGER {
        public static Integer[] getIntArray(Object obj) {
            if (obj instanceof List) {
                List list = (List)obj;
                return list.toArray(new Integer[0]);
            }
            return new Integer[0];
        }

        public static Integer getInt(Object obj) {
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof String) {
                return Integer.parseInt((String)obj);
            }
            return Integer.parseInt(obj.toString());
        }

        private INTEGER() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class FLOAT {
        public static Float[] getFloatArray(Object obj) {
            if (obj instanceof List) {
                List list = (List)obj;
                return list.toArray(new Float[0]);
            }
            return new Float[0];
        }

        public static Float getFloat(Object obj) {
            if (obj instanceof Number) {
                return Float.valueOf(((Number)obj).floatValue());
            }
            if (obj instanceof String) {
                return Float.valueOf(Float.parseFloat((String)obj));
            }
            return Float.valueOf(Float.parseFloat(obj.toString()));
        }

        private FLOAT() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class DOUBLE {
        public static Double[] getDoubleArray(Object obj) {
            if (obj instanceof List) {
                List list = (List)obj;
                return list.toArray(new Double[0]);
            }
            return new Double[0];
        }

        public static Double getDouble(Object obj) {
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj instanceof String) {
                return Double.parseDouble((String)obj);
            }
            return Double.parseDouble(obj.toString());
        }

        private DOUBLE() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class LONG {
        public static Long[] getLongArray(Object obj) {
            if (obj instanceof List) {
                List list = (List)obj;
                return list.toArray(new Long[0]);
            }
            return new Long[0];
        }

        public static Long getLong(Object obj) {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            return Long.parseLong(obj.toString());
        }

        private LONG() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

