/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.internal;

import dev.mrwere.storage.storage.internal.provider.LightningProviders;
import dev.mrwere.storage.storage.internal.serialize.LightningSerializer;
import dev.mrwere.storage.storage.shaded.jetbrains.annotations.Nullable;
import dev.mrwere.storage.storage.util.ClassWrapper;
import dev.mrwere.storage.storage.util.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;

public interface DataStorage {
    @Nullable
    public Object get(String var1);

    public boolean contains(String var1);

    public void set(String var1, Object var2);

    public Set<String> singleLayerKeySet();

    public Set<String> singleLayerKeySet(String var1);

    public Set<String> keySet();

    public Set<String> keySet(String var1);

    public void remove(String var1);

    default public <T> Optional<T> find(String key, Class<T> type) {
        Object raw = this.get(key);
        if (raw == null) {
            return Optional.empty();
        }
        return Optional.of(ClassWrapper.getFromDef(raw, type));
    }

    default public <T> void setSerializable(@NonNull String key, @NonNull T value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            Object data = LightningSerializer.serialize(value);
            this.set(key, data);
        }
        catch (Throwable throwable) {
            throw LightningProviders.exceptionHandler().create(throwable, "Can't deserialize: '" + key + "'", "Class: '" + value.getClass().getName() + "'", "Package: '" + value.getClass().getPackage() + "'");
        }
    }

    default public <T> T get(String key, T def) {
        Object raw = this.get(key);
        return raw == null ? def : ClassWrapper.getFromDef(raw, def);
    }

    default public String getString(String key) {
        return this.getOrDefault(key, "");
    }

    default public long getLong(String key) {
        return this.getOrDefault(key, 0L);
    }

    default public int getInt(String key) {
        return this.getOrDefault(key, 0);
    }

    default public byte getByte(String key) {
        return this.getOrDefault(key, (byte)0);
    }

    default public boolean getBoolean(String key) {
        return this.getOrDefault(key, false);
    }

    default public float getFloat(String key) {
        return this.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
    }

    default public double getDouble(String key) {
        return this.getOrDefault(key, 0.0);
    }

    default public List<?> getList(String key) {
        return this.getOrDefault(key, new ArrayList());
    }

    default public List<String> getStringList(String key) {
        return this.getOrDefault(key, new ArrayList());
    }

    default public List<Integer> getIntegerList(String key) {
        return this.getOrDefault(key, new ArrayList());
    }

    default public List<Byte> getByteList(String key) {
        return this.getOrDefault(key, new ArrayList());
    }

    default public List<Long> getLongList(String key) {
        return this.getOrDefault(key, new ArrayList());
    }

    default public Map<?, ?> getMap(String key) {
        return this.getOrDefault(key, new HashMap());
    }

    default public <E extends Enum<E>> E getEnum(String key, Class<E> enumType) {
        Object object = this.get(key);
        Valid.checkBoolean(object instanceof String, "No usable Enum-Value found for '" + key + "'.");
        return Enum.valueOf(enumType, (String)object);
    }

    default public <T> T getSerializable(String key, Class<T> clazz) {
        if (!this.contains(key)) {
            return null;
        }
        return LightningSerializer.deserialize(this.get(key), clazz);
    }

    default public <T> T getOrDefault(String key, @NonNull T def) {
        if (def == null) {
            throw new NullPointerException("def is marked non-null but is null");
        }
        Object raw = this.get(key);
        return raw == null ? def : ClassWrapper.getFromDef(raw, def);
    }

    default public void setDefault(String key, Object value) {
        if (!this.contains(key)) {
            this.set(key, value);
        }
    }

    default public <T> T getOrSetDefault(String key, T def) {
        Object raw = this.get(key);
        if (raw == null) {
            this.set(key, def);
            return def;
        }
        return ClassWrapper.getFromDef(raw, def);
    }
}

