/*
 * Decompiled with CFR 0.152.
 */
package com.minetexas.greentext.commands;

import com.dthielke.herochat.Chatter;
import com.dthielke.herochat.ChatterManager;
import com.dthielke.herochat.Herochat;
import com.minetexas.greentext.exception.GTException;
import com.minetexas.greentext.util.GTLog;
import com.minetexas.greentext.util.GTSettings;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandBase
implements CommandExecutor {
    protected HashMap<String, String> commands = new HashMap();
    protected String[] args;
    protected CommandSender sender;
    protected String command = "FIXME";
    protected String displayName = "FIXME";
    protected boolean sendUnknownToDefault = false;

    public void init() {
        this.command = "/me";
        this.displayName = "Throwdown, right meow!";
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        this.init();
        this.args = args;
        this.sender = sender;
        if (!this.permissionCheck("greentext.use").booleanValue()) {
            CommandBase.sendMessage((Object)sender, "\u00a7cYou'd better check yourself before you wreck yourself!");
            return false;
        }
        if (args.length == 0) {
            CommandBase.sendMessage((Object)sender, "\u00a7dYou didn't meme hard enough!");
            return false;
        }
        StringBuilder builder = new StringBuilder();
        if (!this.permissionCheck("greentext.anon").booleanValue()) {
            builder.append(String.valueOf(sender.getName()) + " ");
        }
        builder.append(">");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            s = s.replace("@p", "\u00a7b" + sender.getName() + "\u00a7a");
            if (sender instanceof Player) {
                s = s.replace("@l", "\u00a76XYZ: 1337 250 1337\u00a7a");
            }
            builder.append(" " + s);
            ++n2;
        }
        String meme = builder.toString();
        GTLog.info(String.valueOf(sender.getName()) + meme);
        Collection players = Bukkit.getOnlinePlayers();
        Boolean useHerochat = false;
        if (GTSettings.hasHerochat.booleanValue()) {
            Herochat hc = Herochat.getPlugin();
            useHerochat = hc.isEnabled();
            GTLog.debug("Herochat usable? " + useHerochat);
        }
        for (Player p : players) {
            if (useHerochat.booleanValue()) {
                ChatterManager cm = Herochat.getChatterManager();
                Player player = (Player)sender;
                Chatter chatter = cm.getChatter(player);
                Chatter chattee = cm.getChatter(p);
                if (chattee.isIgnoring(chatter)) continue;
            }
            p.sendMessage("\u00a7a" + meme);
        }
        return true;
    }

    public Boolean permissionCheck(String permission) {
        Player player;
        try {
            player = this.getPlayer();
        }
        catch (GTException e) {
            e.printStackTrace();
            return false;
        }
        if (!player.isOp() && !player.hasPermission(permission)) {
            return false;
        }
        return true;
    }

    public Player getPlayer() throws GTException {
        if (this.sender instanceof Player) {
            return (Player)this.sender;
        }
        throw new GTException("You must be a player to execute this command");
    }

    public static void sendMessage(Object sender, String line) {
        if (sender instanceof Player) {
            ((Player)sender).sendMessage(line);
        } else if (sender instanceof CommandSender) {
            ((CommandSender)sender).sendMessage(line);
        }
    }

    public static void sendMessage(Object sender, String[] lines) {
        boolean isPlayer = false;
        if (sender instanceof Player) {
            isPlayer = true;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (isPlayer) {
                ((Player)sender).sendMessage(line);
            } else {
                ((CommandSender)sender).sendMessage(line);
            }
            ++n2;
        }
    }

    public static String buildTitle(String title) {
        String line = "-------------------------------------------------";
        String titleBracket = "[ \u00a7e" + title + "\u00a7b" + " ]";
        if (titleBracket.length() > line.length()) {
            return "\u00a7b-" + titleBracket + "-";
        }
        int min = line.length() / 2 - titleBracket.length() / 2;
        int max = line.length() / 2 + titleBracket.length() / 2;
        String out = "\u00a7b" + line.substring(0, Math.max(0, min));
        out = String.valueOf(out) + titleBracket + line.substring(max);
        return out;
    }

    public static void sendHeading(CommandSender sender, String title) {
        CommandBase.sendMessage((Object)sender, CommandBase.buildTitle(title));
    }

    public static void sendError(Object sender, String line) {
        CommandBase.sendMessage(sender, "\u00a7c" + line);
    }
}

