/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class NameManager {
    private final HashMap<UUID, HashMap<String, Object>> cache = new HashMap();
    private int timer;
    private final String NAME_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";

    public NameManager() {
        this.startCacheTimer();
    }

    public String getName(UUID uuid) {
        return this.getName(uuid.toString());
    }

    public String getName(String uuid) {
        if (uuid.equalsIgnoreCase("console")) {
            return "CONSOLE";
        }
        if (Bukkit.getPlayer((UUID)UUID.fromString(uuid)) != null) {
            return Bukkit.getPlayer((UUID)UUID.fromString(uuid)).getName();
        }
        if (this.cache.containsKey(UUID.fromString(uuid))) {
            HashMap<String, Object> nc = this.cache.get(UUID.fromString(uuid));
            return (String)nc.get("Name");
        }
        try {
            HashMap<String, Object> sc = new HashMap<String, Object>();
            String dash = uuid;
            uuid = uuid.replace("-", "");
            String output = this.callURL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < 20000; ++i) {
                char curr;
                if (output.charAt(i) != 'n' || output.charAt(i + 1) != 'a' || output.charAt(i + 2) != 'm' || output.charAt(i + 3) != 'e') continue;
                for (int k = i + 9; k < 20000 && (curr = output.charAt(k)) != '\"'; ++k) {
                    result.append(curr);
                }
                break;
            }
            sc.put("Name", result.toString());
            sc.put("Timer", System.currentTimeMillis());
            this.cache.put(UUID.fromString(dash), sc);
            return result.toString();
        }
        catch (Exception e) {
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid)).getName();
        }
    }

    private String callURL(String urlStr) {
        StringBuilder sb = new StringBuilder();
        try {
            URL url = new URL(urlStr);
            URLConnection urlConn = url.openConnection();
            if (urlConn != null) {
                urlConn.setReadTimeout(60000);
            }
            if (urlConn != null && urlConn.getInputStream() != null) {
                int cp;
                InputStreamReader in = new InputStreamReader(urlConn.getInputStream(), Charset.defaultCharset());
                BufferedReader bufferedReader = new BufferedReader(in);
                while ((cp = bufferedReader.read()) != -1) {
                    sb.append((char)cp);
                }
                bufferedReader.close();
                in.close();
            }
        }
        catch (Exception e) {
            if (AuctionHouse.getInstance().isDebug()) {
                e.printStackTrace();
            }
            AuctionHouse.getInstance().getChat().log("Error while trying to connect to NameManager URL.", false);
        }
        return sb.toString();
    }

    private void startCacheTimer() {
        this.timer = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)AuctionHouse.getInstance(), new Runnable(){

            @Override
            public void run() {
                ArrayList<UUID> toRemove = new ArrayList<UUID>();
                for (UUID uuid2 : NameManager.this.cache.keySet()) {
                    HashMap lc = (HashMap)NameManager.this.cache.get(uuid2);
                    long time = (Long)lc.get("Timer");
                    if (time + 600000L >= System.currentTimeMillis()) continue;
                    toRemove.add(uuid2);
                }
                toRemove.forEach(uuid -> NameManager.this.cache.remove(uuid));
            }
        }, 0L, 600L);
    }
}

