/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.logging.Level;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.database.transfer.DatabaseTransferStatusGUI;
import net.akarian.auctionhouse.utils.Chat;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MySQL {
    private Connection connection;
    private final Plugin plugin = AuctionHouse.getInstance();
    private String host;
    private String database;
    private String username;
    private String password;
    private String listingsTable;
    private String expiredTable;
    private String completedTable;
    private int port;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private boolean connected;
    private UUID transferring = null;

    public boolean setup() {
        if (!this.connected) {
            this.host = AuctionHouse.getInstance().getConfigFile().getDb_host();
            this.database = AuctionHouse.getInstance().getConfigFile().getDb_database();
            this.username = AuctionHouse.getInstance().getConfigFile().getDb_username();
            this.password = AuctionHouse.getInstance().getConfigFile().getDb_password();
            this.port = AuctionHouse.getInstance().getConfigFile().getDb_port();
            this.listingsTable = AuctionHouse.getInstance().getConfigFile().getDb_listings();
            this.expiredTable = AuctionHouse.getInstance().getConfigFile().getDb_expired();
            this.completedTable = AuctionHouse.getInstance().getConfigFile().getDb_completed();
            this.chat.log("---------- Akarian Auction House MySQL Manager ----------", AuctionHouse.getInstance().isDebug());
            this.chat.log("", AuctionHouse.getInstance().isDebug());
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
                this.chat.log("Connecting to the MySQL database...", AuctionHouse.getInstance().isDebug());
                this.setConnection(DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.username, this.password));
                this.chat.log("", AuctionHouse.getInstance().isDebug());
                this.chat.log(this.plugin.getName() + " has successfully established a connection to the MySQL database.", AuctionHouse.getInstance().isDebug());
                this.chat.log("", AuctionHouse.getInstance().isDebug());
                this.chat.log("Checking Tables...", AuctionHouse.getInstance().isDebug());
                this.chat.log("", AuctionHouse.getInstance().isDebug());
                if (this.checkTable(this.listingsTable, "ID VARCHAR(50) NOT NULL PRIMARY KEY, ITEM_STACK TEXT(65535) NOT NULL, PRICE DOUBLE NOT NULL, CREATOR varchar(255) NOT NULL, START bigint(20) NOT NULL, END bigint(20) DEFAULT '0', BUYER varchar(255) DEFAULT NULL")) {
                    this.chat.log("Listings table checked.", AuctionHouse.getInstance().isDebug());
                } else {
                    this.chat.log("!! Listings Table Failed Check !!", AuctionHouse.getInstance().isDebug());
                }
                if (this.checkTable(this.expiredTable, "ID varchar(50) NOT NULL PRIMARY KEY, ITEM_STACK TEXT(65535) NOT NULL, PRICE DOUBLE NOT NULL, CREATOR varchar(255) NOT NULL, START bigint(20) NOT NULL, END bigint(20) NOT NULL, REASON varchar(255) NOT NULL, RECLAIMED BOOLEAN DEFAULT '0'")) {
                    this.chat.log("Expired table checked.", AuctionHouse.getInstance().isDebug());
                } else {
                    this.chat.log("!! Expired Table Failed Check !!", AuctionHouse.getInstance().isDebug());
                }
                if (this.checkTable(this.completedTable, "ID varchar(50) NOT NULL PRIMARY KEY, ITEM_STACK TEXT(65535) NOT NULL, PRICE DOUBLE NOT NULL, CREATOR varchar(255) NOT NULL, START bigint(20) NOT NULL, END bigint(20) NOT NULL, BUYER varchar(255) NOT NULL")) {
                    this.chat.log("Completed table checked.", AuctionHouse.getInstance().isDebug());
                } else {
                    this.chat.log("!! Completed Table Failed Check !!", AuctionHouse.getInstance().isDebug());
                }
                this.chat.log("", AuctionHouse.getInstance().isDebug());
                this.chat.log("Starting connection timer.", AuctionHouse.getInstance().isDebug());
                this.startConnectionTimer();
                this.chat.log("---------------------------------------------", AuctionHouse.getInstance().isDebug());
                if (this.transferring != null) {
                    Bukkit.getPlayer((UUID)this.transferring).openInventory(new DatabaseTransferStatusGUI(Bukkit.getPlayer((UUID)this.transferring)).getInventory());
                }
                this.connected = true;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.plugin.getLogger().log(Level.SEVERE, "An error has occurred while connecting to the database. Please see stacktrace above.");
                this.chat.log("", AuctionHouse.getInstance().isDebug());
                this.chat.log("---------------------------------------------", AuctionHouse.getInstance().isDebug());
                if (this.transferring != null) {
                    Bukkit.getPlayer((UUID)this.transferring).openInventory(new DatabaseTransferStatusGUI(Bukkit.getPlayer((UUID)this.transferring)).connectionDisapproved());
                }
                if (e.getCause() == null) {
                    return false;
                }
                this.chat.alert("&c&l" + this.plugin.getName() + " has encountered an error connecting to the MySQL database. Please check console. E" + e.getCause().getLocalizedMessage());
                this.connected = false;
                return false;
            }
        }
        return true;
    }

    public boolean checkTable(String tableName, String query) {
        try {
            Statement s = this.connection.createStatement();
            s.executeUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " (" + query + ")");
            if (tableName.equalsIgnoreCase(this.expiredTable)) {
                try {
                    s.executeUpdate("ALTER TABLE " + this.expiredTable + " ADD COLUMN PRICE DOUBLE NOT NULL AFTER ITEM_STACK");
                    s.executeUpdate("ALTER TABLE " + this.expiredTable + " ADD COLUMN START bigint(20) NOT NULL AFTER CREATOR");
                    s.executeUpdate("ALTER TABLE " + this.expiredTable + " ADD COLUMN END bigint(20) NOT NULL AFTER START");
                    s.executeUpdate("ALTER TABLE " + this.expiredTable + " ADD COLUMN REASON varchar(255) NOT NULL AFTER END");
                    s.executeUpdate("ALTER TABLE " + this.expiredTable + " ADD COLUMN RECLAIMED BOOLEAN DEFAULT 0 AFTER REASON");
                    return true;
                }
                catch (SQLException e) {
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void startConnectionTimer() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> {
            if (this.reconnect()) {
                this.chat.log("Successfully established reconnection timer to the database.", AuctionHouse.getInstance().isDebug());
            } else {
                this.chat.log("Failed to establish reconnection timer.", AuctionHouse.getInstance().isDebug());
            }
        }, 0L, 72000L);
    }

    public boolean reconnect() {
        try {
            if (this.getConnection().isClosed()) {
                this.setConnection(DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.username, this.password));
                this.chat.log("Successfully reconnected to MySQL Database.", AuctionHouse.getInstance().isDebug());
            } else {
                this.chat.log("Connection to Database not closed. Not reconnecting.", AuctionHouse.getInstance().isDebug());
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.chat.log("!! Failed to reconnect to MySQL Database.", AuctionHouse.getInstance().isDebug());
            return false;
        }
    }

    public boolean shutdown() {
        try {
            this.connection.close();
            this.chat.log("MySQL Connection has successfully shut down.", AuctionHouse.getInstance().isDebug());
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.chat.log("!! MySQL Connection failed to shut down.", AuctionHouse.getInstance().isDebug());
            return false;
        }
        this.connected = false;
        return true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getListingsTable() {
        return this.listingsTable;
    }

    public String getExpiredTable() {
        return this.expiredTable;
    }

    public String getCompletedTable() {
        return this.completedTable;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public UUID getTransferring() {
        return this.transferring;
    }

    public void setTransferring(UUID transferring) {
        this.transferring = transferring;
    }
}

