/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.utils;

import java.util.List;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.utils.UUIDDataType;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemBuilder {
    public static ItemStack build(Material material, int amount, String name, List<String> lore, String ... settings) {
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        meta.setLore(AuctionHouse.getInstance().getChat().formatList(lore));
        meta.setDisplayName(AuctionHouse.getInstance().getChat().format(name));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        for (String s : settings) {
            if (s.equalsIgnoreCase("shine")) {
                item.addUnsafeEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
                continue;
            }
            if (!s.contains("uuid_")) continue;
            NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "builder-uuid");
            meta = item.getItemMeta();
            meta.getPersistentDataContainer().set(key, (PersistentDataType)new UUIDDataType(), (Object)UUID.fromString(s.split("_")[1]));
            item.setItemMeta(meta);
        }
        return item;
    }
}

