/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.utils;

import java.util.ArrayList;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.utils.AkarianConfiguration;
import net.akarian.auctionhouse.utils.DatabaseType;
import net.akarian.auctionhouse.utils.FileManager;

public class Configuration {
    private final FileManager fm = AuctionHouse.getInstance().getFileManager();
    private String prefix;
    private String db_database;
    private String db_host;
    private String db_username;
    private String db_password;
    private String db_listings;
    private String db_expired;
    private String db_completed;
    private String listingFee;
    private DatabaseType databaseType;
    private boolean updates;
    private boolean dps_adminMode;
    private boolean dps_bought;
    private boolean dps_create;
    private boolean dps_expire;
    private boolean dps_autoConfirm;
    private boolean creativeListing;
    private double minListing;
    private double maxListing;
    private long dps_expireTime;
    private int listingDelay;
    private int listingTime;
    private int db_port;
    private AkarianConfiguration configFile;

    public Configuration() {
        if (!this.fm.getFile("config").exists()) {
            this.fm.createFile("config");
        }
        this.reloadConfig();
    }

    public void setDatabaseType(DatabaseType type) {
        this.configFile = this.fm.getConfig("config");
        this.configFile.set("database", type.toString());
        this.fm.saveFile(this.configFile, "config");
        this.databaseType = type;
        AuctionHouse.getInstance().setDatabaseType(this.databaseType);
    }

    public void reloadConfig() {
        this.configFile = this.fm.getConfig("config");
        ArrayList<String> header = new ArrayList<String>();
        header.add("Akarian Auction House v" + AuctionHouse.getInstance().getDescription().getVersion());
        header.add(" ");
        header.add("database: This is how the database will be saved. Available types are FILE MYSQL FILE2MYSQL MYSQL2FILE");
        header.add("updates: Whether or not to enable updates.");
        header.add("Listing Delay: Delay between listings. Set to 0 to disable. Permission to bypass \"auctionhouse.delay.bypass\"");
        header.add("Listing Time: Time that a listing is on the auction house in seconds. 86400 = 1 day.");
        header.add("Listing Fee: For percentage of listing, use \"5%\". To take a flat rate, use \"5\".");
        this.configFile.setHeader(header);
        if (!this.configFile.contains("Prefix")) {
            this.configFile.set("Prefix", "&6&lAuctionHouse");
        }
        this.prefix = this.configFile.getString("Prefix");
        if (!this.configFile.contains("Debug")) {
            this.configFile.set("Debug", false);
        }
        AuctionHouse.getInstance().setDebug(this.configFile.getBoolean("Debug"));
        if (!this.configFile.contains("database")) {
            this.configFile.set("database", "FILE");
        }
        this.databaseType = DatabaseType.getByStr(this.configFile.getString("database"));
        if (!this.configFile.contains("updates")) {
            this.configFile.set("updates", true);
        } else if (this.configFile.isString("updates")) {
            if (this.configFile.getString("updates").equalsIgnoreCase("true")) {
                this.configFile.set("updates", true);
            } else if (this.configFile.getString("updates").equalsIgnoreCase("false")) {
                this.configFile.set("updates", false);
            }
        }
        this.updates = this.configFile.getBoolean("updates");
        if (!this.configFile.contains("Minimum Listing")) {
            this.configFile.set("Minimum Listing", 10.0);
        }
        this.minListing = this.configFile.getDouble("Minimum Listing");
        if (!this.configFile.contains("Maximum Listing")) {
            this.configFile.set("Maximum Listing", 1.0E9);
        }
        this.maxListing = this.configFile.getDouble("Maximum Listing");
        if (!this.configFile.contains("Listing Delay")) {
            this.configFile.set("Listing Delay", 10);
        }
        this.listingDelay = this.configFile.getInt("Listing Delay");
        if (!this.configFile.contains("Listing Time")) {
            this.configFile.set("Listing Time", 86400);
        }
        this.listingTime = this.configFile.getInt("Listing Time");
        if (!this.configFile.contains("Listing Fee")) {
            this.configFile.set("Listing Fee", "0%");
        }
        this.listingFee = this.configFile.getString("Listing Fee");
        if (!this.configFile.contains("Default Player Settings.Admin Mode")) {
            this.configFile.set("Default Player Settings.Admin Mode", false);
        }
        this.dps_adminMode = this.configFile.getBoolean("Default Player Settings.Admin Mode");
        if (!this.configFile.contains("Default Player Settings.Expire Notify")) {
            this.configFile.set("Default Player Settings.Expire Notify", false);
        }
        this.dps_expire = this.configFile.getBoolean("Default Player Settings.Expire Notify");
        if (!this.configFile.contains("Default Player Settings.Expire Time")) {
            this.configFile.set("Default Player Settings.Expire Time", 300);
        }
        this.dps_expireTime = this.configFile.getLong("Default Player Settings.Expire Time");
        if (!this.configFile.contains("Default Player Settings.Bought Notify")) {
            this.configFile.set("Default Player Settings.Bought Notify", false);
        }
        this.dps_bought = this.configFile.getBoolean("Default Player Settings.Bought Notify");
        if (!this.configFile.contains("Default Player Settings.Create Notify")) {
            this.configFile.set("Default Player Settings.Create Notify", true);
        }
        this.dps_create = this.configFile.getBoolean("Default Player Settings.Create Notify");
        if (!this.configFile.contains("Default Player Settings.Auto Confirm Listing")) {
            this.configFile.set("Default Player Settings.Auto Confirm Listing", false);
        }
        this.dps_autoConfirm = this.configFile.getBoolean("Default Player Settings.Auto Confirm Listing");
        if (!this.configFile.contains("Creative Listing")) {
            this.configFile.set("Creative Listing", false);
        }
        this.creativeListing = this.configFile.getBoolean("Creative Listing");
        if (!this.configFile.contains("MySQL.Connection.Host")) {
            this.configFile.set("MySQL.Connection.Host", "localhost");
        }
        this.db_host = this.configFile.getString("MySQL.Connection.Host");
        if (!this.configFile.contains("MySQL.Connection.Port")) {
            this.configFile.set("MySQL.Connection.Port", 3306);
        }
        this.db_port = this.configFile.getInt("MySQL.Connection.Port");
        if (!this.configFile.contains("MySQL.Connection.Username")) {
            this.configFile.set("MySQL.Connection.Username", "test");
        }
        this.db_username = this.configFile.getString("MySQL.Connection.Username");
        if (!this.configFile.contains("MySQL.Connection.Password")) {
            this.configFile.set("MySQL.Connection.Password", "password");
        }
        this.db_password = this.configFile.getString("MySQL.Connection.Password");
        if (!this.configFile.contains("MySQL.Connection.Database")) {
            this.configFile.set("MySQL.Connection.Database", "database");
        }
        this.db_database = this.configFile.getString("MySQL.Connection.Database");
        if (!this.configFile.contains("MySQL.Tables.Listings")) {
            this.configFile.set("MySQL.Tables.Listings", "ah_listings");
        }
        this.db_listings = this.configFile.getString("MySQL.Tables.Listings");
        if (!this.configFile.contains("MySQL.Tables.Completed")) {
            this.configFile.set("MySQL.Tables.Completed", "ah_completed");
        }
        this.db_completed = this.configFile.getString("MySQL.Tables.Completed");
        if (!this.configFile.contains("MySQL.Tables.Expired")) {
            this.configFile.set("MySQL.Tables.Expired", "ah_expired");
        }
        this.db_expired = this.configFile.getString("MySQL.Tables.Expired");
        this.fm.saveFile(this.configFile, "config");
    }

    public void saveConfig() {
        this.configFile = this.fm.getConfig("config");
        ArrayList<String> header = new ArrayList<String>();
        header.add("Akarian Auction House v" + AuctionHouse.getInstance().getDescription().getVersion());
        header.add(" ");
        header.add("database: This is how the database will be saved. Available types are FILE MYSQL FILE2MYSQL MYSQL2FILE");
        header.add("updates: Whether or not to enable updates.");
        header.add("Listing Delay: Delay between listings. Set to 0 to disable. Permission to bypass \"auctionhouse.delay.bypass\"");
        header.add("Listing Time: Time that a listing is on the auction house in seconds. 86400 = 1 day.");
        header.add("Listing Fee: For percentage of listing, use \"5%\". To take a flat rate, use \"$5\".");
        this.configFile.setHeader(header);
        this.configFile.set("Prefix", this.prefix);
        this.configFile.set("Debug", AuctionHouse.getInstance().isDebug());
        this.configFile.set("database", this.databaseType.toString());
        this.configFile.set("updates", this.updates);
        this.configFile.set("Minimum Listing", this.minListing);
        this.configFile.set("Maximum Listing", this.maxListing);
        this.configFile.set("Listing Delay", this.listingDelay);
        this.configFile.set("Listing Time", this.listingTime);
        this.configFile.set("Listing Fee", this.listingFee);
        this.configFile.set("Default Player Settings.Admin Mode", this.dps_adminMode);
        this.configFile.set("Default Player Settings.Expire Notify", this.dps_expire);
        this.configFile.set("Default Player Settings.Expire Time", this.dps_expireTime);
        this.configFile.set("Default Player Settings.Bought Notify", this.dps_bought);
        this.configFile.set("Default Player Settings.Auto Confirm Listing", this.dps_autoConfirm);
        this.configFile.set("Default Player Settings.Create Notify", this.dps_create);
        this.configFile.set("Creative Listing", this.creativeListing);
        this.configFile.set("MySQL.Connection.Host", this.db_host);
        this.configFile.set("MySQL.Connection.Port", this.db_port);
        this.configFile.set("MySQL.Connection.Username", this.db_username);
        this.configFile.set("MySQL.Connection.Password", this.db_password);
        this.configFile.set("MySQL.Connection.Database", this.db_database);
        this.configFile.set("MySQL.Tables.Listings", this.db_listings);
        this.configFile.set("MySQL.Tables.Completed", this.db_completed);
        this.configFile.set("MySQL.Tables.Expired", this.db_expired);
        this.fm.saveFile(this.configFile, "config");
        this.reloadConfig();
    }

    public double calculateListingFee(double price) {
        if (this.listingFee.contains("%")) {
            double percentage = Double.parseDouble(this.listingFee.replace("%", "")) / 100.0;
            return price * percentage;
        }
        return Double.parseDouble(this.listingFee.replace("$", ""));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDb_database() {
        return this.db_database;
    }

    public String getDb_host() {
        return this.db_host;
    }

    public String getDb_username() {
        return this.db_username;
    }

    public String getDb_password() {
        return this.db_password;
    }

    public String getDb_listings() {
        return this.db_listings;
    }

    public String getDb_expired() {
        return this.db_expired;
    }

    public String getDb_completed() {
        return this.db_completed;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDb_database(String db_database) {
        this.db_database = db_database;
    }

    public void setDb_host(String db_host) {
        this.db_host = db_host;
    }

    public void setDb_username(String db_username) {
        this.db_username = db_username;
    }

    public void setDb_password(String db_password) {
        this.db_password = db_password;
    }

    public void setDb_listings(String db_listings) {
        this.db_listings = db_listings;
    }

    public void setDb_expired(String db_expired) {
        this.db_expired = db_expired;
    }

    public void setDb_completed(String db_completed) {
        this.db_completed = db_completed;
    }

    public String getListingFee() {
        return this.listingFee;
    }

    public void setListingFee(String listingFee) {
        this.listingFee = listingFee;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public boolean isUpdates() {
        return this.updates;
    }

    public boolean isDps_adminMode() {
        return this.dps_adminMode;
    }

    public boolean isDps_bought() {
        return this.dps_bought;
    }

    public boolean isDps_create() {
        return this.dps_create;
    }

    public boolean isDps_expire() {
        return this.dps_expire;
    }

    public boolean isDps_autoConfirm() {
        return this.dps_autoConfirm;
    }

    public boolean isCreativeListing() {
        return this.creativeListing;
    }

    public void setUpdates(boolean updates) {
        this.updates = updates;
    }

    public void setDps_adminMode(boolean dps_adminMode) {
        this.dps_adminMode = dps_adminMode;
    }

    public void setDps_bought(boolean dps_bought) {
        this.dps_bought = dps_bought;
    }

    public void setDps_create(boolean dps_create) {
        this.dps_create = dps_create;
    }

    public void setDps_expire(boolean dps_expire) {
        this.dps_expire = dps_expire;
    }

    public void setDps_autoConfirm(boolean dps_autoConfirm) {
        this.dps_autoConfirm = dps_autoConfirm;
    }

    public void setCreativeListing(boolean creativeListing) {
        this.creativeListing = creativeListing;
    }

    public double getMinListing() {
        return this.minListing;
    }

    public double getMaxListing() {
        return this.maxListing;
    }

    public void setMinListing(double minListing) {
        this.minListing = minListing;
    }

    public void setMaxListing(double maxListing) {
        this.maxListing = maxListing;
    }

    public long getDps_expireTime() {
        return this.dps_expireTime;
    }

    public void setDps_expireTime(long dps_expireTime) {
        this.dps_expireTime = dps_expireTime;
    }

    public int getListingDelay() {
        return this.listingDelay;
    }

    public int getListingTime() {
        return this.listingTime;
    }

    public int getDb_port() {
        return this.db_port;
    }

    public void setListingDelay(int listingDelay) {
        this.listingDelay = listingDelay;
    }

    public void setListingTime(int listingTime) {
        this.listingTime = listingTime;
    }

    public void setDb_port(int db_port) {
        this.db_port = db_port;
    }

    public AkarianConfiguration getConfigFile() {
        return this.configFile;
    }
}

