/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import net.akarian.auctionhouse.AuctionHouse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Chat {
    private String prefix;
    private final Plugin plugin;

    public Chat(Plugin plugin, String prefix) {
        this.plugin = plugin;
        this.prefix = prefix;
    }

    public String format(String str) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)str);
    }

    public String formatMoney(Object obj) {
        return AuctionHouse.getInstance().getEcon().format(Double.parseDouble(obj.toString()));
    }

    public String formatTime(long se) {
        long delay = se;
        String s = "";
        if (delay >= 86400L) {
            long days = delay / 86400L;
            s = days >= 2L ? s + days + "d " : s + "1d ";
            if ((delay -= days * 86400L) >= 3600L) {
                long hours = delay / 3600L;
                s = hours >= 2L ? s + hours + "h " : s + "1h ";
                if ((delay -= hours * 3600L) >= 60L) {
                    long minutes = delay / 60L;
                    s = minutes >= 2L ? s + minutes + "m " : s + "1m";
                    delay -= minutes * 60L;
                } else {
                    s = s + "0m ";
                }
            } else {
                s = s + "0h ";
                if (delay >= 60L) {
                    long minutes = delay / 60L;
                    s = minutes >= 2L ? s + minutes + "m " : s + "1m";
                    delay -= minutes * 60L;
                } else {
                    s = s + "0m ";
                }
            }
        } else if (delay >= 3600L) {
            long hours = delay / 3600L;
            s = hours >= 2L ? s + hours + "h " : s + "1h ";
            if ((delay -= hours * 3600L) >= 60L) {
                long minutes = delay / 60L;
                s = minutes >= 2L ? s + minutes + "m " : s + "1m ";
                delay -= minutes * 60L;
            }
        } else if (delay >= 60L) {
            long minutes = delay / 60L;
            s = minutes >= 2L ? s + minutes + "m " : s + "1m ";
            delay -= minutes * 60L;
        }
        s = delay >= 1L ? (delay >= 2L ? s + delay + "s " : s + "1s ") : s + "0s ";
        return s.trim();
    }

    public ArrayList<String> formatList(List<String> list) {
        ArrayList<String> formatted = new ArrayList<String>();
        for (String str : list) {
            if (str == null) continue;
            formatted.add(this.format(str.replace("-", "\u2505")));
        }
        return formatted;
    }

    public String formatDate(Long val) {
        Date date = new Date(val);
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        return formatter.format(date);
    }

    public void noPermission(CommandSender sender) {
        sender.sendMessage(this.format("&cYou do not have permission to execute this command!"));
    }

    public void debug(String str) {
        this.plugin.getLogger().log(Level.INFO, "DEBUG: " + str);
        this.alert("&4DEBUG: &e" + str);
    }

    public void usage(CommandSender sender, String m) {
        sender.sendMessage(this.format("&cIncorrect Usage: &7&o" + m));
    }

    public void sendRawMessage(CommandSender sender, String str) {
        sender.sendMessage(this.format(str));
    }

    public void sendMessage(CommandSender sender, String str) {
        sender.sendMessage(this.format(this.prefix + " &8" + AuctionHouse.getInstance().getMessages().getPrefixIcon() + " &7" + str));
    }

    public void broadcastRawMessage(String str) {
        Bukkit.broadcastMessage((String)this.format(str));
    }

    public void broadcastMessage(String str) {
        Bukkit.broadcastMessage((String)this.format(this.prefix + " &8" + AuctionHouse.getInstance().getMessages().getPrefixIcon() + " &7" + str));
    }

    public String formatItem(ItemStack itemStack) {
        Material material = itemStack.getType();
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            String name = itemStack.getItemMeta().getDisplayName();
            return this.format("&e" + itemStack.getAmount() + "x " + name);
        }
        StringBuilder builder = new StringBuilder();
        for (String word : material.toString().split("_")) {
            builder.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return this.format(itemStack.getAmount() + "x " + builder.toString().trim());
    }

    public void alert(String str) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.isOp()) continue;
            this.sendMessage((CommandSender)p, str);
        }
        this.sendMessage((CommandSender)Bukkit.getConsoleSender(), str);
    }

    public void log(String str, boolean console) {
        DateTimeFormatter logStart = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        if (console) {
            AuctionHouse.getInstance().getLogger().log(Level.INFO, str);
        }
        try {
            File saveTo = new File(this.plugin.getDataFolder() + "/logs", "log.txt");
            if (!this.plugin.getDataFolder().isDirectory()) {
                this.plugin.getDataFolder().mkdir();
            }
            if (!new File(this.plugin.getDataFolder() + "/logs").isDirectory()) {
                new File(this.plugin.getDataFolder() + "/logs").mkdir();
            }
            if (!saveTo.exists()) {
                saveTo.createNewFile();
            }
            FileWriter fw = new FileWriter(saveTo, true);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("[" + logStart.format(now) + "] " + str);
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

