/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.users;

import java.util.ArrayList;
import java.util.List;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.users.User;
import net.akarian.auctionhouse.utils.AkarianConfiguration;
import net.akarian.auctionhouse.utils.FileManager;

public class UserSettings {
    private final User user;
    private final FileManager fm;
    private boolean alertCreateListings;
    private boolean openAdminMode;
    private boolean alertNearExpire;
    private long alertNearExpireTime;
    private boolean alertListingBought;
    private boolean autoConfirmListing;
    private List<Listing> notified;

    public UserSettings(User user) {
        this.user = user;
        this.fm = AuctionHouse.getInstance().getFileManager();
        this.notified = new ArrayList<Listing>();
    }

    public UserSettings create() {
        AkarianConfiguration usersFile = this.fm.getConfig("/database/users");
        usersFile.set(this.user.getUuid().toString() + ".Alert Create Listings", AuctionHouse.getInstance().getConfigFile().isDps_create());
        usersFile.set(this.user.getUuid().toString() + ".Open Admin Mode", AuctionHouse.getInstance().getConfigFile().isDps_adminMode());
        usersFile.set(this.user.getUuid().toString() + ".Alert Near Expire.Status", AuctionHouse.getInstance().getConfigFile().isDps_expire());
        usersFile.set(this.user.getUuid().toString() + ".Alert Near Expire.Time", AuctionHouse.getInstance().getConfigFile().getDps_expireTime());
        usersFile.set(this.user.getUuid().toString() + ".Alert Listing Bought", AuctionHouse.getInstance().getConfigFile().isDps_bought());
        usersFile.set(this.user.getUuid().toString() + ".Auto Confirm Listing", AuctionHouse.getInstance().getConfigFile().isDps_autoConfirm());
        this.fm.saveFile(usersFile, "/database/users");
        return this;
    }

    public UserSettings load() {
        AkarianConfiguration usersFile = this.fm.getConfig("/database/users");
        this.alertCreateListings = usersFile.getBoolean(this.user.getUuid().toString() + ".Alert Create Listings");
        this.openAdminMode = usersFile.getBoolean(this.user.getUuid().toString() + ".Open Admin Mode");
        this.alertNearExpire = usersFile.getBoolean(this.user.getUuid().toString() + ".Alert Near Expire.Status");
        this.alertNearExpireTime = usersFile.getLong(this.user.getUuid().toString() + ".Alert Near Expire.Time");
        this.alertListingBought = usersFile.getBoolean(this.user.getUuid().toString() + ".Alert Listing Bought");
        this.autoConfirmListing = usersFile.getBoolean(this.user.getUuid().toString() + ".Auto Confirm Listing");
        return this;
    }

    public UserSettings save() {
        AkarianConfiguration usersFile = this.fm.getConfig("/database/users");
        usersFile.set(this.user.getUuid().toString() + ".Alert Create Listings", this.alertCreateListings);
        usersFile.set(this.user.getUuid().toString() + ".Open Admin Mode", this.openAdminMode);
        usersFile.set(this.user.getUuid().toString() + ".Alert Near Expire.Status", this.alertNearExpire);
        usersFile.set(this.user.getUuid().toString() + ".Alert Near Expire.Time", this.alertNearExpireTime);
        usersFile.set(this.user.getUuid().toString() + ".Alert Listing Bought", this.alertListingBought);
        usersFile.set(this.user.getUuid().toString() + ".Auto Confirm Listing", this.autoConfirmListing);
        this.fm.saveFile(usersFile, "/database/users");
        return this;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isAlertCreateListings() {
        return this.alertCreateListings;
    }

    public void setAlertCreateListings(boolean alertCreateListings) {
        this.alertCreateListings = alertCreateListings;
    }

    public boolean isOpenAdminMode() {
        return this.openAdminMode;
    }

    public void setOpenAdminMode(boolean openAdminMode) {
        this.openAdminMode = openAdminMode;
    }

    public boolean isAlertNearExpire() {
        return this.alertNearExpire;
    }

    public void setAlertNearExpire(boolean alertNearExpire) {
        this.alertNearExpire = alertNearExpire;
    }

    public long getAlertNearExpireTime() {
        return this.alertNearExpireTime;
    }

    public void setAlertNearExpireTime(long alertNearExpireTime) {
        this.alertNearExpireTime = alertNearExpireTime;
    }

    public boolean isAlertListingBought() {
        return this.alertListingBought;
    }

    public void setAlertListingBought(boolean alertListingBought) {
        this.alertListingBought = alertListingBought;
    }

    public boolean isAutoConfirmListing() {
        return this.autoConfirmListing;
    }

    public void setAutoConfirmListing(boolean autoConfirmListing) {
        this.autoConfirmListing = autoConfirmListing;
    }

    public List<Listing> getNotified() {
        return this.notified;
    }
}

