/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.users;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.akarian.auctionhouse.users.User;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class UserManager {
    public final List<User> users = new ArrayList<User>();

    public UserManager() {
        this.loadOnlineUsers();
    }

    public User getUser(Player player) {
        for (User u : this.users) {
            if (!u.getUuid().toString().equalsIgnoreCase(player.getUniqueId().toString())) continue;
            return u;
        }
        return null;
    }

    public void saveUsers() {
        for (User user : this.users) {
            user.getUserSettings().save();
        }
    }

    public void loadOnlineUsers() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.loadUser(p.getUniqueId());
        }
    }

    public User loadUser(UUID uuid) {
        User user = new User(uuid);
        this.users.add(user);
        user.loadUserSettings();
        return user;
    }

    public void unloadUser(User user) {
        this.users.remove(user);
        user.getUserSettings().save();
    }

    public List<User> getUsers() {
        return this.users;
    }
}

