/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.users;

import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.users.UserSettings;
import net.akarian.auctionhouse.utils.AkarianConfiguration;
import net.akarian.auctionhouse.utils.FileManager;

public class User {
    private final UUID uuid;
    private final FileManager fm;
    private UserSettings userSettings;

    public User(UUID uuid) {
        this.uuid = uuid;
        this.fm = AuctionHouse.getInstance().getFileManager();
    }

    public UserSettings createUserSettings() {
        this.userSettings = new UserSettings(this).create();
        return this.userSettings;
    }

    public UserSettings loadUserSettings() {
        AkarianConfiguration usersFile = this.fm.getConfig("/database/users");
        if (!usersFile.isConfigurationSection(this.uuid.toString())) {
            this.userSettings = this.createUserSettings().load();
            return this.userSettings;
        }
        this.userSettings = new UserSettings(this).load();
        return this.userSettings;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public UserSettings getUserSettings() {
        return this.userSettings;
    }
}

