/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.updater;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import net.akarian.auctionhouse.AuctionHouse;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class Updater {
    private static final String USER_AGENT = "Updater by Stipess1 Revised by KaYoz";
    private static final String DOWNLOAD = "/download";
    private static final String VERSIONS = "/versions";
    private static final String PAGE = "?page=";
    private static final String API_RESOURCE = "https://api.spiget.org/v2/resources/";
    private final Plugin plugin;
    private final File updateFolder;
    private final File file;
    private final int id;
    private final UpdateType updateType;
    private final boolean logger;
    private final boolean restart;
    private final Thread thread;
    private String downloadLink;
    private int page = 1;
    private Result result = Result.SUCCESS;
    private boolean emptyPage;
    private String version;

    public Updater(Plugin plugin, int id, File file, UpdateType updateType, boolean logger, boolean restart) {
        this.plugin = plugin;
        this.updateFolder = plugin.getServer().getUpdateFolderFile();
        this.id = id;
        this.file = file;
        this.updateType = updateType;
        this.logger = logger;
        this.restart = restart;
        this.downloadLink = API_RESOURCE + id;
        this.thread = new Thread(new UpdaterRunnable());
        this.thread.start();
    }

    public Result getResult() {
        this.waitThread();
        return this.result;
    }

    public String getVersion() {
        this.waitThread();
        return this.version;
    }

    private boolean checkResource(String link) {
        try {
            URL url = new URL(link);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", USER_AGENT);
            int code = connection.getResponseCode();
            if (code != 200) {
                connection.disconnect();
                this.result = Result.BAD_ID;
                return false;
            }
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void checkUpdate() {
        try {
            String page = Integer.toString(this.page);
            URL url = new URL(API_RESOURCE + this.id + VERSIONS + PAGE + page);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", USER_AGENT);
            InputStream inputStream = connection.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            JsonElement element = new JsonParser().parse((Reader)reader);
            JsonArray jsonArray = element.getAsJsonArray();
            if (jsonArray.size() == 10 && !this.emptyPage) {
                connection.disconnect();
                ++this.page;
                this.checkUpdate();
            } else if (jsonArray.size() == 0) {
                this.emptyPage = true;
                --this.page;
                this.checkUpdate();
            } else if (jsonArray.size() < 10) {
                element = jsonArray.get(jsonArray.size() - 1);
                JsonObject object = element.getAsJsonObject();
                element = object.get("name");
                this.version = element.toString().replaceAll("\"", "").replace("v", "");
                if (this.logger) {
                    this.plugin.getLogger().info("Checking for update...");
                }
                if (this.shouldUpdate(this.version, this.plugin.getDescription().getVersion()) && this.updateType == UpdateType.VERSION_CHECK) {
                    this.result = Result.UPDATE_FOUND;
                    if (this.logger) {
                        this.plugin.getLogger().info("Update found!");
                    }
                } else if (this.updateType == UpdateType.DOWNLOAD) {
                    if (this.logger) {
                        this.plugin.getLogger().info("Downloading update... version not checked");
                    }
                    this.download();
                } else if (this.updateType == UpdateType.CHECK_DOWNLOAD) {
                    if (this.shouldUpdate(this.version, this.plugin.getDescription().getVersion())) {
                        if (this.logger) {
                            this.plugin.getLogger().info("Update found, downloading now...");
                        }
                        this.download();
                    } else {
                        if (this.logger) {
                            this.plugin.getLogger().info("Update not found");
                        }
                        this.result = Result.NO_UPDATE;
                    }
                } else {
                    if (this.logger) {
                        this.plugin.getLogger().info("Update not found");
                    }
                    this.result = Result.NO_UPDATE;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean shouldUpdate(String newVersion, String oldVersion) {
        return !newVersion.equalsIgnoreCase(oldVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download() {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL url = new URL(this.downloadLink);
            this.plugin.getLogger().log(Level.INFO, url.toString());
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(new File(this.updateFolder, this.file.getName()));
            byte[] data = new byte[4096];
            while ((count = in.read(data, 0, 4096)) != -1) {
                fout.write(data, 0, count);
            }
        }
        catch (Exception e) {
            if (this.logger) {
                this.plugin.getLogger().log(Level.SEVERE, "Updater tried to download the update, but was unsuccessful.");
            }
            this.result = Result.FAILED;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, null, e);
                e.printStackTrace();
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.plugin.getLogger().log(Level.SEVERE, null, e);
            }
            if (this.restart && this.result != Result.FAILED) {
                Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"restart"));
            }
        }
    }

    private void waitThread() {
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                this.plugin.getLogger().log(Level.SEVERE, null, e);
            }
        }
    }

    public static enum Result {
        UPDATE_FOUND,
        NO_UPDATE,
        SUCCESS,
        FAILED,
        BAD_ID;

    }

    public static enum UpdateType {
        VERSION_CHECK,
        DOWNLOAD,
        CHECK_DOWNLOAD;

    }

    public class UpdaterRunnable
    implements Runnable {
        @Override
        public void run() {
            if (Updater.this.checkResource(Updater.this.downloadLink)) {
                Updater.this.downloadLink = Updater.this.downloadLink + Updater.DOWNLOAD;
                Updater.this.checkUpdate();
            }
        }
    }
}

