/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.updater;

import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.updater.Updater;
import net.akarian.auctionhouse.utils.Chat;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class UpdateManager {
    private final int spigotID = 97504;
    private final AuctionHouse plugin;
    private final Chat chat;
    private Updater updater;

    public UpdateManager(AuctionHouse plugin) {
        this.plugin = plugin;
        this.chat = plugin.getChat();
        if (plugin.isUpdate()) {
            this.reloadUpdater();
            if (this.isUpdate() == 2) {
                this.chat.alert("&eAn update has been found.");
                this.chat.log("Update found", AuctionHouse.getInstance().isDebug());
            }
        } else {
            this.chat.log("Updates are disabled. Disabling Update Manager", AuctionHouse.getInstance().isDebug());
        }
    }

    private void reloadUpdater() {
        if (this.plugin.isUpdate()) {
            this.updater = new Updater((Plugin)this.plugin, 97504, this.plugin.getDataFolder(), Updater.UpdateType.VERSION_CHECK, false, false);
        }
    }

    public int isUpdate() {
        if (!this.plugin.isUpdate()) {
            return -1;
        }
        this.reloadUpdater();
        if (this.updater.getResult() == Updater.Result.BAD_ID) {
            return 0;
        }
        if (this.updater.getResult() == Updater.Result.NO_UPDATE) {
            return 1;
        }
        if (this.updater.getResult() == Updater.Result.UPDATE_FOUND) {
            return 2;
        }
        return 3;
    }

    public void update(CommandSender sender, boolean restart) {
        if (restart) {
            this.chat.sendRawMessage(sender, "&8&m&l------------------------------------");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "  &6&lAuctionHouse &fUpdater");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "&aThe plugin is updating. When complete, the server will restart.");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "&8&m&l------------------------------------");
        } else {
            this.chat.sendRawMessage(sender, "&8&m&l------------------------------------");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "  &6&lAuctionHouse &fUpdater");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "&8(&c&l!&8) &6The plugin is updating. When complete, please restart your server.");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "&8&m&l------------------------------------");
        }
        this.updater = new Updater((Plugin)this.plugin, 97504, this.plugin.getDataFolder(), Updater.UpdateType.CHECK_DOWNLOAD, true, restart);
        if (this.updater.getResult() == Updater.Result.SUCCESS && !restart) {
            this.chat.sendRawMessage(sender, "&8&m&l------------------------------------");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "  &6&lAuctionHouse &fUpdater");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "&8(&c&l!&8) &eThe plugin is finished updating. Please restart the server.");
            this.chat.sendRawMessage(sender, "");
            this.chat.sendRawMessage(sender, "&8&m&l------------------------------------");
        } else if (this.updater.getResult() == Updater.Result.FAILED) {
            this.chat.alert("&cAn error has occurred whilst trying to update and failed.");
        }
    }

    public Updater getUpdater() {
        return this.updater;
    }
}

