/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.listings;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.database.transfer.DatabaseTransferStatusGUI;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.users.User;
import net.akarian.auctionhouse.utils.AkarianConfiguration;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.DatabaseType;
import net.akarian.auctionhouse.utils.FileManager;
import net.akarian.auctionhouse.utils.InventoryHandler;
import net.akarian.auctionhouse.utils.MySQL;
import net.akarian.auctionhouse.utils.UUIDDataType;
import net.akarian.auctionhouse.utils.events.ListingBoughtEvent;
import net.akarian.auctionhouse.utils.events.ListingCreateEvent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ListingManager {
    private final MySQL mySQL = AuctionHouse.getInstance().getMySQL();
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final List<Listing> active;
    private final List<Listing> unclaimed;
    private final List<Listing> expired;
    private final List<Listing> completed;
    private DatabaseType databaseType = AuctionHouse.getInstance().getDatabaseType();
    private final FileManager fm = AuctionHouse.getInstance().getFileManager();
    private int expireTimer;
    private int refreshTimer;
    private boolean transferring = false;

    public ListingManager() {
        this.active = new ArrayList<Listing>();
        this.unclaimed = new ArrayList<Listing>();
        this.expired = new ArrayList<Listing>();
        this.completed = new ArrayList<Listing>();
        this.loadListings();
        this.loadExpired();
        this.loadCompleted();
    }

    public boolean transferToFile(final Player player, final DatabaseTransferStatusGUI inv) {
        this.transferring = true;
        this.chat.log("&eStarting transfer from MySQL to File initiated by " + player.getName() + ".", false);
        this.chat.log("Creating Files...", false);
        this.chat.alert("&eStarting transfer from MySQL to File initiated by " + player.getName() + ".");
        this.chat.alert("Creating Files...");
        if (!this.fm.getFile("/database/listings").exists()) {
            this.fm.createFile("/database/listings");
        }
        if (!this.fm.getFile("/database/expired").exists()) {
            this.fm.createFile("/database/expired");
        }
        if (!this.fm.getFile("/database/completed").exists()) {
            this.fm.createFile("/database/completed");
        }
        this.chat.log("Files created. Starting Transferring Process...", false);
        this.chat.alert("Files created. Starting Transferring Process...");
        long startTime = System.currentTimeMillis();
        final AtomicInteger lt = new AtomicInteger(0);
        final AtomicInteger et = new AtomicInteger(0);
        final AtomicInteger ct = new AtomicInteger(0);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
            PreparedStatement delete;
            String id;
            ResultSet rs;
            PreparedStatement statement;
            AkarianConfiguration listingsFile = this.fm.getConfig("/database/listings");
            AkarianConfiguration expiredFile = this.fm.getConfig("/database/expired");
            AkarianConfiguration completedFile = this.fm.getConfig("/database/completed");
            try {
                statement = this.mySQL.getConnection().prepareStatement("SELECT * FROM " + this.mySQL.getListingsTable());
                rs = statement.executeQuery();
                while (rs.next()) {
                    id = rs.getString(1);
                    listingsFile.set(id + ".ItemStack", rs.getString(2));
                    listingsFile.set(id + ".Price", rs.getDouble(3));
                    listingsFile.set(id + ".Creator", rs.getString(4));
                    listingsFile.set(id + ".Start", rs.getLong(5));
                    lt.getAndIncrement();
                    delete = this.mySQL.getConnection().prepareStatement("DELETE FROM " + this.mySQL.getListingsTable() + " WHERE ID=?");
                    delete.setString(1, id);
                    delete.executeUpdate();
                    delete.closeOnCompletion();
                }
                this.fm.saveFile(listingsFile, "/database/listings");
                this.chat.log("Transferred " + lt + " active listings from MySQL.", false);
                this.chat.alert("Transferred " + lt + " active listings from MySQL.");
                statement.closeOnCompletion();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.chat.log("Error while transferring active listings.", false);
                this.chat.alert("Error while transferring active listings.");
            }
            try {
                statement = this.mySQL.getConnection().prepareStatement("SELECT * FROM " + this.mySQL.getExpiredTable());
                rs = statement.executeQuery();
                while (rs.next()) {
                    id = rs.getString(1);
                    expiredFile.set(id + ".ItemStack", rs.getString(2));
                    expiredFile.set(id + ".Price", rs.getDouble(3));
                    expiredFile.set(id + ".Creator", rs.getString(4));
                    expiredFile.set(id + ".Start", rs.getLong(5));
                    expiredFile.set(id + ".End", rs.getLong(6));
                    expiredFile.set(id + ".Reason", rs.getString(7));
                    expiredFile.set(id + ".Reclaimed", rs.getBoolean(8));
                    et.getAndIncrement();
                    delete = this.mySQL.getConnection().prepareStatement("DELETE FROM " + this.mySQL.getExpiredTable() + " WHERE ID=?");
                    delete.setString(1, id);
                    delete.executeUpdate();
                    delete.closeOnCompletion();
                }
                this.fm.saveFile(expiredFile, "/database/expired");
                this.chat.log("Transferred " + et + " expired listings from MySQL.", false);
                this.chat.alert("Transferred " + et + " expired listings from MySQL.");
                statement.closeOnCompletion();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.chat.log("Error while transferring expired listings.", false);
                this.chat.alert("Error while transferring expired listings.");
            }
            try {
                statement = this.mySQL.getConnection().prepareStatement("SELECT * FROM " + this.mySQL.getCompletedTable());
                rs = statement.executeQuery();
                while (rs.next()) {
                    id = rs.getString(1);
                    completedFile.set(id + ".ItemStack", rs.getString(2));
                    completedFile.set(id + ".Price", rs.getDouble(3));
                    completedFile.set(id + ".Creator", rs.getString(4));
                    completedFile.set(id + ".Start", rs.getLong(5));
                    completedFile.set(id + ".End", rs.getLong(6));
                    completedFile.set(id + ".Buyer", rs.getString(7));
                    ct.getAndIncrement();
                    delete = this.mySQL.getConnection().prepareStatement("DELETE FROM " + this.mySQL.getCompletedTable() + " WHERE ID=?");
                    delete.setString(1, id);
                    delete.executeUpdate();
                    delete.closeOnCompletion();
                }
                this.fm.saveFile(completedFile, "/database/completed");
                this.chat.alert("Transferred " + ct + " completed listings from MySQL.");
                statement.closeOnCompletion();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.chat.alert("Error while transferring completed listings.");
            }
            AuctionHouse.getInstance().getConfigFile().setDatabaseType(DatabaseType.FILE);
            this.databaseType = DatabaseType.FILE;
            this.chat.alert("Transfer complete. Transferred " + (et.get() + lt.get() + ct.get()) + " total listings. (" + (System.currentTimeMillis() - startTime) + "ms)");
            this.loadListings();
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (player != null) {
                        player.openInventory(inv.transferComplete(lt.get(), ct.get(), et.get()));
                    }
                }
            });
            this.mySQL.setTransferring(null);
            this.mySQL.shutdown();
            this.transferring = false;
        });
        return true;
    }

    public boolean transferToMySQL(final Player player, final DatabaseTransferStatusGUI inv) {
        this.transferring = true;
        if (AuctionHouse.getInstance().getMySQL().getConnection() == null) {
            return false;
        }
        this.chat.alert("&eStarting transfer from File to MySQL.");
        long startTime = System.currentTimeMillis();
        final AtomicInteger lt = new AtomicInteger(0);
        final AtomicInteger et = new AtomicInteger(0);
        final AtomicInteger ct = new AtomicInteger(0);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
            PreparedStatement statement;
            long start;
            String itemstack;
            AkarianConfiguration listingsFile = this.fm.getConfig("/database/listings");
            Set listingsKeySet = listingsFile.getValues(false).keySet();
            AkarianConfiguration expiredFile = this.fm.getConfig("/database/expired");
            Set expireKeySet = expiredFile.getValues(false).keySet();
            AkarianConfiguration completedFile = this.fm.getConfig("/database/completed");
            Set completedKeySet = completedFile.getValues(false).keySet();
            for (String s : listingsKeySet) {
                itemstack = listingsFile.getString(s + ".ItemStack");
                double price = listingsFile.getDouble(s + ".Price");
                String creator = listingsFile.getString(s + ".Creator");
                start = listingsFile.getLong(s + ".Start");
                try {
                    PreparedStatement statement2 = this.mySQL.getConnection().prepareStatement("INSERT INTO " + this.mySQL.getListingsTable() + " (ID,ITEM_STACK,PRICE,CREATOR,START,END,BUYER) VALUES (?,?,?,?,?,?,?)");
                    statement2.setString(1, s);
                    statement2.setString(2, itemstack);
                    statement2.setDouble(3, price);
                    statement2.setString(4, creator);
                    statement2.setLong(5, start);
                    statement2.setLong(6, 0L);
                    statement2.setString(7, null);
                    statement2.executeUpdate();
                    statement2.close();
                    lt.getAndIncrement();
                    listingsFile.set(s, null);
                    this.chat.log("Transferred listing " + s, AuctionHouse.getInstance().isDebug());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.chat.alert("Transferred " + lt + " listings to MySQL.");
            for (String s : expireKeySet) {
                String creator = expiredFile.getString(s + ".Creator");
                Double price = expiredFile.getDouble(s + ".Price");
                String itemStack = expiredFile.getString(s + ".ItemStack");
                long start2 = expiredFile.getLong(s + ".Start");
                long end = expiredFile.getLong(s + ".End");
                String reason = expiredFile.getString(s + ".Reason");
                boolean reclaimed = expiredFile.getBoolean(s + ".Reclaimed");
                try {
                    statement = this.mySQL.getConnection().prepareStatement("INSERT INTO " + this.mySQL.getExpiredTable() + " (ID,ITEM_STACK,PRICE,CREATOR,START,END,REASON,RECLAIMED) VALUES (?,?,?,?,?,?,?,?)");
                    statement.setString(1, s);
                    statement.setString(2, itemStack);
                    statement.setDouble(3, price);
                    statement.setString(4, creator);
                    statement.setLong(5, start2);
                    statement.setLong(6, end);
                    statement.setString(7, reason);
                    statement.setBoolean(8, reclaimed);
                    statement.executeUpdate();
                    statement.close();
                    et.getAndIncrement();
                    expiredFile.set(s, null);
                    this.chat.log("Transferred expired listing " + s, AuctionHouse.getInstance().isDebug());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.chat.alert("Transferred " + et + " expired listings to MySQL.");
            for (String s : completedKeySet) {
                itemstack = completedFile.getString(s + ".ItemStack");
                double price = completedFile.getDouble(s + ".Price");
                String creator = completedFile.getString(s + ".Creator");
                start = completedFile.getLong(s + ".Start");
                long end = completedFile.getLong(s + ".End");
                String buyer = completedFile.getString(s + ".Buyer");
                try {
                    statement = this.mySQL.getConnection().prepareStatement("INSERT INTO " + this.mySQL.getCompletedTable() + " (ID,ITEM_STACK,PRICE,CREATOR,START,END,BUYER) VALUES (?,?,?,?,?,?,?)");
                    statement.setString(1, s);
                    statement.setString(2, itemstack);
                    statement.setDouble(3, price);
                    statement.setString(4, creator);
                    statement.setLong(5, start);
                    statement.setLong(6, end);
                    statement.setString(7, buyer);
                    statement.executeUpdate();
                    statement.closeOnCompletion();
                    completedFile.set(s, null);
                    this.chat.log("Transferred complete listing " + s, AuctionHouse.getInstance().isDebug());
                    ct.getAndIncrement();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.chat.alert("Transferred " + ct + " completed listings to MySQL.");
            this.fm.saveFile(listingsFile, "/database/listings");
            this.fm.saveFile(expiredFile, "/database/expired");
            this.fm.saveFile(completedFile, "/database/completed");
            AuctionHouse.getInstance().getConfigFile().setDatabaseType(DatabaseType.MYSQL);
            this.databaseType = DatabaseType.MYSQL;
            this.chat.alert("Transfer complete. Transferred " + (et.get() + lt.get() + ct.get()) + " total listings. (" + (System.currentTimeMillis() - startTime) + "ms).");
            this.loadListings();
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (player != null) {
                        player.openInventory(inv.transferComplete(lt.get(), ct.get(), et.get()));
                    }
                }
            });
            this.mySQL.setTransferring(null);
            this.transferring = false;
        });
        return true;
    }

    public int safeRemove(String remover, Listing listing) {
        if (!this.active.contains(listing)) {
            return 0;
        }
        this.remove(listing);
        Player creator = Bukkit.getPlayer((UUID)listing.getCreator());
        int expire = this.expire(listing, false, true, remover);
        if (expire == 1) {
            if (creator != null) {
                this.chat.sendMessage((CommandSender)creator, AuctionHouse.getInstance().getMessages().getListingRemoved().replace("%item%", this.chat.formatItem(listing.getItemStack())));
            }
            this.chat.log("Safe Removed " + this.chat.formatItem(listing.getItemStack()) + " by " + remover + ". ID: " + listing.getId().toString(), AuctionHouse.getInstance().isDebug());
            return 1;
        }
        return expire;
    }

    public boolean removeExpired(Listing listing) {
        switch (this.databaseType) {
            case MYSQL: {
                AtomicBoolean ret = new AtomicBoolean(false);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("DELETE FROM " + this.mySQL.getExpiredTable() + " WHERE ID=?");
                        statement.setString(1, listing.getId().toString());
                        statement.executeUpdate();
                        statement.closeOnCompletion();
                        this.chat.log("Removed expired listing " + this.chat.formatItem(listing.getItemStack()) + " " + listing.getId().toString(), AuctionHouse.getInstance().isDebug());
                        this.expired.remove(listing);
                        this.unclaimed.remove(listing);
                        ret.set(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ret.set(false);
                    }
                });
                return ret.get();
            }
            case FILE: {
                AkarianConfiguration listingsFile = this.fm.getConfig("/database/expired");
                listingsFile.set(listing.getId().toString(), null);
                this.fm.saveFile(listingsFile, "/database/expired");
                this.chat.log("Removed expired listing " + this.chat.formatItem(listing.getItemStack()) + " " + listing.getId().toString(), AuctionHouse.getInstance().isDebug());
                this.expired.remove(listing);
                this.unclaimed.remove(listing);
                return true;
            }
        }
        return false;
    }

    public boolean removeCompleted(Listing listing) {
        AuctionHouse.getInstance().getEcon().depositPlayer(Bukkit.getOfflinePlayer((UUID)listing.getBuyer()), listing.getPrice());
        switch (this.databaseType) {
            case MYSQL: {
                AtomicBoolean ret = new AtomicBoolean(false);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("DELETE FROM " + this.mySQL.getCompletedTable() + " WHERE ID=?");
                        statement.setString(1, listing.getId().toString());
                        statement.executeUpdate();
                        statement.closeOnCompletion();
                        this.chat.log("Removed completed listing " + this.chat.formatItem(listing.getItemStack()) + " " + listing.getId().toString(), AuctionHouse.getInstance().isDebug());
                        this.completed.remove(listing);
                        ret.set(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ret.set(false);
                    }
                });
                return ret.get();
            }
            case FILE: {
                AkarianConfiguration completedFile = this.fm.getConfig("/database/completed");
                completedFile.set(listing.getId().toString(), null);
                this.fm.saveFile(completedFile, "/database/completed");
                this.chat.log("Removed completed listing " + this.chat.formatItem(listing.getItemStack()) + " " + listing.getId().toString(), AuctionHouse.getInstance().isDebug());
                this.completed.remove(listing);
                return true;
            }
        }
        return false;
    }

    public boolean remove(Listing listing) {
        switch (this.databaseType) {
            case MYSQL: {
                AtomicBoolean ret = new AtomicBoolean(false);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("DELETE FROM " + this.mySQL.getListingsTable() + " WHERE ID=?");
                        statement.setString(1, listing.getId().toString());
                        statement.executeUpdate();
                        statement.closeOnCompletion();
                        this.chat.log("Removed listing " + this.chat.formatItem(listing.getItemStack()) + " " + listing.getId().toString(), AuctionHouse.getInstance().isDebug());
                        this.active.remove(listing);
                        ret.set(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ret.set(false);
                    }
                });
                return ret.get();
            }
            case FILE: {
                AkarianConfiguration listingsFile = this.fm.getConfig("/database/listings");
                listingsFile.set(listing.getId().toString(), null);
                this.fm.saveFile(listingsFile, "/database/listings");
                this.chat.log("Removed listing " + this.chat.formatItem(listing.getItemStack()) + " " + listing.getId().toString(), AuctionHouse.getInstance().isDebug());
                this.active.remove(listing);
                return true;
            }
        }
        return false;
    }

    public List<Listing> getActive(UUID uuid) {
        ArrayList<Listing> personal = new ArrayList<Listing>();
        for (Listing listing : this.active) {
            if (!listing.getCreator().toString().equalsIgnoreCase(uuid.toString())) continue;
            personal.add(listing);
        }
        return personal;
    }

    public List<Listing> getExpired(UUID uuid) {
        ArrayList<Listing> personal = new ArrayList<Listing>();
        for (Listing listing : this.expired) {
            if (!listing.getCreator().toString().equalsIgnoreCase(uuid.toString())) continue;
            personal.add(listing);
        }
        return personal;
    }

    public List<Listing> getCompleted(UUID uuid) {
        ArrayList<Listing> personal = new ArrayList<Listing>();
        for (Listing listing : this.completed) {
            if (!listing.getCreator().toString().equalsIgnoreCase(uuid.toString())) continue;
            personal.add(listing);
        }
        return personal;
    }

    public Listing create(UUID creator, ItemStack itemStack, Double price) {
        Player p = Bukkit.getPlayer((UUID)creator);
        AuctionHouse.getInstance().getEcon().withdrawPlayer(Bukkit.getOfflinePlayer((UUID)creator), AuctionHouse.getInstance().getConfigFile().calculateListingFee(price));
        UUID id = UUID.randomUUID();
        long start = System.currentTimeMillis();
        Listing listing = new Listing(id, creator, itemStack, price, start);
        switch (this.databaseType) {
            case MYSQL: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("INSERT INTO " + this.mySQL.getListingsTable() + " (ID,ITEM_STACK,PRICE,CREATOR,START,END,BUYER) VALUES (?,?,?,?,?,?,?)");
                        statement.setString(1, id.toString());
                        statement.setString(2, AuctionHouse.getInstance().encode(itemStack, false));
                        statement.setDouble(3, price);
                        statement.setString(4, creator.toString());
                        statement.setLong(5, start);
                        statement.setLong(6, 0L);
                        statement.setString(7, null);
                        this.active.add(listing);
                        statement.executeUpdate();
                        statement.close();
                        this.chat.log("Created listing " + this.chat.formatItem(listing.getItemStack()) + " " + id, AuctionHouse.getInstance().isDebug());
                        this.chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getCreateListing().replace("%item%", this.chat.formatItem(listing.getItemStack())).replace("%price%", this.chat.formatMoney(listing.getPrice())));
                        p.getInventory().removeItem(new ItemStack[]{itemStack});
                        AuctionHouse.getInstance().getCooldownManager().setCooldown(p);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return listing;
            }
            case FILE: {
                AkarianConfiguration listingsFile = this.fm.getConfig("/database/listings");
                this.active.add(listing);
                listingsFile.set(id + ".ItemStack", AuctionHouse.getInstance().encode(itemStack, false));
                listingsFile.set(id + ".Price", price);
                listingsFile.set(id + ".Creator", creator.toString());
                listingsFile.set(id + ".Start", start);
                this.fm.saveFile(listingsFile, "/database/listings");
                this.chat.log("Created listing " + this.chat.formatItem(listing.getItemStack()) + " " + id, AuctionHouse.getInstance().isDebug());
                this.chat.sendMessage((CommandSender)p, AuctionHouse.getInstance().getMessages().getCreateListing().replace("%item%", this.chat.formatItem(listing.getItemStack())).replace("%price%", this.chat.formatMoney(listing.getPrice())));
                p.getInventory().removeItem(new ItemStack[]{itemStack});
                AuctionHouse.getInstance().getCooldownManager().setCooldown(p);
                Bukkit.getServer().getPluginManager().callEvent((Event)new ListingCreateEvent(listing));
                return listing;
            }
        }
        return null;
    }

    public int buy(Listing listing, Player buyer) {
        if (!this.active.contains(listing)) {
            return -1;
        }
        Player creator = Bukkit.getPlayer((UUID)listing.getCreator());
        if (AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)buyer) < listing.getPrice()) {
            return 0;
        }
        AuctionHouse.getInstance().getEcon().withdrawPlayer((OfflinePlayer)buyer, listing.getPrice());
        AuctionHouse.getInstance().getEcon().depositPlayer(Bukkit.getOfflinePlayer((UUID)listing.getCreator()), listing.getPrice());
        long end = System.currentTimeMillis();
        AtomicBoolean ret = new AtomicBoolean(false);
        switch (this.databaseType) {
            case MYSQL: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        this.remove(listing);
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("INSERT INTO " + this.mySQL.getCompletedTable() + " (ID,ITEM_STACK,PRICE,CREATOR,START,END,BUYER) VALUES (?,?,?,?,?,?,?)");
                        statement.setString(1, listing.getId().toString());
                        statement.setString(2, AuctionHouse.getInstance().encode(listing.getItemStack(), false));
                        statement.setDouble(3, listing.getPrice());
                        statement.setString(4, listing.getCreator().toString());
                        statement.setLong(5, listing.getStart());
                        statement.setLong(6, end);
                        statement.setString(7, buyer.getUniqueId().toString());
                        statement.executeUpdate();
                        statement.closeOnCompletion();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ret.set(true);
                    }
                });
                if (!ret.get()) break;
                return -2;
            }
            case FILE: {
                this.remove(listing);
                AkarianConfiguration completedFile = this.fm.getConfig("/database/completed");
                completedFile.set(listing.getId().toString() + ".ItemStack", AuctionHouse.getInstance().encode(listing.getItemStack(), false));
                completedFile.set(listing.getId().toString() + ".Price", listing.getPrice());
                completedFile.set(listing.getId().toString() + ".Creator", listing.getCreator().toString());
                completedFile.set(listing.getId().toString() + ".Start", listing.getStart());
                completedFile.set(listing.getId().toString() + ".End", end);
                completedFile.set(listing.getId().toString() + ".Buyer", buyer.getUniqueId().toString());
                this.fm.saveFile(completedFile, "/database/completed");
            }
        }
        InventoryHandler.addItem(buyer, listing.getItemStack());
        listing.setEnd(end);
        listing.setBuyer(buyer.getUniqueId());
        this.chat.sendMessage((CommandSender)buyer, AuctionHouse.getInstance().getMessages().getListingBoughtBuyer().replace("%item%", this.chat.formatItem(listing.getItemStack())).replace("%price%", this.chat.formatMoney(listing.getPrice())));
        Bukkit.getServer().getPluginManager().callEvent((Event)new ListingBoughtEvent(listing));
        this.chat.log("Auction " + listing.getId().toString() + " has been bought by " + listing.getCreator().toString() + " for " + listing.getPrice() + ".", AuctionHouse.getInstance().isDebug());
        if (creator != null) {
            this.chat.sendMessage((CommandSender)creator, AuctionHouse.getInstance().getMessages().getListingBoughtCreator().replace("%item%", this.chat.formatItem(listing.getItemStack())).replace("%price%", this.chat.formatMoney(listing.getPrice())).replace("%buyer%", buyer.getName()));
            return 2;
        }
        return 1;
    }

    public int setPrice(Listing listing, double newPrice) {
        switch (this.databaseType) {
            case MYSQL: {
                AtomicInteger ret = new AtomicInteger(-1);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("UPDATE " + this.mySQL.getListingsTable() + " SET PRICE=? WHERE ID=?");
                        statement.setDouble(1, newPrice);
                        statement.setString(2, listing.getId().toString());
                        statement.executeUpdate();
                        statement.closeOnCompletion();
                        listing.setPrice(newPrice);
                        ret.set(1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return ret.get();
            }
            case FILE: {
                AkarianConfiguration listingsFile = this.fm.getConfig("/database/listings");
                listingsFile.set(listing.getId() + ".Price", newPrice);
                listing.setPrice(newPrice);
                this.fm.saveFile(listingsFile, "/database/listings");
                return 1;
            }
        }
        return 0;
    }

    public int setAmount(Listing listing, int newAmount, Player player, boolean ignoreCheck) {
        if (!ignoreCheck) {
            int dif;
            if (newAmount > listing.getItemStack().getAmount()) {
                dif = newAmount - listing.getItemStack().getAmount();
                if (InventoryHandler.getPlayersItemAmount(player, listing.getItemStack(), true) < dif) {
                    return -1;
                }
                InventoryHandler.removeItemFromPlayer(player, listing.getItemStack(), dif, true);
            } else if (newAmount < listing.getItemStack().getAmount()) {
                dif = listing.getItemStack().getAmount() - newAmount;
                ItemStack returnItem = listing.getItemStack().clone();
                returnItem.setAmount(dif);
                if (!InventoryHandler.canCarryItem(player, returnItem, true)) {
                    return -2;
                }
                InventoryHandler.addItem(player, returnItem);
            }
        }
        switch (this.databaseType) {
            case MYSQL: {
                AtomicInteger ret = new AtomicInteger(-3);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("UPDATE " + this.mySQL.getListingsTable() + " SET ITEM_STACK=? WHERE ID=?");
                        statement.setString(1, AuctionHouse.getInstance().encode(listing.getItemStack(), false));
                        statement.setString(2, listing.getId().toString());
                        statement.executeUpdate();
                        statement.closeOnCompletion();
                        listing.getItemStack().setAmount(newAmount);
                        ret.set(1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return ret.get();
            }
            case FILE: {
                AkarianConfiguration listingsFile = this.fm.getConfig("/database/listings");
                listingsFile.set(listing.getId().toString() + ".ItemStack", AuctionHouse.getInstance().encode(listing.getItemStack(), false));
                listing.getItemStack().setAmount(newAmount);
                this.fm.saveFile(listingsFile, "/database/listings");
                return 1;
            }
        }
        return 0;
    }

    public Listing get(ItemStack displayItem) {
        if (!displayItem.hasItemMeta()) {
            return null;
        }
        NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "listing-id");
        ItemMeta itemMeta = displayItem.getItemMeta();
        assert (itemMeta != null);
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        if (container.has(key, (PersistentDataType)new UUIDDataType())) {
            return this.get((UUID)container.get(key, (PersistentDataType)new UUIDDataType()));
        }
        return null;
    }

    public Listing get(UUID id) {
        for (Listing listing : this.active) {
            if (!listing.getId().toString().equals(id.toString())) continue;
            return listing;
        }
        for (Listing listing : this.unclaimed) {
            if (!listing.getId().toString().equals(id.toString())) continue;
            return listing;
        }
        for (Listing listing : this.expired) {
            if (!listing.getId().toString().equals(id.toString())) continue;
            return listing;
        }
        for (Listing listing : this.completed) {
            if (!listing.getId().toString().equals(id.toString())) continue;
            return listing;
        }
        return null;
    }

    public int expire(Listing listing, boolean notify, boolean ignoreTime, String reason) {
        long end;
        long now = System.currentTimeMillis() / 1000L;
        if (now <= (end = (listing.getStart() + (long)AuctionHouse.getInstance().getConfigFile().getListingTime() * 1000L) / 1000L) && !ignoreTime) {
            return -1;
        }
        if (listing.getEnd() != 0L) {
            return -3;
        }
        Player creator = Bukkit.getPlayer((UUID)listing.getCreator());
        if (creator != null && notify) {
            this.chat.sendMessage((CommandSender)creator, "&fYour listing for &e" + this.chat.formatItem(listing.getItemStack()) + "&f has expired.");
        }
        switch (this.databaseType) {
            case MYSQL: {
                AtomicInteger ret = new AtomicInteger(-2);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        this.remove(listing);
                        long newEnd = System.currentTimeMillis();
                        listing.setEnd(newEnd);
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("INSERT INTO " + this.mySQL.getExpiredTable() + " (ID,ITEM_STACK,PRICE,CREATOR,START,END,REASON,RECLAIMED) VALUES (?,?,?,?,?,?,?,?)");
                        statement.setString(1, listing.getId().toString());
                        statement.setString(2, AuctionHouse.getInstance().encode(listing.getItemStack(), false));
                        statement.setDouble(3, listing.getPrice());
                        statement.setString(4, listing.getCreator().toString());
                        statement.setLong(5, listing.getStart());
                        statement.setLong(6, listing.getEnd());
                        statement.setString(7, reason);
                        statement.setBoolean(8, false);
                        statement.executeUpdate();
                        statement.close();
                        this.unclaimed.add(listing);
                        this.expired.add(listing);
                        ret.set(1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return ret.get();
            }
            case FILE: {
                long newEnd = System.currentTimeMillis();
                AkarianConfiguration expiredFile = this.fm.getConfig("/database/expired");
                listing.setEnd(newEnd);
                expiredFile.set(listing.getId().toString() + ".ItemStack", AuctionHouse.getInstance().encode(listing.getItemStack(), false));
                expiredFile.set(listing.getId().toString() + ".Price", listing.getPrice());
                expiredFile.set(listing.getId().toString() + ".Creator", listing.getCreator().toString());
                expiredFile.set(listing.getId().toString() + ".Start", listing.getStart());
                expiredFile.set(listing.getId().toString() + ".End", listing.getEnd());
                expiredFile.set(listing.getId().toString() + ".Reason", reason);
                expiredFile.set(listing.getId().toString() + ".Reclaimed", false);
                this.unclaimed.add(listing);
                this.expired.add(listing);
                this.fm.saveFile(expiredFile, "/database/expired");
                this.remove(listing);
                return 1;
            }
        }
        return 0;
    }

    public void loadListings() {
        this.active.clear();
        this.chat.log("Loading listings...", AuctionHouse.getInstance().isDebug());
        AtomicInteger num = new AtomicInteger();
        AtomicInteger errors = new AtomicInteger();
        switch (this.databaseType) {
            case MYSQL: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("SELECT * FROM " + this.mySQL.getListingsTable() + " WHERE END=?");
                        statement.setLong(1, 0L);
                        ResultSet rs = statement.executeQuery();
                        while (rs.next()) {
                            UUID id = UUID.fromString(rs.getString(1));
                            ItemStack item = AuctionHouse.getInstance().decode(rs.getString(2));
                            double price = rs.getDouble(3);
                            UUID creator = UUID.fromString(rs.getString(4));
                            long start = rs.getLong(5);
                            Listing l = new Listing(id, creator, item, price, start);
                            this.active.add(l);
                            num.getAndIncrement();
                            this.chat.log("Loaded listing " + this.chat.formatItem(l.getItemStack()), AuctionHouse.getInstance().isDebug());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                break;
            }
            case FILE: {
                AkarianConfiguration listingsFile = this.fm.getConfig("/database/listings");
                Map map = listingsFile.getValues(false);
                for (String str : map.keySet()) {
                    UUID id = UUID.fromString(str);
                    if (listingsFile.getString(str + ".ItemStack") == null) {
                        this.chat.log("Error while loading auction with ID " + id.toString() + ". Skipping...", AuctionHouse.getInstance().isDebug());
                        errors.incrementAndGet();
                        continue;
                    }
                    ItemStack item = AuctionHouse.getInstance().decode(Objects.requireNonNull(listingsFile.getString(str + ".ItemStack")));
                    if (listingsFile.contains(str + ".Price")) {
                        this.chat.log("Error while loading auction with price " + id.toString() + ". Skipping...", AuctionHouse.getInstance().isDebug());
                        errors.incrementAndGet();
                        continue;
                    }
                    double price = listingsFile.getDouble(str + ".Price");
                    if (listingsFile.contains(str + ".Creator")) {
                        this.chat.log("Error while loading auction with creator " + id.toString() + ". Skipping...", AuctionHouse.getInstance().isDebug());
                        errors.incrementAndGet();
                        continue;
                    }
                    UUID creator = UUID.fromString(Objects.requireNonNull(listingsFile.getString(str + ".Creator")));
                    if (listingsFile.contains(str + ".Start")) {
                        this.chat.log("Error while loading auction with Start " + id.toString() + ". Skipping...", AuctionHouse.getInstance().isDebug());
                        errors.incrementAndGet();
                        continue;
                    }
                    long start = listingsFile.getLong(str + ".Start");
                    Listing l = new Listing(id, creator, item, price, start);
                    this.active.add(l);
                    num.getAndIncrement();
                    this.chat.log("Loaded listing " + this.chat.formatItem(l.getItemStack()), AuctionHouse.getInstance().isDebug());
                }
                break;
            }
        }
        this.startExpireCheck();
        this.startAuctionHouseRefresh();
        this.chat.log("Loaded " + num.get() + " active listings.", AuctionHouse.getInstance().isDebug());
        if (errors.get() > 0) {
            AuctionHouse.getInstance().getLogger().log(Level.SEVERE, "There was an error loading " + errors.get() + " auctions. Please review console to see which.");
            this.chat.log("There was an error loading " + errors.get() + " auctions. Please review console to see which.", AuctionHouse.getInstance().isDebug());
        }
    }

    public void loadExpired() {
        this.chat.log("Loading Expired listings...", AuctionHouse.getInstance().isDebug());
        AtomicInteger errors = new AtomicInteger();
        switch (this.databaseType) {
            case MYSQL: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("SELECT * FROM " + this.mySQL.getExpiredTable());
                        ResultSet rs = statement.executeQuery();
                        while (rs.next()) {
                            UUID id = UUID.fromString(rs.getString(1));
                            ItemStack item = AuctionHouse.getInstance().decode(rs.getString(2));
                            double price = rs.getDouble(3);
                            UUID creator = UUID.fromString(rs.getString(4));
                            long start = rs.getLong(5);
                            long end = rs.getLong(6);
                            String reason = rs.getString(7);
                            boolean reclaimed = rs.getBoolean(8);
                            Listing l = new Listing(id, creator, item, price, start);
                            l.setEnd(end);
                            l.setEnd(end);
                            l.setEndReason(reason);
                            l.setReclaimed(reclaimed);
                            if (!reclaimed) {
                                this.unclaimed.add(l);
                            }
                            this.expired.add(l);
                            this.chat.log("Loaded expired listing " + this.chat.formatItem(l.getItemStack()), AuctionHouse.getInstance().isDebug());
                        }
                        this.chat.log("Loaded " + this.expired.size() + " expired listings, " + this.unclaimed.size() + " of which are unclaimed.", AuctionHouse.getInstance().isDebug());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                break;
            }
            case FILE: {
                AkarianConfiguration listingsFile = this.fm.getConfig("/database/expired");
                Map map = listingsFile.getValues(false);
                for (String str : map.keySet()) {
                    UUID id = UUID.fromString(str);
                    if (listingsFile.getString(str + ".ItemStack") == null) {
                        this.chat.log("Error while loading auction with ID " + id.toString() + ". Skipping...", AuctionHouse.getInstance().isDebug());
                        errors.incrementAndGet();
                        continue;
                    }
                    ItemStack item = AuctionHouse.getInstance().decode(Objects.requireNonNull(listingsFile.getString(str + ".ItemStack")));
                    double price = listingsFile.getDouble(str + ".Price");
                    UUID creator = UUID.fromString(Objects.requireNonNull(listingsFile.getString(str + ".Creator")));
                    long start = listingsFile.getLong(str + ".Start");
                    long end = listingsFile.getLong(str + ".End");
                    String reason = listingsFile.getString(str + ".Reason");
                    boolean reclaimed = listingsFile.getBoolean(str + ".Reclaimed");
                    Listing l = new Listing(id, creator, item, price, start);
                    l.setEnd(end);
                    l.setEndReason(reason);
                    l.setReclaimed(false);
                    l.setReclaimed(reclaimed);
                    if (!reclaimed) {
                        this.unclaimed.add(l);
                    }
                    this.expired.add(l);
                    this.chat.log("Loaded expired listing " + this.chat.formatItem(l.getItemStack()), AuctionHouse.getInstance().isDebug());
                }
                this.chat.log("Loaded " + this.expired.size() + " expired listings, " + this.unclaimed.size() + " of which are unclaimed.", AuctionHouse.getInstance().isDebug());
                if (errors.get() <= 0) break;
                AuctionHouse.getInstance().getLogger().log(Level.SEVERE, "There was an error loading " + errors.get() + " expired auctions. Please review console to see which.");
                this.chat.log("There was an error loading " + errors.get() + " expired auctions. Please review console to see which.", AuctionHouse.getInstance().isDebug());
            }
        }
    }

    public void loadCompleted() {
        this.chat.log("Loading Completed listings...", AuctionHouse.getInstance().isDebug());
        AtomicInteger errors = new AtomicInteger();
        switch (this.databaseType) {
            case MYSQL: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement statement = this.mySQL.getConnection().prepareStatement("SELECT * FROM " + this.mySQL.getCompletedTable());
                        ResultSet rs = statement.executeQuery();
                        while (rs.next()) {
                            UUID id = UUID.fromString(rs.getString(1));
                            ItemStack item = AuctionHouse.getInstance().decode(rs.getString(2));
                            double price = rs.getDouble(3);
                            UUID creator = UUID.fromString(rs.getString(4));
                            long start = rs.getLong(5);
                            long end = rs.getLong(6);
                            UUID buyer = UUID.fromString(rs.getString(7));
                            Listing l = new Listing(id, creator, item, price, start);
                            l.setEnd(end);
                            l.setBuyer(buyer);
                            this.completed.add(l);
                            this.chat.log("Loaded completed listing " + this.chat.formatItem(l.getItemStack()), AuctionHouse.getInstance().isDebug());
                        }
                        this.chat.log("Loaded " + this.completed.size() + " completed listings.", AuctionHouse.getInstance().isDebug());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                break;
            }
            case FILE: {
                AkarianConfiguration completedFile = this.fm.getConfig("/database/completed");
                Map map = completedFile.getValues(false);
                for (String str : map.keySet()) {
                    UUID id = UUID.fromString(str);
                    if (completedFile.getString(str + ".ItemStack") == null) {
                        this.chat.log("Error while loading auction with ID " + id.toString() + ". Skipping...", AuctionHouse.getInstance().isDebug());
                        errors.incrementAndGet();
                        continue;
                    }
                    ItemStack item = AuctionHouse.getInstance().decode(Objects.requireNonNull(completedFile.getString(str + ".ItemStack")));
                    double price = completedFile.getDouble(str + ".Price");
                    UUID creator = UUID.fromString(Objects.requireNonNull(completedFile.getString(str + ".Creator")));
                    long start = completedFile.getLong(str + ".Start");
                    long end = completedFile.getLong(str + ".End");
                    UUID buyer = UUID.fromString(Objects.requireNonNull(completedFile.getString(str + ".Buyer")));
                    Listing l = new Listing(id, creator, item, price, start);
                    l.setEnd(end);
                    l.setBuyer(buyer);
                    this.completed.add(l);
                    this.chat.log("Loaded completed listing " + this.chat.formatItem(l.getItemStack()), AuctionHouse.getInstance().isDebug());
                }
                this.chat.log("Loaded " + this.completed.size() + " completed listings.", AuctionHouse.getInstance().isDebug());
                if (errors.get() <= 0) break;
                AuctionHouse.getInstance().getLogger().log(Level.SEVERE, "There was an error loading " + errors.get() + " completed auctions. Please review console to see which.");
                this.chat.log("There was an error loading " + errors.get() + " completed auctions. Please review console to see which.", AuctionHouse.getInstance().isDebug());
            }
        }
    }

    public int reclaimExpire(Listing listing, Player player, boolean returnItem) {
        AtomicInteger ret = new AtomicInteger(0);
        if (listing.isReclaimed()) {
            return -2;
        }
        if (returnItem) {
            ItemStack[] itemStack = new ItemStack[]{null};
            switch (this.databaseType) {
                case MYSQL: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                        try {
                            PreparedStatement statement = this.mySQL.getConnection().prepareStatement("SELECT * FROM " + this.mySQL.getExpiredTable() + " WHERE ID=?");
                            statement.setString(1, listing.getId().toString());
                            ResultSet rs = statement.executeQuery();
                            while (rs.next()) {
                                if (rs.getBoolean(8)) {
                                    ret.set(-2);
                                    continue;
                                }
                                itemStack[0] = AuctionHouse.getInstance().decode(rs.getString(2));
                                assert (itemStack[0] != null);
                                if (!InventoryHandler.canCarryItem(player, itemStack[0], true)) {
                                    this.chat.sendMessage((CommandSender)player, "&cYou do not have enough space in your inventory to hold this item.");
                                    ret.set(-1);
                                    continue;
                                }
                                InventoryHandler.addItem(player, itemStack[0]);
                                this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getExpiredReclaim().replace("%item%", this.chat.formatItem(listing.getItemStack())));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                    if (ret.get() == 0) break;
                    return ret.get();
                }
                case FILE: {
                    AkarianConfiguration expiredFile = this.fm.getConfig("/database/expired");
                    if (expiredFile.getBoolean(listing.getId() + ".Reclaimed")) {
                        return -2;
                    }
                    itemStack[0] = AuctionHouse.getInstance().decode(Objects.requireNonNull(expiredFile.getString(listing.getId() + ".ItemStack")));
                    assert (itemStack[0] != null);
                    if (!InventoryHandler.canCarryItem(player, itemStack[0], true)) {
                        this.chat.sendMessage((CommandSender)player, "&cYou do not have enough space in your inventory to hold this item.");
                        return -1;
                    }
                    InventoryHandler.addItem(player, itemStack[0]);
                    this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getExpiredReclaim().replace("%item%", this.chat.formatItem(listing.getItemStack())));
                }
            }
        }
        switch (this.databaseType) {
            case MYSQL: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                    try {
                        PreparedStatement update = this.mySQL.getConnection().prepareStatement("UPDATE " + this.mySQL.getExpiredTable() + " SET RECLAIMED=? WHERE ID=?");
                        update.setBoolean(1, true);
                        update.setString(2, listing.getId().toString());
                        update.executeUpdate();
                        update.closeOnCompletion();
                        this.unclaimed.remove(listing);
                        listing.setReclaimed(true);
                        ret.set(1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ret.set(-3);
                    }
                });
                return ret.get();
            }
            case FILE: {
                AkarianConfiguration expiredFile = this.fm.getConfig("/database/expired");
                expiredFile.set(listing.getId().toString() + ".Reclaimed", true);
                this.fm.saveFile(expiredFile, "/database/expired");
                this.unclaimed.remove(listing);
                listing.setReclaimed(true);
                return 1;
            }
        }
        return 0;
    }

    public List<Listing> getUnclaimedExpired(UUID uuid) {
        ArrayList<Listing> a = new ArrayList<Listing>();
        for (Listing listing : this.unclaimed) {
            if (!listing.getCreator().toString().equalsIgnoreCase(uuid.toString()) || listing.isReclaimed()) continue;
            a.add(listing);
        }
        return a;
    }

    private void startExpireCheck() {
        this.expireTimer = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)AuctionHouse.getInstance(), () -> {
            if (!this.active.isEmpty()) {
                ArrayList<Listing> copy = new ArrayList<Listing>(this.active);
                for (Listing listing : copy) {
                    long now = System.currentTimeMillis() / 1000L;
                    long end = (listing.getStart() + (long)AuctionHouse.getInstance().getConfigFile().getListingTime() * 1000L) / 1000L;
                    ItemStack item = listing.getItemStack();
                    for (User user : AuctionHouse.getInstance().getUserManager().getUsers()) {
                        if (!user.getUserSettings().isAlertNearExpire()) {
                            return;
                        }
                        if (user.getUserSettings().getNotified().contains(listing) || end - now >= user.getUserSettings().getAlertNearExpireTime() || Bukkit.getPlayer((UUID)user.getUuid()) == null) continue;
                        user.getUserSettings().getNotified().add(listing);
                        this.chat.sendMessage((CommandSender)Objects.requireNonNull(Bukkit.getPlayer((UUID)user.getUuid())), AuctionHouse.getInstance().getMessages().getSt_expire_message().replace("%listing%", this.chat.formatItem(listing.getItemStack())).replace("%time%", this.chat.formatTime(end - now)).replace("%seller%", Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)listing.getCreator()).getName())));
                    }
                    if (now <= end) continue;
                    switch (this.expire(listing, true, false, "TIME")) {
                        case -1: {
                            this.chat.log("!! Error while saving " + this.chat.formatItem(item) + ".", AuctionHouse.getInstance().isDebug());
                            break;
                        }
                        case 1: {
                            this.chat.log("Listing " + this.chat.formatItem(item) + " has expired with user online.", AuctionHouse.getInstance().isDebug());
                            break;
                        }
                        case 2: {
                            this.chat.log("Listing " + this.chat.formatItem(item) + " has expired. Item saved in database.", AuctionHouse.getInstance().isDebug());
                        }
                    }
                }
            }
        }, 0L, 20L);
    }

    private void startAuctionHouseRefresh() {
        this.refreshTimer = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)AuctionHouse.getInstance(), this::refreshAuctionHouse, 0L, 10L);
    }

    public void refreshAuctionHouse() {
        ConcurrentHashMap<String, AkarianInventory> map = AuctionHouse.getInstance().getGuiManager().getGui();
        Set keySet = map.keySet();
        for (String str : keySet) {
            AkarianInventory inv = map.get(str);
            Player p = Bukkit.getPlayer((UUID)UUID.fromString(str));
            inv.updateInventory();
            assert (p != null);
            p.updateInventory();
        }
    }

    public void cancelExpireTimer() {
        Bukkit.getScheduler().cancelTask(this.expireTimer);
    }

    public void cancelRefreshTimer() {
        Bukkit.getScheduler().cancelTask(this.refreshTimer);
    }

    public List<Listing> getActive() {
        return this.active;
    }

    public List<Listing> getUnclaimed() {
        return this.unclaimed;
    }

    public List<Listing> getExpired() {
        return this.expired;
    }

    public List<Listing> getCompleted() {
        return this.completed;
    }
}

