/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.listings;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.UUIDDataType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Listing {
    private final UUID id;
    private final UUID creator;
    private final long start;
    private final AuctionHouse plugin = AuctionHouse.getInstance();
    private final Chat chat = this.plugin.getChat();
    private ItemStack itemStack;
    private double price;
    private long end;
    private UUID buyer;
    private String endReason;
    private boolean reclaimed;

    public Listing(UUID id, UUID creator, ItemStack itemStack, Double price, Long start) {
        this.id = id;
        this.creator = creator;
        this.itemStack = itemStack;
        this.price = price;
        this.start = start;
        this.reclaimed = false;
    }

    public ItemStack createAdminActiveListing(Player player) {
        ArrayList<String> tlore;
        ItemStack itemStack = this.getItemStack().clone();
        List<Object> list = itemStack.hasItemMeta() ? (itemStack.getItemMeta().hasLore() ? itemStack.getItemMeta().getLore() : new ArrayList<String>()) : (tlore = new ArrayList<String>());
        if (itemStack.getType() == Material.SHULKER_BOX) {
            tlore = new ArrayList();
        }
        assert (tlore != null);
        long seconds = (this.getStart() + (long)AuctionHouse.getInstance().getConfigFile().getListingTime() * 1000L - System.currentTimeMillis()) / 1000L;
        NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "listing-id");
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(key, (PersistentDataType)new UUIDDataType(), (Object)this.getId());
        for (String s : AuctionHouse.getInstance().getMessages().getGui_aha_listing()) {
            if (s.equalsIgnoreCase("%shulker%")) {
                BlockStateMeta im;
                if (itemStack.getType() != Material.SHULKER_BOX || !((im = (BlockStateMeta)itemStack.getItemMeta()).getBlockState() instanceof ShulkerBox)) continue;
                ShulkerBox shulker = (ShulkerBox)im.getBlockState();
                int amount = 0;
                for (ItemStack si : shulker.getInventory().getContents()) {
                    if (si == null) continue;
                    amount += si.getAmount();
                }
                for (String shulkers : AuctionHouse.getInstance().getMessages().getGui_sv_sh()) {
                    tlore.add(shulkers.replace("%amount%", amount + ""));
                }
                continue;
            }
            tlore.add(s.replace("%time%", this.chat.formatTime(seconds)).replace("%creator%", this.plugin.getNameManager().getName(this.creator)).replace("%price%", this.chat.formatMoney(this.price)));
        }
        itemMeta.setLore(this.chat.formatList(tlore));
        itemMeta.setDisplayName(this.chat.formatItem(itemStack));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack createAdminCompleteListing(Player player) {
        ArrayList<String> tlore;
        ItemStack itemStack = this.getItemStack().clone();
        List<Object> list = itemStack.hasItemMeta() ? (itemStack.getItemMeta().hasLore() ? itemStack.getItemMeta().getLore() : new ArrayList<String>()) : (tlore = new ArrayList<String>());
        if (itemStack.getType() == Material.SHULKER_BOX) {
            tlore = new ArrayList();
        }
        assert (tlore != null);
        long seconds = (this.getStart() + (long)AuctionHouse.getInstance().getConfigFile().getListingTime() * 1000L - System.currentTimeMillis()) / 1000L;
        NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "listing-id");
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(key, (PersistentDataType)new UUIDDataType(), (Object)this.getId());
        for (String s : AuctionHouse.getInstance().getMessages().getCompletedAdminLore()) {
            if (s.equalsIgnoreCase("%shulker%")) {
                BlockStateMeta im;
                if (itemStack.getType() != Material.SHULKER_BOX || !((im = (BlockStateMeta)itemStack.getItemMeta()).getBlockState() instanceof ShulkerBox)) continue;
                ShulkerBox shulker = (ShulkerBox)im.getBlockState();
                int amount = 0;
                for (ItemStack si : shulker.getInventory().getContents()) {
                    if (si == null) continue;
                    amount += si.getAmount();
                }
                for (String shulkers : AuctionHouse.getInstance().getMessages().getGui_sv_sh()) {
                    tlore.add(shulkers.replace("%amount%", amount + ""));
                }
                continue;
            }
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                tlore.add(PlaceholderAPI.setPlaceholders((Player)player, (String)s.replace("%start%", this.chat.formatDate(this.getStart())).replace("%end%", this.chat.formatDate(this.getEnd())).replace("%price%", this.chat.formatMoney(this.price))).replace("%buyer%", AuctionHouse.getInstance().getNameManager().getName(this.buyer)));
                continue;
            }
            tlore.add(s.replace("%start%", this.chat.formatDate(this.getStart())).replace("%end%", this.chat.formatDate(this.getEnd())).replace("%price%", this.chat.formatMoney(this.price)).replace("%buyer%", AuctionHouse.getInstance().getNameManager().getName(this.buyer)));
        }
        itemMeta.setLore(this.chat.formatList(tlore));
        itemMeta.setDisplayName(this.chat.formatItem(itemStack));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack createExpiredListing(Player player) {
        ArrayList<String> lore;
        ItemStack itemStack = this.getItemStack().clone();
        List<Object> list = itemStack.hasItemMeta() ? (itemStack.getItemMeta().hasLore() ? itemStack.getItemMeta().getLore() : new ArrayList<String>()) : (lore = new ArrayList<String>());
        if (itemStack.getType() == Material.SHULKER_BOX) {
            lore = new ArrayList();
        }
        assert (lore != null);
        NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "listing-id");
        ItemMeta itemMeta = itemStack.getItemMeta();
        assert (itemMeta != null);
        itemMeta.getPersistentDataContainer().set(key, (PersistentDataType)new UUIDDataType(), (Object)this.id);
        for (String s : AuctionHouse.getInstance().getMessages().getExpiredLore()) {
            if (s.equalsIgnoreCase("%shulker%")) {
                BlockStateMeta im;
                if (itemStack.getType() != Material.SHULKER_BOX || !((im = (BlockStateMeta)itemStack.getItemMeta()).getBlockState() instanceof ShulkerBox)) continue;
                ShulkerBox shulker = (ShulkerBox)im.getBlockState();
                int amount = 0;
                for (ItemStack si : shulker.getInventory().getContents()) {
                    if (si == null) continue;
                    amount += si.getAmount();
                }
                for (String shulkers : AuctionHouse.getInstance().getMessages().getGui_sv_sh()) {
                    lore.add(shulkers.replace("%amount%", amount + ""));
                }
                continue;
            }
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                lore.add(PlaceholderAPI.setPlaceholders((Player)player, (String)s.replace("%start%", this.chat.formatDate(this.getStart())).replace("%end%", this.chat.formatDate(this.getEnd())).replace("%price%", this.chat.formatMoney(this.price))));
                continue;
            }
            lore.add(s.replace("%start%", this.chat.formatDate(this.getStart())).replace("%end%", this.chat.formatDate(this.getEnd())).replace("%price%", this.chat.formatMoney(this.price)));
        }
        itemMeta.setLore(this.chat.formatList(lore));
        itemMeta.setDisplayName(this.chat.formatItem(itemStack));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack createAdminExpiredListing(Player player) {
        ArrayList<String> lore;
        ItemStack itemStack = this.getItemStack().clone();
        List<Object> list = itemStack.hasItemMeta() ? (itemStack.getItemMeta().hasLore() ? itemStack.getItemMeta().getLore() : new ArrayList<String>()) : (lore = new ArrayList<String>());
        if (itemStack.getType() == Material.SHULKER_BOX) {
            lore = new ArrayList();
        }
        assert (lore != null);
        NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "listing-id");
        ItemMeta itemMeta = itemStack.getItemMeta();
        assert (itemMeta != null);
        itemMeta.getPersistentDataContainer().set(key, (PersistentDataType)new UUIDDataType(), (Object)this.id);
        for (String s : AuctionHouse.getInstance().getMessages().getExpiredAdminLore()) {
            if (s.equalsIgnoreCase("%shulker%")) {
                BlockStateMeta im;
                if (itemStack.getType() != Material.SHULKER_BOX || !((im = (BlockStateMeta)itemStack.getItemMeta()).getBlockState() instanceof ShulkerBox)) continue;
                ShulkerBox shulker = (ShulkerBox)im.getBlockState();
                int amount = 0;
                for (ItemStack si : shulker.getInventory().getContents()) {
                    if (si == null) continue;
                    amount += si.getAmount();
                }
                for (String shulkers : AuctionHouse.getInstance().getMessages().getGui_sv_sh()) {
                    lore.add(shulkers.replace("%amount%", amount + ""));
                }
                continue;
            }
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                lore.add(PlaceholderAPI.setPlaceholders((Player)player, (String)s.replace("%start%", this.chat.formatDate(this.getStart())).replace("%end%", this.chat.formatDate(this.getEnd())).replace("%price%", this.chat.formatMoney(this.price)).replace("%reclaimed%", this.isReclaimed() ? "&aTrue" : "&cFalse")));
                continue;
            }
            lore.add(s.replace("%start%", this.chat.formatDate(this.getStart())).replace("%end%", this.chat.formatDate(this.getEnd())).replace("%price%", this.chat.formatMoney(this.price)).replace("%reclaimed%", this.isReclaimed() ? "&aTrue" : "&cFalse"));
        }
        itemMeta.setLore(this.chat.formatList(lore));
        itemMeta.setDisplayName(this.chat.formatItem(itemStack));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack createActiveListing(Player player) {
        ArrayList<String> tlore;
        ItemStack itemStack = this.getItemStack().clone();
        List<Object> list = itemStack.hasItemMeta() ? (itemStack.getItemMeta().hasLore() ? itemStack.getItemMeta().getLore() : new ArrayList<String>()) : (tlore = new ArrayList<String>());
        if (itemStack.getType() == Material.SHULKER_BOX) {
            tlore = new ArrayList();
        }
        assert (tlore != null);
        long seconds = (this.start + (long)AuctionHouse.getInstance().getConfigFile().getListingTime() * 1000L - System.currentTimeMillis()) / 1000L;
        NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "listing-id");
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(key, (PersistentDataType)new UUIDDataType(), (Object)this.id);
        for (String s : AuctionHouse.getInstance().getMessages().getListingLore()) {
            if (s.equalsIgnoreCase("%shulker%")) {
                BlockStateMeta im;
                if (itemStack.getType() != Material.SHULKER_BOX || !((im = (BlockStateMeta)itemStack.getItemMeta()).getBlockState() instanceof ShulkerBox)) continue;
                ShulkerBox shulker = (ShulkerBox)im.getBlockState();
                int amount = 0;
                for (ItemStack si : shulker.getInventory().getContents()) {
                    if (si == null) continue;
                    amount += si.getAmount();
                }
                for (String shulkers : AuctionHouse.getInstance().getMessages().getGui_sv_sh()) {
                    tlore.add(shulkers.replace("%amount%", amount + ""));
                }
                continue;
            }
            if (s.equalsIgnoreCase("%self_info%")) {
                if (this.getCreator().toString().equals(player.getUniqueId().toString())) {
                    tlore.addAll(AuctionHouse.getInstance().getMessages().getSelfInfoCreator());
                    continue;
                }
                tlore.addAll(AuctionHouse.getInstance().getMessages().getSelfInfoBuyer());
                continue;
            }
            tlore.add(s.replace("%time%", this.chat.formatTime(seconds)).replace("%creator%", this.plugin.getNameManager().getName(this.creator)).replace("%price%", this.chat.formatMoney(this.price)));
        }
        itemMeta.setLore(this.chat.formatList(tlore));
        itemMeta.setDisplayName(this.chat.formatItem(itemStack));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getCreator() {
        return this.creator;
    }

    public long getStart() {
        return this.start;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public UUID getBuyer() {
        return this.buyer;
    }

    public void setBuyer(UUID buyer) {
        this.buyer = buyer;
    }

    public String getEndReason() {
        return this.endReason;
    }

    public void setEndReason(String endReason) {
        this.endReason = endReason;
    }

    public boolean isReclaimed() {
        return this.reclaimed;
    }

    public void setReclaimed(boolean reclaimed) {
        this.reclaimed = reclaimed;
    }
}

