/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.layouts;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.layouts.Layout;
import net.akarian.auctionhouse.utils.Chat;
import org.bukkit.Material;

public class LayoutManager {
    public Layout activeLayout;
    private final List<Layout> layouts;
    private final Chat chat = AuctionHouse.getInstance().getChat();

    public LayoutManager() {
        this.layouts = new ArrayList<Layout>();
        this.loadAllLayouts();
    }

    private void loadAllLayouts() {
        if (!new File(AuctionHouse.getInstance().getDataFolder() + File.separator + "layouts").isDirectory() && new File(AuctionHouse.getInstance().getDataFolder() + File.separator + "layouts").mkdirs()) {
            this.chat.log("Created layouts folder.", AuctionHouse.getInstance().isDebug());
            this.activeLayout = this.createDefaultLayout("default", true);
            return;
        }
        int loaded = 0;
        for (File file : new File(AuctionHouse.getInstance().getDataFolder() + File.separator + "layouts").listFiles()) {
            Layout layout = new Layout(UUID.fromString(file.getName().replace(".yml", "")), "");
            layout.loadLayout();
            this.register(layout);
            if (layout.isActive()) {
                this.activeLayout = layout;
            }
            this.chat.log("Loaded layout " + layout.getName() + ".", AuctionHouse.getInstance().isDebug());
            ++loaded;
        }
        this.chat.log("Loaded " + loaded + " layouts.", AuctionHouse.getInstance().isDebug());
    }

    public void saveAllLayouts() {
        int saved = 0;
        for (Layout layout : this.layouts) {
            layout.saveLayout();
            this.chat.log("Saved layout " + layout.getName() + ".", false);
            ++saved;
        }
        this.chat.log("Saved " + saved + " layouts.", true);
    }

    public Layout getLayout(UUID uuid) {
        for (Layout l : this.layouts) {
            if (!l.getUuid().toString().equalsIgnoreCase(uuid.toString())) continue;
            return l;
        }
        return null;
    }

    public void register(Layout layout) {
        this.layouts.add(layout);
    }

    public void unregister(Layout layout) {
        layout.delete();
        this.layouts.remove(layout);
    }

    public Layout createDefaultLayout(String name, boolean active) {
        int i;
        Layout layout = new Layout(UUID.randomUUID(), name);
        ArrayList<Integer> listingSlots = new ArrayList<Integer>();
        ArrayList<Integer> spacerSlots = new ArrayList<Integer>();
        for (i = 9; i <= 44; ++i) {
            listingSlots.add(i);
        }
        for (i = 0; i <= 7; ++i) {
            spacerSlots.add(i);
        }
        for (i = 45; i <= 53; ++i) {
            spacerSlots.add(i);
        }
        layout.setListingItems(listingSlots);
        layout.setSpacerItems(spacerSlots);
        layout.setInventoryName("&6&lAuction&f&lHouse");
        layout.setInventorySize(54);
        layout.setAdminButton(1);
        layout.setExitButton(8);
        layout.setPreviousPageButton(45);
        layout.setNextPageButton(53);
        layout.setSearchButton(46);
        layout.setInfoButton(48);
        layout.setExpiredItemsButton(50);
        layout.setSortButton(52);
        layout.setActive(active);
        layout.setDisplayType(Material.PAPER);
        layout.setSpacerPageItems(true);
        layout.saveLayout();
        this.register(layout);
        return layout;
    }

    public Layout getActiveLayout() {
        return this.activeLayout;
    }

    public void setActiveLayout(Layout activeLayout) {
        this.activeLayout = activeLayout;
    }

    public List<Layout> getLayouts() {
        return this.layouts;
    }
}

