/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.layouts;

import java.util.List;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.utils.AkarianConfiguration;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.FileManager;
import org.bukkit.Material;

public class Layout {
    private int adminButton;
    private int exitButton;
    private int previousPageButton;
    private int nextPageButton;
    private int searchButton;
    private int infoButton;
    private int expiredItemsButton;
    private int sortButton;
    private int inventorySize;
    private List<Integer> listingItems;
    private List<Integer> spacerItems;
    private String inventoryName;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final FileManager fm = AuctionHouse.getInstance().getFileManager();
    private String name;
    private boolean active;
    private Material displayType;
    private final UUID uuid;
    private boolean spacerPageItems;

    public Layout(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public void loadLayout() {
        AkarianConfiguration config = this.fm.getConfig("/layouts/" + this.uuid.toString());
        this.name = config.getString("Name");
        this.inventoryName = config.getString("Inventory Name");
        this.inventorySize = config.getInt("Inventory Size");
        this.adminButton = config.getInt("Admin Button");
        this.exitButton = config.getInt("Exit Button");
        this.previousPageButton = config.getInt("Previous Page Button");
        this.nextPageButton = config.getInt("Next Page Button");
        this.searchButton = config.getInt("Search Button");
        this.infoButton = config.getInt("Info Button");
        this.expiredItemsButton = config.getInt("Expired Items Button");
        this.sortButton = config.getInt("Sort Button");
        this.listingItems = config.getIntegerList("Listing Item Slots");
        this.spacerItems = config.getIntegerList("Spacer Item Slots");
        this.active = config.getBoolean("Active");
        this.displayType = Material.valueOf((String)config.getString("Display Type"));
        this.spacerPageItems = config.getBoolean("Spacer Page Items");
    }

    public void saveLayout() {
        if (!this.fm.getFile("/layouts/" + this.uuid.toString()).exists()) {
            this.fm.createFile("/layouts/" + this.uuid.toString());
        }
        AkarianConfiguration config = this.fm.getConfig(this.uuid.toString());
        config.set("Name", this.name);
        config.set("Active", this.active);
        config.set("Inventory Name", this.inventoryName);
        config.set("Inventory Size", this.inventorySize);
        config.set("Admin Button", this.adminButton);
        config.set("Exit Button", this.exitButton);
        config.set("Previous Page Button", this.previousPageButton);
        config.set("Next Page Button", this.nextPageButton);
        config.set("Search Button", this.searchButton);
        config.set("Info Button", this.infoButton);
        config.set("Expired Items Button", this.expiredItemsButton);
        config.set("Sort Button", this.sortButton);
        config.set("Listing Item Slots", this.listingItems);
        config.set("Spacer Item Slots", this.spacerItems);
        config.set("Display Type", this.displayType.name());
        config.set("Spacer Page Items", this.spacerPageItems);
        this.fm.saveFile(config, "/layouts/" + this.uuid.toString());
    }

    public void delete() {
        if (this.fm.getFile("/layouts/" + this.uuid.toString()).delete()) {
            this.chat.log("Deleted layout " + this.name + " (" + this.uuid.toString() + ").", true);
        }
    }

    public int getAdminButton() {
        return this.adminButton;
    }

    public int getExitButton() {
        return this.exitButton;
    }

    public int getPreviousPageButton() {
        return this.previousPageButton;
    }

    public int getNextPageButton() {
        return this.nextPageButton;
    }

    public int getSearchButton() {
        return this.searchButton;
    }

    public int getInfoButton() {
        return this.infoButton;
    }

    public int getExpiredItemsButton() {
        return this.expiredItemsButton;
    }

    public int getSortButton() {
        return this.sortButton;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public void setAdminButton(int adminButton) {
        this.adminButton = adminButton;
    }

    public void setExitButton(int exitButton) {
        this.exitButton = exitButton;
    }

    public void setPreviousPageButton(int previousPageButton) {
        this.previousPageButton = previousPageButton;
    }

    public void setNextPageButton(int nextPageButton) {
        this.nextPageButton = nextPageButton;
    }

    public void setSearchButton(int searchButton) {
        this.searchButton = searchButton;
    }

    public void setInfoButton(int infoButton) {
        this.infoButton = infoButton;
    }

    public void setExpiredItemsButton(int expiredItemsButton) {
        this.expiredItemsButton = expiredItemsButton;
    }

    public void setSortButton(int sortButton) {
        this.sortButton = sortButton;
    }

    public void setInventorySize(int inventorySize) {
        this.inventorySize = inventorySize;
    }

    public List<Integer> getListingItems() {
        return this.listingItems;
    }

    public List<Integer> getSpacerItems() {
        return this.spacerItems;
    }

    public void setListingItems(List<Integer> listingItems) {
        this.listingItems = listingItems;
    }

    public void setSpacerItems(List<Integer> spacerItems) {
        this.spacerItems = spacerItems;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public void setInventoryName(String inventoryName) {
        this.inventoryName = inventoryName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Material getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(Material displayType) {
        this.displayType = displayType;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isSpacerPageItems() {
        return this.spacerPageItems;
    }

    public void setSpacerPageItems(boolean spacerPageItems) {
        this.spacerPageItems = spacerPageItems;
    }
}

