/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.AuctionHouseAdminGUI;
import net.akarian.auctionhouse.guis.admin.edit.LayoutEditGUI;
import net.akarian.auctionhouse.layouts.Layout;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import net.akarian.auctionhouse.utils.UUIDDataType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LayoutSelectGUI
implements AkarianInventory {
    private Inventory inv;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    int page;
    List<Layout> cloned;

    public LayoutSelectGUI(Player player, int page) {
        this.player = player;
        this.page = page;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        if (slot == 8) {
            this.player.openInventory(new AuctionHouseAdminGUI().getInventory());
            return;
        }
        if (slot >= 9 && slot <= 26) {
            NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "builder-uuid");
            ItemMeta itemMeta = item.getItemMeta();
            assert (itemMeta != null);
            PersistentDataContainer container = itemMeta.getPersistentDataContainer();
            UUID uuid = (UUID)container.get(key, (PersistentDataType)new UUIDDataType());
            if (type.isShiftClick()) {
                if (type.isLeftClick()) {
                    AuctionHouse.getInstance().getLayoutManager().getActiveLayout().setActive(false);
                    AuctionHouse.getInstance().getLayoutManager().setActiveLayout(AuctionHouse.getInstance().getLayoutManager().getLayout(uuid));
                    AuctionHouse.getInstance().getLayoutManager().getLayout(uuid).setActive(true);
                } else if (type.isRightClick() && !AuctionHouse.getInstance().getLayoutManager().getLayout(uuid).isActive()) {
                    AuctionHouse.getInstance().getLayoutManager().unregister(AuctionHouse.getInstance().getLayoutManager().getLayout(uuid));
                }
            } else if (type.isLeftClick()) {
                p.openInventory(new LayoutEditGUI(p, AuctionHouse.getInstance().getLayoutManager().getLayout(uuid)).cloneInventory(true).getInventory());
            }
        }
        if (slot == 31) {
            AuctionHouse.getInstance().getLayoutManager().createDefaultLayout(this.cloned.size() + 1 + "", false);
        } else if (slot == 34 && item.getType() == Material.NETHER_STAR) {
            ++this.page;
            this.updateInventory();
        } else if (slot == 28 && item.getType() == Material.NETHER_STAR) {
            --this.page;
            this.updateInventory();
        }
    }

    @Override
    public void updateInventory() {
        int i;
        int start;
        this.cloned = new ArrayList<Layout>(AuctionHouse.getInstance().getLayoutManager().getLayouts());
        int end = this.page * 18;
        int t = start = end - 18;
        int slot = 9;
        for (i = 9; i <= 26; ++i) {
            this.inv.setItem(i, null);
        }
        for (i = start; i <= end && this.cloned.size() != t && t < end; ++t, ++i) {
            this.inv.setItem(slot, ItemBuilder.build(this.cloned.get(i).getDisplayType(), 1, "&e" + this.cloned.get(i).getName(), Arrays.asList("&7Display Name: &f" + this.cloned.get(i).getInventoryName(), "&7Left click to edit", "&7Shift + Left click to set to active", this.cloned.get(i).isActive() ? null : "&7Shift + Right click to delete"), this.cloned.get(i).isActive() ? "shine" : "", "uuid_" + this.cloned.get(i).getUuid().toString()));
            ++slot;
        }
        if (this.page != 1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            this.inv.setItem(28, previous);
        } else {
            this.inv.setItem(28, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        if (this.cloned.size() > 18 * this.page) {
            ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
            this.inv.setItem(34, next);
        } else {
            this.inv.setItem(34, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
    }

    @NotNull
    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)36, (String)this.chat.format("&6Layout Selector"));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_rt(), AuctionHouse.getInstance().getMessages().getGui_buttons_rd(), new String[0]));
        for (i = 27; i <= 35; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.updateInventory();
        this.inv.setItem(31, ItemBuilder.build(Material.DIAMOND, 1, "&aNew Layout", Collections.singletonList("&7Click to create a new layout."), new String[0]));
        if (this.page != 1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            this.inv.setItem(28, previous);
        }
        Inventory inventory = this.inv;
        if (inventory == null) {
            LayoutSelectGUI.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/akarian/auctionhouse/guis/admin/edit/LayoutSelectGUI", "getInventory"));
    }
}

