/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.events.LayoutEditEvents;
import net.akarian.auctionhouse.guis.admin.edit.LayoutSelectGUI;
import net.akarian.auctionhouse.layouts.Layout;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LayoutEditGUI
implements AkarianInventory {
    private static final HashMap<UUID, LayoutEditGUI> helpMessage = new HashMap();
    private static final HashMap<UUID, Integer> helpPage = new HashMap();
    private static final HashMap<UUID, LayoutEditGUI> layoutNameEdit = new HashMap();
    private static final HashMap<UUID, LayoutEditGUI> displayNameEdit = new HashMap();
    private static final HashMap<UUID, LayoutEditGUI> inventorySizeEdit = new HashMap();
    private static Inventory inv;
    private final HashMap<Integer, ItemStack> playerInventory;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    private final Layout layout;
    private boolean isItems = false;
    private boolean isSettings = false;
    private int updateItems;
    private boolean clear = false;
    private boolean spacerItem;
    private boolean adminButton;
    private boolean closeButton;
    private boolean listingItem;
    private boolean previousPageButton;
    private boolean nextPageButton;
    private boolean sortButton;
    private boolean searchButton;
    private boolean informationButton;
    private boolean expiredListingsButton;

    public LayoutEditGUI(Player player, Layout layout) {
        this.player = player;
        this.playerInventory = new HashMap();
        this.layout = layout;
        this.updateItems = 4;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        int i = this.layout.getInventorySize();
        if (this.isSettings) {
            if (slot == i) {
                this.layout.setSpacerPageItems(!this.layout.isSpacerPageItems());
                return;
            }
            if (slot == i + 1) {
                layoutNameEdit.put(this.player.getUniqueId(), this);
                this.chat.sendMessage((CommandSender)this.player, "&eEnter the new name for this layout...");
                this.player.closeInventory();
                this.isSettings = false;
                return;
            }
            if (slot == i + 2) {
                displayNameEdit.put(this.player.getUniqueId(), this);
                this.chat.sendMessage((CommandSender)this.player, "&eEnter the new display name for this layout...");
                this.player.closeInventory();
                this.isSettings = false;
                return;
            }
            if (slot == i + 3) {
                inventorySizeEdit.put(this.player.getUniqueId(), this);
                this.chat.sendMessage((CommandSender)this.player, "&ePlease enter whether you'd like a 27, 36, 45, or 54 size Auction House...");
                this.player.closeInventory();
                this.isSettings = false;
                return;
            }
            if (slot == i + 22) {
                this.isSettings = false;
                this.clear = true;
                this.updateItems = 4;
                return;
            }
        } else if (this.isItems) {
            if (slot == i) {
                this.spacerItem = true;
                return;
            }
            if (slot == i + 1) {
                this.adminButton = true;
                return;
            }
            if (slot == i + 2) {
                this.closeButton = true;
                return;
            }
            if (slot == i + 3) {
                this.listingItem = true;
                return;
            }
            if (slot == i + 4) {
                this.previousPageButton = true;
                return;
            }
            if (slot == i + 5) {
                this.nextPageButton = true;
                return;
            }
            if (slot == i + 6) {
                this.searchButton = true;
                return;
            }
            if (slot == i + 7) {
                this.informationButton = true;
                return;
            }
            if (slot == i + 8) {
                this.sortButton = true;
                return;
            }
            if (slot == i + 9) {
                this.expiredListingsButton = true;
                return;
            }
            if (slot == i + 22) {
                this.isItems = false;
                this.clear = true;
                this.updateItems = 4;
                return;
            }
        } else {
            if (slot == i + 11) {
                this.isSettings = true;
                this.clear = true;
                return;
            }
            if (slot == i + 15) {
                this.isItems = true;
                this.clear = true;
                return;
            }
        }
        if (slot == i + 28) {
            if (type.isShiftClick() && type.isRightClick()) {
                switch (this.layout.getInventorySize()) {
                    case 27: {
                        inventorySizeEdit.put(p.getUniqueId(), this);
                        LayoutEditEvents.setDefault27(this.layout);
                        this.player.openInventory(this.getInventory());
                        this.giveEditorMenu();
                        inventorySizeEdit.remove(p.getUniqueId());
                        break;
                    }
                    case 36: {
                        inventorySizeEdit.put(p.getUniqueId(), this);
                        LayoutEditEvents.setDefault36(this.layout);
                        this.player.openInventory(this.getInventory());
                        this.giveEditorMenu();
                        inventorySizeEdit.remove(p.getUniqueId());
                        break;
                    }
                    case 45: {
                        inventorySizeEdit.put(p.getUniqueId(), this);
                        LayoutEditEvents.setDefault45(this.layout);
                        this.player.openInventory(this.getInventory());
                        this.giveEditorMenu();
                        inventorySizeEdit.remove(p.getUniqueId());
                        break;
                    }
                    case 54: {
                        inventorySizeEdit.put(p.getUniqueId(), this);
                        LayoutEditEvents.setDefault54(this.layout);
                        this.player.openInventory(this.getInventory());
                        this.giveEditorMenu();
                        inventorySizeEdit.remove(p.getUniqueId());
                    }
                }
            }
        } else if (slot == i + 30) {
            this.isItems = false;
            this.isSettings = false;
            this.clear = true;
            this.resetInventory();
        } else if (slot == i + 31) {
            this.sendHelpMessage();
        } else if (slot == i + 32) {
            this.save();
            this.player.openInventory(new LayoutSelectGUI(this.player, 1).getInventory());
            this.layout.saveLayout();
            this.resetInventory();
        } else if (slot == i + 34) {
            this.player.openInventory(new LayoutSelectGUI(this.player, 1).getInventory());
            this.restoreInventory(true);
        }
    }

    public void sendHelpMessage() {
        helpMessage.put(this.player.getUniqueId(), this);
        helpPage.put(this.player.getUniqueId(), 1);
        this.player.closeInventory();
        LayoutEditEvents.sendHelpMessage(this.player, 1);
    }

    public void returnFromHelp() {
        this.player.openInventory(LayoutEditGUI.getInv());
        this.giveEditorMenu();
        this.updateInventory();
        helpMessage.remove(this.player.getUniqueId());
        helpPage.remove(this.player.getUniqueId());
    }

    public void returnFromLayoutName() {
        this.player.openInventory(LayoutEditGUI.getInv());
        this.giveEditorMenu();
        this.updateInventory();
        layoutNameEdit.remove(this.player.getUniqueId());
    }

    public void returnFromDisplayName() {
        this.player.openInventory(LayoutEditGUI.getInv());
        this.giveEditorMenu();
        this.updateInventory();
        displayNameEdit.remove(this.player.getUniqueId());
    }

    public void returnFromInventorySizeEdit() {
        this.player.openInventory(this.getInventory());
        inventorySizeEdit.remove(this.player.getUniqueId());
        this.giveEditorMenu();
    }

    public void giveEditorMenu() {
        int i;
        for (i = 0; i <= 35; ++i) {
            this.player.getInventory().setItem(i, null);
        }
        for (i = 0; i <= 8; ++i) {
            this.player.getInventory().setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.emptyList(), new String[0]));
        }
        this.player.getInventory().setItem(1, ItemBuilder.build(Material.LAVA_BUCKET, 1, "&cReset to Default", Arrays.asList("&7Set the layout to the default layout.", "&7Shift + Right Click to use", "", "&cCAUTION: This action cannot be undone!"), new String[0]));
        this.player.getInventory().setItem(3, ItemBuilder.build(Material.WATER_BUCKET, 1, "&aReset to Current", Collections.singletonList("&7Reset the layout to the current layout."), new String[0]));
        this.player.getInventory().setItem(4, ItemBuilder.build(Material.BOOK, 1, "&6Editor Guide", Collections.singletonList("&7Click to open a prompt explaining how to use the editor."), new String[0]));
        this.player.getInventory().setItem(5, ItemBuilder.build(Material.SUNFLOWER, 1, "&6Exit and Save", Collections.singletonList("&7Exit and save the current layout."), new String[0]));
        this.player.getInventory().setItem(7, ItemBuilder.build(Material.BARRIER, 1, "&cExit", Collections.singletonList("&cExit and do not save&7."), new String[0]));
        this.player.getInventory().setItem(20, ItemBuilder.build(Material.LIME_DYE, 1, "&6Layout Settings", Collections.singletonList("&7Click to edit the settings of this layout."), new String[0]));
        this.player.getInventory().setItem(24, ItemBuilder.build(Material.MAGENTA_CONCRETE, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
    }

    @Override
    public void updateInventory() {
        if (this.clear) {
            int i;
            for (i = 9; i <= 35; ++i) {
                this.player.getInventory().setItem(i, null);
            }
            this.clear = false;
            if (this.isSettings || this.isItems) {
                for (i = 27; i <= 35; ++i) {
                    this.player.getInventory().setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.emptyList(), new String[0]));
                }
                this.player.getInventory().setItem(31, ItemBuilder.build(Material.BARRIER, 1, "&cReturn", Collections.singletonList("&7Return to the previous page."), new String[0]));
            }
        }
        if (!this.isSettings && !this.isItems) {
            ++this.updateItems;
            if (this.updateItems == 5) {
                this.player.getInventory().setItem(20, ItemBuilder.build(Material.LIME_DYE, 1, "&6Layout Settings", Collections.singletonList("&7Click to edit the settings of this layout."), new String[0]));
                Random ran = new Random();
                switch (ran.nextInt(10)) {
                    case 0: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.MAGENTA_CONCRETE, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 1: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 2: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.GRAY_DYE, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 3: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.LIME_DYE, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 4: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.BARRIER, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 5: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.NETHER_STAR, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 6: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.HOPPER, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 7: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.BOOK, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 8: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.CHEST, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                        break;
                    }
                    case 9: {
                        this.player.getInventory().setItem(24, ItemBuilder.build(Material.PAPER, 1, "&6Layout Items", Collections.singletonList("&7Click to get more items for your layout."), new String[0]));
                    }
                }
                this.updateItems = 0;
            }
        } else if (this.isSettings) {
            this.player.getInventory().setItem(9, ItemBuilder.build(this.layout.isSpacerPageItems() ? Material.LIME_DYE : Material.GRAY_DYE, 1, "&6Spacer Items on Page Items", Collections.singletonList("&7Whether to replace page items with spacers if there are no other pages."), new String[0]));
            this.player.getInventory().setItem(10, ItemBuilder.build(Material.PAPER, 1, "&6Layout Name", Collections.singletonList("&7Rename the layout."), new String[0]));
            this.player.getInventory().setItem(11, ItemBuilder.build(Material.PAPER, 1, "&6Display Name", Collections.singletonList("&7Edit the displayed name for this layout."), new String[0]));
            this.player.getInventory().setItem(12, ItemBuilder.build(Material.CHEST, 1, "&6Auction House Size", Collections.singletonList("&7Edit the size of your auction house layout."), new String[0]));
        } else {
            this.player.getInventory().setItem(9, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, "&6Spacer Item", Collections.singletonList("&7Click to get a Spacer item."), new String[0]));
            this.player.getInventory().setItem(10, ItemBuilder.build(Material.LIME_DYE, 1, "&cAdmin Mode", Arrays.asList("&7Click to get the Admin Mode button.", "&eYou can only have one of these items!"), new String[0]));
            this.player.getInventory().setItem(11, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_cn(), Arrays.asList("&7Click to get the Close button.", "&eYou can only have one of these items!"), new String[0]));
            this.player.getInventory().setItem(12, ItemBuilder.build(Material.MAGENTA_CONCRETE, 1, "&5Listing Item", Collections.singletonList("&7Click to get a Listing Item item."), new String[0]));
            this.player.getInventory().setItem(13, ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), Arrays.asList("&7Click to get a Previous Page button.", "&eYou can only have one of these items!"), new String[0]));
            this.player.getInventory().setItem(14, ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), Arrays.asList("&7Click to get the Next Page button.", "&eYou can only have one of these items!"), new String[0]));
            this.player.getInventory().setItem(15, ItemBuilder.build(Material.HOPPER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_sn(), Arrays.asList("&7Click to get the Search button.", "&eYou can only have one of these items!"), new String[0]));
            this.player.getInventory().setItem(16, ItemBuilder.build(Material.BOOK, 1, AuctionHouse.getInstance().getMessages().getGui_ah_in(), Arrays.asList("&7Click to get the Information button.", "&eYou can only have one of these items!"), new String[0]));
            this.player.getInventory().setItem(17, ItemBuilder.build(Material.PAPER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_stn(), Arrays.asList("&7Click to get the Sort button.", "&eYou can only have one of these items!"), new String[0]));
            this.player.getInventory().setItem(18, ItemBuilder.build(Material.CHEST, 1, AuctionHouse.getInstance().getMessages().getGui_ah_en(), Arrays.asList("&7Click to get the Expired Listings button.", "&eYou can only have one of these items!"), new String[0]));
        }
    }

    public void resetInventory() {
        for (Integer i : this.layout.getSpacerItems()) {
            inv.setItem(i.intValue(), ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        inv.setItem(this.layout.getAdminButton(), ItemBuilder.build(Material.LIME_DYE, 1, "&cAdmin Mode", Collections.singletonList("&aAdmin mode is enabled."), new String[0]));
        inv.setItem(this.layout.getExitButton(), ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_cn(), AuctionHouse.getInstance().getMessages().getGui_ah_cd(), new String[0]));
        for (Integer i : this.layout.getListingItems()) {
            inv.setItem(i.intValue(), ItemBuilder.build(Material.MAGENTA_CONCRETE, 1, "&5Listing Item", Collections.singletonList("&7Place where you want listings to be placed."), new String[0]));
        }
        ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
        inv.setItem(this.layout.getPreviousPageButton(), previous);
        ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
        inv.setItem(this.layout.getNextPageButton(), next);
        inv.setItem(this.layout.getSearchButton(), ItemBuilder.build(Material.HOPPER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_sn(), AuctionHouse.getInstance().getMessages().getGui_ah_sd(), new String[0]));
        ArrayList<String> infoDesc = new ArrayList<String>();
        for (String s : AuctionHouse.getInstance().getMessages().getGui_ah_id()) {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                infoDesc.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)s.replace("%balance%", this.chat.formatMoney(AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)this.player))).replace("%items%", AuctionHouse.getInstance().getListingManager().getActive().size() + "")));
                continue;
            }
            infoDesc.add(s.replace("%balance%", this.chat.formatMoney(AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)this.player))).replace("%items%", AuctionHouse.getInstance().getListingManager().getActive().size() + ""));
        }
        inv.setItem(this.layout.getInfoButton(), ItemBuilder.build(Material.BOOK, 1, AuctionHouse.getInstance().getMessages().getGui_ah_in(), infoDesc, new String[0]));
        inv.setItem(this.layout.getExpiredItemsButton(), ItemBuilder.build(Material.CHEST, 1, AuctionHouse.getInstance().getMessages().getGui_ah_en(), AuctionHouse.getInstance().getMessages().getGui_ah_ed(), new String[0]));
        inv.setItem(this.layout.getSortButton(), ItemBuilder.build(Material.PAPER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_stn(), AuctionHouse.getInstance().getMessages().getGui_ah_std(), new String[0]));
        this.giveEditorMenu();
    }

    @NotNull
    public Inventory getInventory() {
        inv = Bukkit.createInventory((InventoryHolder)this, (int)this.layout.getInventorySize(), (String)this.chat.format(this.layout.getInventoryName()));
        for (Integer i : this.layout.getSpacerItems()) {
            inv.setItem(i.intValue(), ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        if (this.layout.getAdminButton() != -1) {
            inv.setItem(this.layout.getAdminButton(), ItemBuilder.build(Material.LIME_DYE, 1, "&cAdmin Mode", Collections.singletonList("&aAdmin mode is enabled."), new String[0]));
        }
        if (this.layout.getExitButton() != -1) {
            inv.setItem(this.layout.getExitButton(), ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_cn(), AuctionHouse.getInstance().getMessages().getGui_ah_cd(), new String[0]));
        }
        for (Integer i : this.layout.getListingItems()) {
            inv.setItem(i.intValue(), ItemBuilder.build(Material.MAGENTA_CONCRETE, 1, "&5Listing Item", Collections.singletonList("&7Place where you want listings to be placed."), new String[0]));
        }
        if (this.layout.getPreviousPageButton() != -1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            inv.setItem(this.layout.getPreviousPageButton(), previous);
        }
        if (this.layout.getNextPageButton() != -1) {
            ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
            inv.setItem(this.layout.getNextPageButton(), next);
        }
        if (this.layout.getSearchButton() != -1) {
            inv.setItem(this.layout.getSearchButton(), ItemBuilder.build(Material.HOPPER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_sn(), AuctionHouse.getInstance().getMessages().getGui_ah_sd(), new String[0]));
        }
        if (this.layout.getInfoButton() != -1) {
            ArrayList<String> infoDesc = new ArrayList<String>();
            for (String s : AuctionHouse.getInstance().getMessages().getGui_ah_id()) {
                if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                    infoDesc.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)s.replace("%balance%", this.chat.formatMoney(AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)this.player))).replace("%items%", AuctionHouse.getInstance().getListingManager().getActive().size() + "")));
                    continue;
                }
                infoDesc.add(s.replace("%balance%", this.chat.formatMoney(AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)this.player))).replace("%items%", AuctionHouse.getInstance().getListingManager().getActive().size() + ""));
            }
            inv.setItem(this.layout.getInfoButton(), ItemBuilder.build(Material.BOOK, 1, AuctionHouse.getInstance().getMessages().getGui_ah_in(), infoDesc, new String[0]));
        }
        if (this.layout.getExpiredItemsButton() != -1) {
            inv.setItem(this.layout.getExpiredItemsButton(), ItemBuilder.build(Material.CHEST, 1, AuctionHouse.getInstance().getMessages().getGui_ah_en(), AuctionHouse.getInstance().getMessages().getGui_ah_ed(), new String[0]));
        }
        if (this.layout.getSortButton() != -1) {
            inv.setItem(this.layout.getSortButton(), ItemBuilder.build(Material.PAPER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_stn(), AuctionHouse.getInstance().getMessages().getGui_ah_std(), new String[0]));
        }
        this.giveEditorMenu();
        Inventory inventory = inv;
        if (inventory == null) {
            LayoutEditGUI.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    public LayoutEditGUI cloneInventory(boolean clear) {
        for (int i = 0; i <= 35; ++i) {
            if (this.player.getInventory().getItem(i) == null) continue;
            this.playerInventory.put(i, this.player.getInventory().getItem(i));
            if (!clear) continue;
            this.player.getInventory().setItem(i, null);
        }
        this.player.updateInventory();
        return this;
    }

    public void restoreInventory(boolean clear) {
        HashMap cloned = (HashMap)this.playerInventory.clone();
        for (int i = 0; i <= 35; ++i) {
            this.player.getInventory().setItem(i, null);
        }
        this.player.updateInventory();
        for (Map.Entry set : cloned.entrySet()) {
            ItemStack itemStack = (ItemStack)set.getValue();
            int slot = (Integer)set.getKey();
            this.player.getInventory().setItem(slot, itemStack);
            if (!clear) continue;
            this.playerInventory.remove(slot, itemStack);
        }
    }

    private void save() {
        ArrayList<Integer> listings = new ArrayList<Integer>();
        ArrayList<Integer> spacers = new ArrayList<Integer>();
        this.layout.setAdminButton(-1);
        this.layout.setExitButton(-1);
        this.layout.setPreviousPageButton(-1);
        this.layout.setNextPageButton(-1);
        this.layout.setSearchButton(-1);
        this.layout.setInfoButton(-1);
        this.layout.setExpiredItemsButton(-1);
        this.layout.setSortButton(-1);
        block11: for (int i = 0; i < this.layout.getInventorySize(); ++i) {
            if (inv.getItem(i) == null) continue;
            switch (Objects.requireNonNull(inv.getItem(i)).getType()) {
                case LIME_DYE: 
                case GRAY_DYE: {
                    this.layout.setAdminButton(i);
                    continue block11;
                }
                case BARRIER: {
                    this.layout.setExitButton(i);
                    continue block11;
                }
                case NETHER_STAR: {
                    if (inv.getItem(i).getItemMeta().getDisplayName().contains("Previous")) {
                        this.layout.setPreviousPageButton(i);
                        continue block11;
                    }
                    this.layout.setNextPageButton(i);
                    continue block11;
                }
                case HOPPER: {
                    this.layout.setSearchButton(i);
                    continue block11;
                }
                case BOOK: {
                    this.layout.setInfoButton(i);
                    continue block11;
                }
                case CHEST: {
                    this.layout.setExpiredItemsButton(i);
                    continue block11;
                }
                case PAPER: {
                    this.layout.setSortButton(i);
                    continue block11;
                }
                case MAGENTA_CONCRETE: {
                    listings.add(i);
                    continue block11;
                }
                case GRAY_STAINED_GLASS_PANE: {
                    spacers.add(i);
                }
            }
        }
        this.layout.setListingItems(listings);
        this.layout.setSpacerItems(spacers);
    }

    public static HashMap<UUID, LayoutEditGUI> getHelpMessage() {
        return helpMessage;
    }

    public static HashMap<UUID, Integer> getHelpPage() {
        return helpPage;
    }

    public static HashMap<UUID, LayoutEditGUI> getLayoutNameEdit() {
        return layoutNameEdit;
    }

    public static HashMap<UUID, LayoutEditGUI> getDisplayNameEdit() {
        return displayNameEdit;
    }

    public static HashMap<UUID, LayoutEditGUI> getInventorySizeEdit() {
        return inventorySizeEdit;
    }

    public static Inventory getInv() {
        return inv;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public boolean isSpacerItem() {
        return this.spacerItem;
    }

    public void setSpacerItem(boolean spacerItem) {
        this.spacerItem = spacerItem;
    }

    public boolean isAdminButton() {
        return this.adminButton;
    }

    public void setAdminButton(boolean adminButton) {
        this.adminButton = adminButton;
    }

    public boolean isCloseButton() {
        return this.closeButton;
    }

    public void setCloseButton(boolean closeButton) {
        this.closeButton = closeButton;
    }

    public boolean isListingItem() {
        return this.listingItem;
    }

    public void setListingItem(boolean listingItem) {
        this.listingItem = listingItem;
    }

    public boolean isPreviousPageButton() {
        return this.previousPageButton;
    }

    public void setPreviousPageButton(boolean previousPageButton) {
        this.previousPageButton = previousPageButton;
    }

    public boolean isNextPageButton() {
        return this.nextPageButton;
    }

    public void setNextPageButton(boolean nextPageButton) {
        this.nextPageButton = nextPageButton;
    }

    public boolean isSortButton() {
        return this.sortButton;
    }

    public void setSortButton(boolean sortButton) {
        this.sortButton = sortButton;
    }

    public boolean isSearchButton() {
        return this.searchButton;
    }

    public void setSearchButton(boolean searchButton) {
        this.searchButton = searchButton;
    }

    public boolean isInformationButton() {
        return this.informationButton;
    }

    public void setInformationButton(boolean informationButton) {
        this.informationButton = informationButton;
    }

    public boolean isExpiredListingsButton() {
        return this.expiredListingsButton;
    }

    public void setExpiredListingsButton(boolean expiredListingsButton) {
        this.expiredListingsButton = expiredListingsButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/akarian/auctionhouse/guis/admin/edit/LayoutEditGUI", "getInventory"));
    }
}

