/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin.database.transfer;

import java.util.Arrays;
import java.util.Collections;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.database.transfer.ConfirmDatabaseTransfer;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DatabaseTransferStatusGUI
implements AkarianInventory {
    private final Player player;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private boolean finished;
    private boolean started;

    public DatabaseTransferStatusGUI(Player player) {
        this.player = player;
        this.finished = false;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        block8: {
            block7: {
                if (this.finished || this.started) break block7;
                switch (AuctionHouse.getInstance().getDatabaseType()) {
                    case FILE: {
                        if (slot < 10 || slot > 16) break;
                        if (item.getType() == Material.EMERALD_BLOCK) {
                            p.closeInventory();
                            this.started = true;
                            AuctionHouse.getInstance().getListingManager().transferToMySQL(p, this);
                            break;
                        }
                        if (item.getType() != Material.REDSTONE_BLOCK) break;
                        ConfirmDatabaseTransfer cdb = new ConfirmDatabaseTransfer(this.player);
                        if (type.isLeftClick()) {
                            p.closeInventory();
                            this.player.sendTitle(this.chat.format("&6Database Setup"), this.chat.format("&eLeft click to keep current"), 1, 40, 1);
                            this.chat.sendMessage((CommandSender)p, "&eLeft click to keep the current selection.");
                            Bukkit.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)AuctionHouse.getInstance(), () -> {
                                this.player.sendTitle(this.chat.format("&6Enter Hostname"), this.chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_host()), 1, 600, 1);
                                ConfirmDatabaseTransfer.getHostMap().put(this.player.getUniqueId(), cdb);
                            }, 40L);
                            break;
                        }
                        if (type.isRightClick()) {
                            p.closeInventory();
                            cdb.testConnection();
                            break;
                        }
                        break block8;
                    }
                    case MYSQL: {
                        p.closeInventory();
                        this.started = true;
                        AuctionHouse.getInstance().getListingManager().transferToFile(p, this);
                    }
                }
                break block8;
            }
            p.closeInventory();
        }
    }

    @Override
    public void updateInventory() {
    }

    public Inventory getInventory() {
        int i;
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.chat.format("&a&lBegin Data Transfer"));
        for (i = 0; i <= 9; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        for (i = 10; i <= 16; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.EMERALD_BLOCK, 1, "&a&lClick to start transfer", Arrays.asList("&eClick to start database transfer!", "&7You can close and use", "\"/ah admin database\" to reopen."), new String[0]));
        }
        for (i = 17; i <= 26; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.player.openInventory(inv);
        return inv;
    }

    public Inventory connectionDisapproved() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.chat.format("&4&lConnection Unsuccessful!"));
        for (int i = 10; i <= 16; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.REDSTONE_BLOCK, 1, "&c&lClick to restart connection", Arrays.asList("&eLeft click to restart database prompts.", "&eRight click to retry connection.", "", "&6For more detailed info check console."), new String[0]));
        }
        return inv;
    }

    public Inventory transferComplete(int active, int complete, int expired) {
        int i;
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.chat.format("&a&lTransfer Complete"));
        for (i = 0; i <= 9; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        for (i = 10; i <= 16; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.EMERALD_BLOCK, 1, "&a&lTransfer Complete!", Arrays.asList("&eTransferred " + complete + " completed auction listings.", "&eTransferred " + active + " active auction listings.", "&eTransferred " + expired + " expired listings."), new String[0]));
        }
        for (i = 17; i <= 26; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.finished = true;
        return inv;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

