/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin.database.transfer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.database.MainDatabaseGUI;
import net.akarian.auctionhouse.guis.admin.database.transfer.DatabaseTransferStatusGUI;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ConfirmDatabaseTransfer
implements AkarianInventory {
    private static final HashMap<UUID, ConfirmDatabaseTransfer> hostMap = new HashMap();
    private static final HashMap<UUID, ConfirmDatabaseTransfer> transferringMap = new HashMap();
    private final Player player;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private Inventory inv;

    public ConfirmDatabaseTransfer(Player player) {
        this.player = player;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        if (slot >= 10 && slot <= 12) {
            p.closeInventory();
            switch (AuctionHouse.getInstance().getDatabaseType()) {
                case FILE: {
                    this.player.sendTitle(this.chat.format("&6Database Setup"), this.chat.format("&eLeft click to keep current"), 1, 40, 1);
                    Bukkit.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)AuctionHouse.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            ConfirmDatabaseTransfer.this.player.sendTitle(ConfirmDatabaseTransfer.this.chat.format("&6Enter Hostname"), ConfirmDatabaseTransfer.this.chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_host()), 1, 600, 1);
                            hostMap.put(ConfirmDatabaseTransfer.this.player.getUniqueId(), ConfirmDatabaseTransfer.this);
                        }
                    }, 40L);
                    break;
                }
                case MYSQL: {
                    p.openInventory(new DatabaseTransferStatusGUI(p).getInventory());
                }
            }
        } else if (slot >= 14 && slot <= 16) {
            p.openInventory(new MainDatabaseGUI(p).getInventory());
        }
    }

    @Override
    public void updateInventory() {
    }

    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.chat.format("&6&lConfirm Transfer"));
        for (i = 0; i <= 9; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(10, ItemBuilder.build(Material.EMERALD_BLOCK, 1, "&a&lConfirm", Collections.singletonList("&7Click to confirm..."), new String[0]));
        this.inv.setItem(11, ItemBuilder.build(Material.EMERALD_BLOCK, 1, "&a&lConfirm", Collections.singletonList("&7Click to confirm..."), new String[0]));
        this.inv.setItem(12, ItemBuilder.build(Material.EMERALD_BLOCK, 1, "&a&lConfirm", Collections.singletonList("&7Click to confirm..."), new String[0]));
        this.inv.setItem(13, ItemBuilder.build(Material.ENCHANTED_BOOK, 1, "&6&lAre you sure??", Arrays.asList("&7Are you sure you want to start", "&7the database transfer process???"), new String[0]));
        this.inv.setItem(14, ItemBuilder.build(Material.REDSTONE_BLOCK, 1, "&4&lCancel", Collections.singletonList("&7Click to return back to the previous page..."), new String[0]));
        this.inv.setItem(15, ItemBuilder.build(Material.REDSTONE_BLOCK, 1, "&4&lCancel", Collections.singletonList("&7Click to return back to the previous page..."), new String[0]));
        this.inv.setItem(16, ItemBuilder.build(Material.REDSTONE_BLOCK, 1, "&4&lCancel", Collections.singletonList("&7Click to return back to the previous page..."), new String[0]));
        for (i = 17; i <= 26; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        return this.inv;
    }

    public void testConnection() {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.chat.format("&6&lAttempting to connect..."));
        for (int i = 10; i <= 16; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.LIGHT_GRAY_WOOL, 1, "&6Loading...", Collections.singletonList("&eYou can close this menu. It will reopen when updated."), new String[0]));
        }
        this.player.openInventory(this.inv);
        AuctionHouse.getInstance().getMySQL().setTransferring(this.player.getUniqueId());
        transferringMap.put(this.player.getUniqueId(), this);
        AuctionHouse.getInstance().getMySQL().setup();
    }

    public static HashMap<UUID, ConfirmDatabaseTransfer> getHostMap() {
        return hostMap;
    }

    public static HashMap<UUID, ConfirmDatabaseTransfer> getTransferringMap() {
        return transferringMap;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Inventory getInv() {
        return this.inv;
    }
}

