/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin.database.expired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.database.MainDatabaseGUI;
import net.akarian.auctionhouse.guis.admin.database.expired.PlayerExpiredListings;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import net.akarian.auctionhouse.utils.UUIDDataType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ExpiredListingsGUI
implements AkarianInventory {
    private final Chat chat;
    private final int page;
    private final Player player;
    private Inventory inv;
    private List<UUID> users;

    public ExpiredListingsGUI(Player player, int page) {
        this.player = player;
        this.page = page;
        this.chat = AuctionHouse.getInstance().getChat();
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        switch (slot) {
            case 8: {
                p.openInventory(new MainDatabaseGUI(this.player).getInventory());
                return;
            }
            case 45: {
                p.openInventory(new ExpiredListingsGUI(this.player, this.page - 1).getInventory());
                return;
            }
            case 53: {
                p.openInventory(new ExpiredListingsGUI(this.player, this.page + 1).getInventory());
                return;
            }
        }
        if (slot >= 8 && slot <= 45 && item != null) {
            if (!item.hasItemMeta()) {
                return;
            }
            NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "uuid");
            ItemMeta itemMeta = item.getItemMeta();
            assert (itemMeta != null);
            PersistentDataContainer container = itemMeta.getPersistentDataContainer();
            if (container.has(key, (PersistentDataType)new UUIDDataType())) {
                p.openInventory(new PlayerExpiredListings(this.player, (UUID)container.get(key, (PersistentDataType)new UUIDDataType()), 1).getInventory());
            }
        }
    }

    @NotNull
    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.chat.format("&c&lExpired Listings"));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_rt(), AuctionHouse.getInstance().getMessages().getGui_buttons_rd(), new String[0]));
        for (i = 45; i <= 53; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.updateInventory();
        if (this.page != 1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            this.inv.setItem(45, previous);
        }
        if (this.users.size() > 36 * this.page) {
            ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
            this.inv.setItem(53, next);
        }
        Inventory inventory = this.inv;
        if (inventory == null) {
            ExpiredListingsGUI.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    @Override
    public void updateInventory() {
        int i;
        int start;
        this.users = this.usersWithListings();
        int end = this.page * 36;
        int t = start = end - 36;
        int slot = 9;
        for (i = 9; i <= 44; ++i) {
            this.inv.setItem(i, null);
        }
        for (i = start; i <= end && this.users.size() != t && t < end; ++t, ++i) {
            ItemStack itemStack;
            UUID uuid = this.users.get(i);
            try {
                itemStack = new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
            }
            catch (IllegalArgumentException e) {
                itemStack = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
            }
            SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
            NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "uuid");
            meta.getPersistentDataContainer().set(key, (PersistentDataType)new UUIDDataType(), (Object)uuid);
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
            meta.setDisplayName(this.chat.format("&c&l" + AuctionHouse.getInstance().getNameManager().getName(uuid) + " &e&l(" + AuctionHouse.getInstance().getListingManager().getExpired(uuid).size() + ")"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("&7Click to view all &e" + AuctionHouse.getInstance().getListingManager().getExpired(uuid).size() + " &7 expired and " + AuctionHouse.getInstance().getListingManager().getUnclaimedExpired(uuid).size() + " unclaimed listings.");
            meta.setLore(this.chat.formatList(lore));
            itemStack.setItemMeta((ItemMeta)meta);
            this.inv.setItem(slot, itemStack);
            ++slot;
        }
    }

    public List<UUID> usersWithListings() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (Listing l : AuctionHouse.getInstance().getListingManager().getExpired()) {
            if (list.contains(l.getCreator())) continue;
            list.add(l.getCreator());
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/akarian/auctionhouse/guis/admin/database/expired/ExpiredListingsGUI", "getInventory"));
    }
}

