/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin.database.active;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.ListingEditAdminGUI;
import net.akarian.auctionhouse.guis.admin.ShulkerViewAdminGUI;
import net.akarian.auctionhouse.guis.admin.database.active.ActiveListingsGUI;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PlayerActiveListings
implements AkarianInventory {
    private final int page;
    private final UUID uuid;
    private final Chat chat;
    private Inventory inv;
    private List<Listing> listings;
    private final Player player;

    public PlayerActiveListings(Player player, UUID uuid, int page) {
        this.player = player;
        this.uuid = uuid;
        this.page = page;
        this.chat = AuctionHouse.getInstance().getChat();
        this.listings = new ArrayList<Listing>();
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        switch (slot) {
            case 8: {
                p.openInventory(new ActiveListingsGUI(this.player, 1).getInventory());
                return;
            }
            case 45: {
                p.openInventory(new PlayerActiveListings(this.player, this.uuid, this.page - 1).getInventory());
                return;
            }
            case 53: {
                p.openInventory(new PlayerActiveListings(this.player, this.uuid, this.page + 1).getInventory());
                return;
            }
        }
        if (slot >= 8 && slot <= 45) {
            Listing listing = AuctionHouse.getInstance().getListingManager().get(item);
            if (listing == null) {
                return;
            }
            if (type.isLeftClick()) {
                if (type.isShiftClick() && item.getType() == Material.SHULKER_BOX) {
                    p.openInventory(new ShulkerViewAdminGUI(listing, this.player, this).getInventory());
                    return;
                }
                p.openInventory(new ListingEditAdminGUI(listing, this.player, this).getInventory());
            } else {
                switch (AuctionHouse.getInstance().getListingManager().safeRemove(p.getUniqueId().toString(), listing)) {
                    case -1: {
                        this.chat.log("Error while trying to safe remove " + this.chat.formatItem(listing.getItemStack()), AuctionHouse.getInstance().isDebug());
                        break;
                    }
                    case 0: {
                        this.chat.log("Tried to safe remove listing " + listing.getId().toString() + " but it is not active.", AuctionHouse.getInstance().isDebug());
                    }
                }
            }
            return;
        }
    }

    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.chat.format("&a" + Bukkit.getOfflinePlayer((UUID)this.uuid).getName() + "'s Active Listings"));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_rt(), AuctionHouse.getInstance().getMessages().getGui_buttons_rd(), new String[0]));
        for (i = 45; i <= 53; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.updateInventory();
        if (this.page != 1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            this.inv.setItem(45, previous);
        }
        if (this.listings.size() > 36 * this.page) {
            ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
            this.inv.setItem(53, next);
        }
        return this.inv;
    }

    @Override
    public void updateInventory() {
        int i;
        int start;
        this.listings = AuctionHouse.getInstance().getListingManager().getActive(this.uuid);
        int end = this.page * 36;
        int t = start = end - 36;
        int slot = 9;
        for (i = 9; i <= 44; ++i) {
            this.inv.setItem(i, null);
        }
        for (i = start; i <= end && this.listings.size() != t && t < end; ++i) {
            this.inv.setItem(slot, this.listings.get(i).createAdminActiveListing(this.player));
            ++t;
            ++slot;
        }
    }
}

