/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin.database;

import java.util.Arrays;
import java.util.Collections;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.database.active.ActiveListingsGUI;
import net.akarian.auctionhouse.guis.admin.database.completed.CompletedListingsGUI;
import net.akarian.auctionhouse.guis.admin.database.expired.ExpiredListingsGUI;
import net.akarian.auctionhouse.guis.admin.database.transfer.ConfirmDatabaseTransfer;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MainDatabaseGUI
implements AkarianInventory {
    private final Player player;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private Inventory inv;

    public MainDatabaseGUI(Player player) {
        this.player = player;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        switch (slot) {
            case 8: {
                p.closeInventory();
            }
            case 13: {
                if (!type.isRightClick() || !type.isShiftClick()) break;
                p.openInventory(new ConfirmDatabaseTransfer(p).getInventory());
                break;
            }
            case 29: {
                p.openInventory(new ActiveListingsGUI(this.player, 1).getInventory());
                break;
            }
            case 31: {
                p.openInventory(new ExpiredListingsGUI(this.player, 1).getInventory());
                break;
            }
            case 33: {
                p.openInventory(new CompletedListingsGUI(this.player, 1).getInventory());
            }
        }
    }

    @Override
    public void updateInventory() {
        this.inv.setItem(29, ItemBuilder.build(Material.LIME_WOOL, 1, "&a&lActive Listings &e&l(" + AuctionHouse.getInstance().getListingManager().getActive().size() + ")", Collections.singletonList("&7Click to view a list of all active listings."), new String[0]));
        this.inv.setItem(31, ItemBuilder.build(Material.RED_WOOL, 1, "&c&lExpired Listings &e&l(" + AuctionHouse.getInstance().getListingManager().getExpired().size() + ")", Arrays.asList("&7There are &e" + AuctionHouse.getInstance().getListingManager().getUnclaimed().size() + "&7 unclaimed expired listings.", "&7Click to see all expired auctions."), new String[0]));
        this.inv.setItem(33, ItemBuilder.build(Material.GREEN_WOOL, 1, "&6&lCompleted Auctions &e(" + AuctionHouse.getInstance().getListingManager().getCompleted().size() + ")", Collections.singletonList("&7Click to see all completed auctions."), new String[0]));
    }

    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)45, (String)this.chat.format("&6&lDatabase Menu"));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_cn(), AuctionHouse.getInstance().getMessages().getGui_ah_cd(), new String[0]));
        this.inv.setItem(13, ItemBuilder.build(Material.ENCHANTED_BOOK, 1, "&6Database Information", Arrays.asList("&eDatabase Type: " + AuctionHouse.getInstance().getDatabaseType().getStr(), "", "&cShift+Right click to start transfer process"), new String[0]));
        this.inv.setItem(29, ItemBuilder.build(Material.LIME_WOOL, 1, "&a&lActive Listings &e&l(" + AuctionHouse.getInstance().getListingManager().getActive().size() + ")", Collections.singletonList("&7Click to view a list of all active listings."), new String[0]));
        this.inv.setItem(31, ItemBuilder.build(Material.RED_WOOL, 1, "&c&lExpired Listings &e&l(" + AuctionHouse.getInstance().getListingManager().getExpired().size() + ")", Arrays.asList("&7There are &e" + AuctionHouse.getInstance().getListingManager().getUnclaimed().size() + "&7 unclaimed expired listings.", "&7Click to see all expired auctions."), new String[0]));
        this.inv.setItem(33, ItemBuilder.build(Material.GREEN_WOOL, 1, "&6&lCompleted Auctions &e(" + AuctionHouse.getInstance().getListingManager().getCompleted().size() + ")", Collections.singletonList("&7Click to see all completed auctions."), new String[0]));
        for (i = 36; i <= 44; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        return this.inv;
    }

    public Player getPlayer() {
        return this.player;
    }
}

