/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.admin.AuctionHouseAdminGUI;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.AuctionHouseTrait;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.IntegerDataType;
import net.akarian.auctionhouse.utils.ItemBuilder;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class NPCAdminGUI
implements AkarianInventory {
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    private final List<NPC> npcs;
    private int page;
    private Inventory inv;

    public NPCAdminGUI(Player player, int page) {
        this.player = player;
        this.page = page;
        this.npcs = new ArrayList<NPC>();
    }

    public NPCAdminGUI setPage(int page) {
        this.page = page;
        return this;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        switch (slot) {
            case 8: {
                p.openInventory(new AuctionHouseAdminGUI().getInventory());
                return;
            }
            case 45: {
                p.openInventory(this.setPage(this.page - 1).getInventory());
                return;
            }
            case 53: {
                p.openInventory(this.setPage(this.page + 1).getInventory());
                return;
            }
        }
        if (slot >= 8 && slot <= 45 && item != null) {
            NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "id");
            ItemMeta itemMeta = item.getItemMeta();
            assert (itemMeta != null);
            PersistentDataContainer container = itemMeta.getPersistentDataContainer();
            NPC npc = CitizensAPI.getNPCRegistry().getById(((Integer)container.get(key, (PersistentDataType)new IntegerDataType())).intValue());
            if (container.has(key, (PersistentDataType)new IntegerDataType())) {
                if (type.isLeftClick()) {
                    if (type.isShiftClick()) {
                        npc.removeTrait(AuctionHouseTrait.class);
                        this.chat.sendMessage((CommandSender)p, "&eYou have remove the \"auctioneer\" trait from this npc.");
                        return;
                    }
                    p.teleport(npc.getStoredLocation());
                    p.closeInventory();
                } else if (type.isRightClick() && type.isShiftClick()) {
                    npc.destroy((CommandSender)p);
                    this.chat.sendMessage((CommandSender)p, "&eYou have deleted this NPC.");
                }
            }
        }
    }

    @NotNull
    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.chat.format("&6&lManage NPCs"));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_cn(), AuctionHouse.getInstance().getMessages().getGui_ah_cd(), new String[0]));
        this.updateInventory();
        for (i = 45; i <= 53; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        if (this.page != 1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            this.inv.setItem(45, previous);
        }
        if (this.npcs.size() > 36 * this.page) {
            ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
            this.inv.setItem(53, next);
        }
        Inventory inventory = this.inv;
        if (inventory == null) {
            NPCAdminGUI.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    @Override
    public void updateInventory() {
        int start;
        ArrayList<NPC> tempnpcs = new ArrayList<NPC>();
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (!npc.hasTrait(AuctionHouseTrait.class)) continue;
            tempnpcs.add(npc);
        }
        if (this.npcs.equals(tempnpcs)) {
            return;
        }
        this.npcs.clear();
        this.npcs.addAll(tempnpcs);
        int end = this.page * 36;
        int t = start = end - 36;
        int slot = 9;
        for (int i = start; i <= end && this.npcs.size() != t && t < end; ++t, ++i) {
            ItemStack itemStack;
            NPC npc = this.npcs.get(i);
            try {
                itemStack = new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
            }
            catch (IllegalArgumentException e) {
                itemStack = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
            }
            SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((String)(((SkinTrait)npc.getOrAddTrait(SkinTrait.class)).getSkinName() == null ? npc.getName() : ((SkinTrait)npc.getOrAddTrait(SkinTrait.class)).getSkinName())));
            NamespacedKey key = new NamespacedKey((Plugin)AuctionHouse.getInstance(), "id");
            meta.getPersistentDataContainer().set(key, (PersistentDataType)new IntegerDataType(), (Object)npc.getId());
            ArrayList<String> lore = new ArrayList<String>();
            for (String s : AuctionHouse.getInstance().getMessages().getGui_npc_lore()) {
                lore.add(s.replace("%x%", npc.getStoredLocation().getBlockX() + "").replace("%y%", (int)npc.getStoredLocation().getY() + "").replace("%z%", npc.getStoredLocation().getBlockZ() + ""));
            }
            meta.setLore(this.chat.formatList(lore));
            itemStack.setItemMeta((ItemMeta)meta);
            this.inv.setItem(slot, itemStack);
            ++slot;
        }
    }

    public Inventory getInv() {
        return this.inv;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/akarian/auctionhouse/guis/admin/NPCAdminGUI", "getInventory"));
    }
}

