/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.AuctionHouseGUI;
import net.akarian.auctionhouse.guis.admin.database.active.PlayerActiveListings;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ListingEditAdminGUI
implements AkarianInventory {
    private static final HashMap<UUID, ListingEditAdminGUI> priceMap = new HashMap();
    private static final HashMap<UUID, ListingEditAdminGUI> amountMap = new HashMap();
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    private final Listing listing;
    private Inventory inv;
    private final AuctionHouseGUI auctionHouseGUI;
    private final PlayerActiveListings playerActiveListings;

    public ListingEditAdminGUI(Listing listing, AuctionHouseGUI auctionHouseGUI) {
        this.listing = listing;
        this.player = null;
        this.auctionHouseGUI = auctionHouseGUI;
        this.playerActiveListings = null;
    }

    public ListingEditAdminGUI(Listing listing, Player player, PlayerActiveListings playerActiveListings) {
        this.listing = listing;
        this.player = player;
        this.playerActiveListings = playerActiveListings;
        this.auctionHouseGUI = null;
    }

    @Override
    public void onGUIClick(Inventory inventory, Player player, int slot, ItemStack itemStack, ClickType clickType) {
        switch (slot) {
            case 8: {
                if (this.playerActiveListings != null) {
                    player.openInventory(this.playerActiveListings.getInventory());
                    break;
                }
                player.openInventory(this.auctionHouseGUI.getInventory());
                break;
            }
            case 10: {
                this.chat.sendMessage((CommandSender)player, "&eLeft click to cancel");
                this.chat.sendMessage((CommandSender)player, "&eEnter the new price of the auction...");
                priceMap.put(player.getUniqueId(), this);
                player.closeInventory();
                break;
            }
            case 12: {
                if (!clickType.isRightClick() || !clickType.isShiftClick()) {
                    return;
                }
                this.chat.sendMessage((CommandSender)player, "&4You have unsafely removed " + AuctionHouse.getInstance().getNameManager().getName(this.listing.getCreator()) + "'s auction of " + this.chat.formatItem(this.listing.getItemStack()) + "&4.");
                AuctionHouse.getInstance().getListingManager().remove(this.listing);
                if (this.playerActiveListings != null) {
                    player.openInventory(this.playerActiveListings.getInventory());
                    break;
                }
                player.closeInventory();
                break;
            }
            case 14: {
                if (!clickType.isRightClick()) {
                    return;
                }
                this.chat.sendMessage((CommandSender)player, "&cYou have safely removed " + AuctionHouse.getInstance().getNameManager().getName(this.listing.getCreator()) + "'s auction of " + this.chat.formatItem(this.listing.getItemStack()) + "&c.");
                AuctionHouse.getInstance().getListingManager().safeRemove(player.getUniqueId().toString(), this.listing);
                if (this.playerActiveListings != null) {
                    player.openInventory(this.playerActiveListings.getInventory());
                    break;
                }
                player.closeInventory();
                break;
            }
            case 16: {
                this.chat.sendMessage((CommandSender)player, "&eLeft click to cancel");
                this.chat.sendMessage((CommandSender)player, "&eEnter the new amount of the auction...");
                amountMap.put(player.getUniqueId(), this);
                player.closeInventory();
            }
        }
    }

    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.chat.format("&4Edit " + this.chat.formatItem(this.listing.getItemStack())));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_rt(), AuctionHouse.getInstance().getMessages().getGui_buttons_rd(), new String[0]));
        this.inv.setItem(10, ItemBuilder.build(Material.PAPER, 1, "&4Price", Collections.singletonList("&7&oClick to edit the price."), new String[0]));
        this.inv.setItem(12, ItemBuilder.build(Material.REDSTONE_BLOCK, 1, "&4&lUnsafe Remove", Arrays.asList("&e&l!! &c&lCAUTION &e&l!!", "", "&4Remove this listing forcefully", "&4This option does not return the item to the creator!", "&4This action cannot be undone!", "", "&4Shift + Right Click to select"), new String[0]));
        this.inv.setItem(14, ItemBuilder.build(Material.RED_WOOL, 1, "&4Safe Remove", Arrays.asList("&cSafely remove this auction.", "&cThis option returns the item to the creator.", "", "&cRight Click to select"), new String[0]));
        this.inv.setItem(16, ItemBuilder.build(Material.ANVIL, 1, "&4Amount", Arrays.asList("&7&oClick to remove or add items to this listing."), new String[0]));
        for (i = 18; i <= 26; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(22, this.listing.createAdminActiveListing(this.player));
        return this.inv;
    }

    @Override
    public void updateInventory() {
        this.inv.setItem(22, this.listing.createAdminActiveListing(this.player));
    }

    public static HashMap<UUID, ListingEditAdminGUI> getPriceMap() {
        return priceMap;
    }

    public static HashMap<UUID, ListingEditAdminGUI> getAmountMap() {
        return amountMap;
    }

    public Listing getListing() {
        return this.listing;
    }

    public Inventory getInv() {
        return this.inv;
    }
}

