/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis.admin;

import java.util.Collections;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.AuctionHouseGUI;
import net.akarian.auctionhouse.guis.SortType;
import net.akarian.auctionhouse.guis.admin.NPCAdminGUI;
import net.akarian.auctionhouse.guis.admin.database.MainDatabaseGUI;
import net.akarian.auctionhouse.guis.admin.database.transfer.DatabaseTransferStatusGUI;
import net.akarian.auctionhouse.guis.admin.edit.LayoutSelectGUI;
import net.akarian.auctionhouse.guis.admin.settings.MainSettingsGUI;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class AuctionHouseAdminGUI
implements AkarianInventory {
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private Inventory inv;

    @Override
    public void onGUIClick(Inventory inventory, Player player, int slot, ItemStack itemStack, ClickType clickType) {
        switch (slot) {
            case 8: {
                player.closeInventory();
                break;
            }
            case 19: {
                if (!player.hasPermission("auctionhouse.admin.npc")) break;
                player.openInventory(new NPCAdminGUI(player, 1).getInventory());
                break;
            }
            case 21: {
                if (!player.hasPermission("auctionhouse.admin.database")) break;
                if (AuctionHouse.getInstance().getMySQL().getTransferring() == null) {
                    player.openInventory(new MainDatabaseGUI(player).getInventory());
                    break;
                }
                if (AuctionHouse.getInstance().getMySQL().getTransferring().toString().equalsIgnoreCase(player.getUniqueId().toString())) {
                    player.openInventory(new DatabaseTransferStatusGUI(player).getInventory());
                    break;
                }
                this.chat.sendMessage((CommandSender)player, "&cThe database transfer has been initialized by " + Bukkit.getOfflinePlayer((UUID)AuctionHouse.getInstance().getMySQL().getTransferring()).getName() + ".");
                break;
            }
            case 23: {
                if (!player.hasPermission("auctionhouse.admin.manage")) break;
                player.openInventory(new AuctionHouseGUI(player, SortType.TIME_LEFT, true, 1).adminMode().getInventory());
                break;
            }
            case 25: {
                if (!player.hasPermission("auctionhouse.admin.reload") || !clickType.isRightClick() || !clickType.isShiftClick()) break;
                player.closeInventory();
                this.chat.sendMessage((CommandSender)player, "&7Reloading...");
                AuctionHouse.getInstance().getConfigFile().reloadConfig();
                AuctionHouse.getInstance().getMessages().reloadMessages();
                this.chat.setPrefix(AuctionHouse.getInstance().getConfigFile().getPrefix());
                this.chat.sendMessage((CommandSender)player, "&aReload complete.");
                break;
            }
            case 29: {
                if (!player.hasPermission("auctionhouse.admin.settings")) break;
                player.openInventory(new MainSettingsGUI().getInventory());
                break;
            }
            case 33: {
                if (!player.hasPermission("auctionhouse.admin.edit")) break;
                player.openInventory(new LayoutSelectGUI(player, 1).getInventory());
            }
        }
    }

    @Override
    public void updateInventory() {
    }

    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.chat.format(AuctionHouse.getInstance().getMessages().getGui_aha_title()));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_cn(), AuctionHouse.getInstance().getMessages().getGui_ah_cd(), new String[0]));
        this.inv.setItem(19, ItemBuilder.build(Material.PLAYER_HEAD, 1, "&6Manage NPCs", Collections.singletonList("&7Click to manage all AuctionHouse NPCs."), new String[0]));
        this.inv.setItem(21, ItemBuilder.build(Material.BOOKSHELF, 1, "&6Database", Collections.singletonList("&7Click to manage and view the plugin's database."), new String[0]));
        this.inv.setItem(23, ItemBuilder.build(Material.GOLD_NUGGET, 1, "&6Manage Auction House", Collections.singletonList("&7Click to open the Auction House in Admin Mode."), new String[0]));
        this.inv.setItem(25, ItemBuilder.build(Material.REDSTONE_BLOCK, 1, "&4Reload Plugin Files", Collections.singletonList("&7Shift + Right Click to reload plugin files."), new String[0]));
        this.inv.setItem(29, ItemBuilder.build(Material.BOOK, 1, "&6Admin Settings", Collections.singletonList("&7Click to manage the server and default player settings."), new String[0]));
        this.inv.setItem(33, ItemBuilder.build(Material.ANVIL, 1, "&6Edit Auction House", Collections.singletonList("&7Click to edit the layout of the auction house."), new String[0]));
        for (i = 45; i <= 53; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        return this.inv;
    }

    public Inventory getInv() {
        return this.inv;
    }
}

