/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.AuctionHouseGUI;
import net.akarian.auctionhouse.guis.SortType;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class SortGUI
implements AkarianInventory {
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private SortType sortType;
    private boolean sortBool;
    private final AuctionHouseGUI auctionHouseGUI;

    public SortGUI(AuctionHouseGUI auctionHouseGUI) {
        this.auctionHouseGUI = auctionHouseGUI;
    }

    @Override
    public void onGUIClick(Inventory inventory, Player player, int slot, ItemStack itemStack, ClickType clickType) {
        switch (slot) {
            case 8: {
                player.openInventory(this.auctionHouseGUI.getInventory());
                break;
            }
            case 10: {
                if (this.sortType == SortType.OVERALL_PRICE) {
                    this.sortBool = clickType.isLeftClick();
                } else {
                    this.sortType = SortType.OVERALL_PRICE;
                }
                player.openInventory(this.getInventory());
                break;
            }
            case 12: {
                if (this.sortType == SortType.TIME_LEFT) {
                    this.sortBool = clickType.isLeftClick();
                } else {
                    this.sortType = SortType.TIME_LEFT;
                }
                player.openInventory(this.getInventory());
                break;
            }
            case 14: {
                if (this.sortType == SortType.COST_PER_ITEM) {
                    this.sortBool = clickType.isLeftClick();
                } else {
                    this.sortType = SortType.COST_PER_ITEM;
                }
                player.openInventory(this.getInventory());
                break;
            }
            case 16: {
                if (this.sortType == SortType.AMOUNT) {
                    this.sortBool = clickType.isLeftClick();
                } else {
                    this.sortType = SortType.AMOUNT;
                }
                player.openInventory(this.getInventory());
            }
        }
    }

    @Override
    public void updateInventory() {
    }

    public Inventory getInventory() {
        int i;
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.chat.format(AuctionHouse.getInstance().getMessages().getGui_st_title()));
        for (i = 0; i <= 7; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_rt(), AuctionHouse.getInstance().getMessages().getGui_buttons_rd(), new String[0]));
        if (this.sortType == SortType.OVERALL_PRICE) {
            inv.setItem(10, ItemBuilder.build(Material.LIME_DYE, 1, "&a&l" + AuctionHouse.getInstance().getMessages().getGui_st_op(), this.highestList(), new String[0]));
        } else {
            inv.setItem(10, ItemBuilder.build(Material.GRAY_DYE, 1, "&7" + AuctionHouse.getInstance().getMessages().getGui_st_op(), AuctionHouse.getInstance().getMessages().getGui_st_od(), new String[0]));
        }
        if (this.sortType == SortType.TIME_LEFT) {
            inv.setItem(12, ItemBuilder.build(Material.LIME_DYE, 1, "&a&l" + AuctionHouse.getInstance().getMessages().getGui_st_tl(), this.longestList(), new String[0]));
        } else {
            inv.setItem(12, ItemBuilder.build(Material.GRAY_DYE, 1, "&7" + AuctionHouse.getInstance().getMessages().getGui_st_tl(), AuctionHouse.getInstance().getMessages().getGui_st_td(), new String[0]));
        }
        if (this.sortType == SortType.COST_PER_ITEM) {
            inv.setItem(14, ItemBuilder.build(Material.LIME_DYE, 1, "&a&l" + AuctionHouse.getInstance().getMessages().getGui_st_cp(), this.highestList(), new String[0]));
        } else {
            inv.setItem(14, ItemBuilder.build(Material.GRAY_DYE, 1, "&7" + AuctionHouse.getInstance().getMessages().getGui_st_cp(), AuctionHouse.getInstance().getMessages().getGui_st_cd(), new String[0]));
        }
        if (this.sortType == SortType.AMOUNT) {
            inv.setItem(16, ItemBuilder.build(Material.LIME_DYE, 1, "&a&l" + AuctionHouse.getInstance().getMessages().getGui_st_ai(), this.highestList(), new String[0]));
        } else {
            inv.setItem(16, ItemBuilder.build(Material.GRAY_DYE, 1, "&7" + AuctionHouse.getInstance().getMessages().getGui_st_ai(), AuctionHouse.getInstance().getMessages().getGui_st_ad(), new String[0]));
        }
        for (i = 18; i <= 26; ++i) {
            inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        return inv;
    }

    private List<String> longestList() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&8&m&l---------------------------");
        lore.add("");
        if (this.sortBool) {
            lore.add("    &6\u2192 " + AuctionHouse.getInstance().getMessages().getGui_st_lg() + " &8| &7" + AuctionHouse.getInstance().getMessages().getGui_st_st());
        } else {
            lore.add("      &7" + AuctionHouse.getInstance().getMessages().getGui_st_lg() + " &8| &6" + AuctionHouse.getInstance().getMessages().getGui_st_st() + " \u2190");
        }
        lore.add("");
        lore.add("&8&m&l---------------------------");
        return lore;
    }

    private List<String> highestList() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&8&m&l---------------------------");
        lore.add("");
        if (this.sortBool) {
            lore.add("      &6\u2192 " + AuctionHouse.getInstance().getMessages().getGui_st_hg() + " &8| &7" + AuctionHouse.getInstance().getMessages().getGui_st_lw());
        } else {
            lore.add("        &7" + AuctionHouse.getInstance().getMessages().getGui_st_hg() + " &8| &6" + AuctionHouse.getInstance().getMessages().getGui_st_lw() + " \u2190");
        }
        lore.add("");
        lore.add("&8&m&l---------------------------");
        return lore;
    }
}

