/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis;

import java.util.Collections;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.AuctionHouseGUI;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;

public class ShulkerViewGUI
implements AkarianInventory {
    private final Listing listing;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    private final AuctionHouseGUI auctionHouseGUI;
    private Inventory inv;

    public ShulkerViewGUI(Player player, Listing listing, AuctionHouseGUI auctionHouseGUI) {
        this.player = player;
        this.listing = listing;
        this.auctionHouseGUI = auctionHouseGUI;
    }

    @Override
    public void onGUIClick(Inventory inventory, Player player, int slot, ItemStack itemStack, ClickType clickType) {
        if (slot <= 27) {
            return;
        }
        switch (itemStack.getType()) {
            case LIME_STAINED_GLASS_PANE: {
                player.closeInventory();
                switch (AuctionHouse.getInstance().getListingManager().buy(this.listing, player)) {
                    case -1: {
                        this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getError_deleted());
                        break;
                    }
                    case 0: {
                        this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getError_poor());
                        break;
                    }
                    case 1: {
                        this.chat.log("Listing " + this.chat.formatItem(this.listing.getItemStack()) + " has been bought by " + player.getName() + ". Creator online.", AuctionHouse.getInstance().isDebug());
                        break;
                    }
                    case 2: {
                        this.chat.log("Listing " + this.chat.formatItem(this.listing.getItemStack()) + " has been bought by " + player.getName() + ". Creator offline.", AuctionHouse.getInstance().isDebug());
                    }
                }
                break;
            }
            case RED_STAINED_GLASS_PANE: {
                player.openInventory(this.auctionHouseGUI.getInventory());
            }
        }
    }

    public Inventory getInventory() {
        BlockStateMeta im;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)45, (String)this.chat.format(AuctionHouse.getInstance().getMessages().getGui_sv_title()));
        if (this.listing.getItemStack().getItemMeta() instanceof BlockStateMeta && (im = (BlockStateMeta)this.listing.getItemStack().getItemMeta()).getBlockState() instanceof ShulkerBox) {
            ShulkerBox shulker = (ShulkerBox)im.getBlockState();
            for (ItemStack itemStack : shulker.getInventory().getContents()) {
                if (itemStack == null) continue;
                this.inv.addItem(new ItemStack[]{itemStack});
            }
        }
        for (int i = 27; i <= 35; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(36, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(37, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(38, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(39, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(40, this.listing.createActiveListing(this.player));
        this.inv.setItem(41, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(42, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(43, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(44, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        return this.inv;
    }

    @Override
    public void updateInventory() {
        this.inv.setItem(40, this.listing.createActiveListing(this.player));
    }

    public Inventory getInv() {
        return this.inv;
    }
}

