/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.users.User;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import net.akarian.auctionhouse.utils.Messages;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SettingsGUI
implements AkarianInventory {
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    private final boolean isAdmin;
    private Inventory inv;
    private static final HashMap<UUID, SettingsGUI> timeMap = new HashMap();

    public SettingsGUI(Player player, boolean admin) {
        this.player = player;
        this.isAdmin = admin;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        User user = AuctionHouse.getInstance().getUserManager().getUser(this.player);
        if (this.isAdmin) {
            switch (slot) {
                case 10: {
                    user.getUserSettings().setOpenAdminMode(!user.getUserSettings().isOpenAdminMode());
                    this.updateInventory();
                    break;
                }
                case 13: {
                    user.getUserSettings().setAlertNearExpire(!user.getUserSettings().isAlertNearExpire());
                    this.updateInventory();
                    break;
                }
                case 16: {
                    user.getUserSettings().setAlertListingBought(!user.getUserSettings().isAlertListingBought());
                    this.updateInventory();
                    break;
                }
                case 22: {
                    this.chat.sendMessage((CommandSender)this.player, AuctionHouse.getInstance().getMessages().getSt_expireTime_message());
                    timeMap.put(this.player.getUniqueId(), this);
                    this.player.closeInventory();
                    break;
                }
                case 28: {
                    user.getUserSettings().setAlertCreateListings(!user.getUserSettings().isAlertCreateListings());
                    this.updateInventory();
                    break;
                }
                case 34: {
                    user.getUserSettings().setAutoConfirmListing(!user.getUserSettings().isAutoConfirmListing());
                    this.updateInventory();
                }
            }
        } else {
            switch (slot) {
                case 10: {
                    user.getUserSettings().setAlertCreateListings(!user.getUserSettings().isAlertCreateListings());
                    this.updateInventory();
                    break;
                }
                case 12: {
                    user.getUserSettings().setAlertNearExpire(!user.getUserSettings().isAlertNearExpire());
                    this.updateInventory();
                    break;
                }
                case 14: {
                    user.getUserSettings().setAlertListingBought(!user.getUserSettings().isAlertListingBought());
                    this.updateInventory();
                    break;
                }
                case 16: {
                    user.getUserSettings().setAutoConfirmListing(!user.getUserSettings().isAutoConfirmListing());
                    this.updateInventory();
                    break;
                }
                case 21: {
                    this.chat.sendMessage((CommandSender)this.player, AuctionHouse.getInstance().getMessages().getSt_expireTime_message());
                    timeMap.put(this.player.getUniqueId(), this);
                    this.player.closeInventory();
                }
            }
        }
    }

    @Override
    public void updateInventory() {
        User user = AuctionHouse.getInstance().getUserManager().getUser(this.player);
        Messages m = AuctionHouse.getInstance().getMessages();
        ArrayList<String> adminLore = new ArrayList<String>();
        for (String string : m.getSt_admin_lore()) {
            if (string.contains("%status%")) {
                adminLore.add(string.replace("%status%", user.getUserSettings().isOpenAdminMode() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            adminLore.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> expireLore = new ArrayList<String>();
        for (String string : m.getSt_expire_lore()) {
            if (string.contains("%status%")) {
                expireLore.add(string.replace("%status%", user.getUserSettings().isAlertNearExpire() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            expireLore.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : m.getSt_expireTime_lore()) {
            if (string.contains("%time%")) {
                arrayList.add(string.replace("%time%", this.chat.formatTime(user.getUserSettings().getAlertNearExpireTime())));
                continue;
            }
            arrayList.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : m.getSt_bought_lore()) {
            if (string.contains("%status%")) {
                arrayList2.add(string.replace("%status%", user.getUserSettings().isAlertListingBought() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            arrayList2.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String s : m.getSt_created_lore()) {
            if (s.contains("%status%")) {
                arrayList3.add(s.replace("%status%", user.getUserSettings().isAlertCreateListings() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            arrayList3.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)s));
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (String s : m.getSt_autoConfirm_lore()) {
            if (s.contains("%status%")) {
                arrayList4.add(s.replace("%status%", user.getUserSettings().isAutoConfirmListing() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            arrayList4.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)s));
        }
        if (this.isAdmin) {
            this.inv.setItem(10, ItemBuilder.build(user.getUserSettings().isOpenAdminMode() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_admin_name(), adminLore, new String[0]));
            this.inv.setItem(13, ItemBuilder.build(user.getUserSettings().isAlertNearExpire() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_expire_name(), expireLore, new String[0]));
            this.inv.setItem(22, ItemBuilder.build(Material.PAPER, 1, m.getSt_expireTime_name(), arrayList, new String[0]));
            this.inv.setItem(16, ItemBuilder.build(user.getUserSettings().isAlertListingBought() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_bought_name(), arrayList2, new String[0]));
            this.inv.setItem(28, ItemBuilder.build(user.getUserSettings().isAlertCreateListings() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_created_name(), arrayList3, new String[0]));
            this.inv.setItem(34, ItemBuilder.build(user.getUserSettings().isAutoConfirmListing() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_autoConfirm_name(), arrayList4, new String[0]));
        } else {
            this.inv.setItem(10, ItemBuilder.build(user.getUserSettings().isAlertCreateListings() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_created_name(), arrayList3, new String[0]));
            this.inv.setItem(12, ItemBuilder.build(user.getUserSettings().isAlertNearExpire() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_expire_name(), expireLore, new String[0]));
            this.inv.setItem(21, ItemBuilder.build(Material.PAPER, 1, m.getSt_expireTime_name(), arrayList, new String[0]));
            this.inv.setItem(14, ItemBuilder.build(user.getUserSettings().isAlertListingBought() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_bought_name(), arrayList2, new String[0]));
            this.inv.setItem(16, ItemBuilder.build(user.getUserSettings().isAutoConfirmListing() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_autoConfirm_name(), arrayList4, new String[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Inventory getInventory() {
        void var9_21;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(this.isAdmin ? 45 : 36), (String)this.chat.format("&eUser Settings"));
        User user = AuctionHouse.getInstance().getUserManager().getUser(this.player);
        Messages m = AuctionHouse.getInstance().getMessages();
        for (int i = 0; i <= 9; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        ArrayList<String> adminLore = new ArrayList<String>();
        for (String string : m.getSt_admin_lore()) {
            if (string.contains("%status%")) {
                adminLore.add(string.replace("%status%", user.getUserSettings().isOpenAdminMode() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            adminLore.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> expireLore = new ArrayList<String>();
        for (String string : m.getSt_expire_lore()) {
            if (string.contains("%status%")) {
                expireLore.add(string.replace("%status%", user.getUserSettings().isAlertNearExpire() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            expireLore.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : m.getSt_expireTime_lore()) {
            if (string.contains("%time%")) {
                arrayList.add(string.replace("%time%", this.chat.formatTime(user.getUserSettings().getAlertNearExpireTime())));
                continue;
            }
            arrayList.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : m.getSt_bought_lore()) {
            if (string.contains("%status%")) {
                arrayList2.add(string.replace("%status%", user.getUserSettings().isAlertListingBought() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            arrayList2.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String string : m.getSt_created_lore()) {
            if (string.contains("%status%")) {
                arrayList3.add(string.replace("%status%", user.getUserSettings().isAlertCreateListings() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            arrayList3.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)string));
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (String s : m.getSt_autoConfirm_lore()) {
            if (s.contains("%status%")) {
                arrayList4.add(s.replace("%status%", user.getUserSettings().isAutoConfirmListing() ? "&a&lEnabled" : "&c&lDisabled"));
                continue;
            }
            arrayList4.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)s));
        }
        if (this.isAdmin) {
            this.inv.setItem(10, ItemBuilder.build(user.getUserSettings().isOpenAdminMode() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_admin_name(), adminLore, new String[0]));
            this.inv.setItem(13, ItemBuilder.build(user.getUserSettings().isAlertNearExpire() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_expire_name(), expireLore, new String[0]));
            this.inv.setItem(22, ItemBuilder.build(Material.PAPER, 1, m.getSt_expireTime_name(), arrayList, new String[0]));
            this.inv.setItem(16, ItemBuilder.build(user.getUserSettings().isAlertListingBought() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_bought_name(), arrayList2, new String[0]));
            this.inv.setItem(28, ItemBuilder.build(user.getUserSettings().isAlertCreateListings() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_created_name(), arrayList3, new String[0]));
            this.inv.setItem(34, ItemBuilder.build(user.getUserSettings().isAutoConfirmListing() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_autoConfirm_name(), arrayList4, new String[0]));
        } else {
            this.inv.setItem(10, ItemBuilder.build(user.getUserSettings().isAlertCreateListings() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_created_name(), arrayList3, new String[0]));
            this.inv.setItem(12, ItemBuilder.build(user.getUserSettings().isAlertNearExpire() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_expire_name(), expireLore, new String[0]));
            this.inv.setItem(21, ItemBuilder.build(Material.PAPER, 1, m.getSt_expireTime_name(), arrayList, new String[0]));
            this.inv.setItem(14, ItemBuilder.build(user.getUserSettings().isAlertListingBought() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_bought_name(), arrayList2, new String[0]));
            this.inv.setItem(16, ItemBuilder.build(user.getUserSettings().isAutoConfirmListing() ? Material.LIME_DYE : Material.GRAY_DYE, 1, m.getSt_autoConfirm_name(), arrayList4, new String[0]));
        }
        this.inv.setItem(17, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        this.inv.setItem(18, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        if (this.isAdmin) {
            this.inv.setItem(26, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
            this.inv.setItem(27, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        int n = this.isAdmin ? 35 : 26;
        while (var9_21 <= (this.isAdmin ? 44 : 35)) {
            this.inv.setItem((int)var9_21, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
            ++var9_21;
        }
        Inventory inventory = this.inv;
        if (inventory == null) {
            SettingsGUI.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    public Inventory getInv() {
        return this.inv;
    }

    public static HashMap<UUID, SettingsGUI> getTimeMap() {
        return timeMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/akarian/auctionhouse/guis/SettingsGUI", "getInventory"));
    }
}

