/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.AuctionHouseGUI;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ListingEditGUI
implements AkarianInventory {
    private static final HashMap<UUID, ListingEditGUI> priceMap = new HashMap();
    private static final HashMap<UUID, ListingEditGUI> amountMap = new HashMap();
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    private final Listing listing;
    private Inventory inv;
    private final AuctionHouseGUI auctionHouseGUI;

    public ListingEditGUI(Player player, Listing listing, AuctionHouseGUI auctionHouseGUI) {
        this.listing = listing;
        this.player = player;
        this.auctionHouseGUI = auctionHouseGUI;
    }

    @Override
    public void onGUIClick(Inventory inventory, Player player, int slot, ItemStack itemStack, ClickType clickType) {
        switch (slot) {
            case 8: {
                player.openInventory(this.auctionHouseGUI.getInventory());
                break;
            }
            case 11: {
                this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getGui_le_pc());
                priceMap.put(player.getUniqueId(), this);
                player.closeInventory();
                break;
            }
            case 15: {
                this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getGui_le_ac());
                amountMap.put(player.getUniqueId(), this);
                player.closeInventory();
            }
        }
    }

    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.chat.format(AuctionHouse.getInstance().getMessages().getGui_le_title()));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_rt(), AuctionHouse.getInstance().getMessages().getGui_buttons_rd(), new String[0]));
        this.inv.setItem(11, ItemBuilder.build(Material.PAPER, 1, AuctionHouse.getInstance().getMessages().getGui_le_pn(), AuctionHouse.getInstance().getMessages().getGui_le_pd(), new String[0]));
        this.inv.setItem(13, this.listing.createActiveListing(this.player));
        this.inv.setItem(15, ItemBuilder.build(Material.ANVIL, 1, AuctionHouse.getInstance().getMessages().getGui_le_an(), AuctionHouse.getInstance().getMessages().getGui_le_ad(), new String[0]));
        for (i = 18; i <= 26; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        return this.inv;
    }

    @Override
    public void updateInventory() {
        this.inv.setItem(13, this.listing.createActiveListing(this.player));
    }

    public static HashMap<UUID, ListingEditGUI> getPriceMap() {
        return priceMap;
    }

    public static HashMap<UUID, ListingEditGUI> getAmountMap() {
        return amountMap;
    }

    public Listing getListing() {
        return this.listing;
    }

    public Inventory getInv() {
        return this.inv;
    }
}

