/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.AuctionHouseGUI;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ExpireReclaimGUI
implements AkarianInventory {
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    private final AuctionHouseGUI auctionHouseGUI;
    private final int page;
    private List<Listing> listings;
    private Inventory inv;
    private int viewable;

    public ExpireReclaimGUI(Player player, AuctionHouseGUI auctionHouseGUI, int page) {
        this.player = player;
        this.auctionHouseGUI = auctionHouseGUI;
        this.listings = new ArrayList<Listing>();
        this.page = page;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        switch (slot) {
            case 8: {
                this.player.openInventory(this.auctionHouseGUI.getInventory());
                break;
            }
            case 45: {
                this.player.openInventory(new ExpireReclaimGUI(this.player, this.auctionHouseGUI, this.page - 1).getInventory());
                return;
            }
            case 53: {
                this.player.openInventory(new ExpireReclaimGUI(this.player, this.auctionHouseGUI, this.page + 1).getInventory());
                return;
            }
        }
        if (slot == 8) {
            this.player.openInventory(this.auctionHouseGUI.getInventory());
        }
        if (slot >= 9 && slot <= 45) {
            Listing listing = AuctionHouse.getInstance().getListingManager().get(item);
            if (listing == null) {
                return;
            }
            switch (AuctionHouse.getInstance().getListingManager().reclaimExpire(listing, this.player, true)) {
                case -2: {
                    this.chat.sendMessage((CommandSender)this.player, "&cThat listing is already reclaimed!");
                    break;
                }
                case -1: {
                    this.chat.sendMessage((CommandSender)this.player, "&cYou cannot hold that item.");
                }
            }
        }
    }

    public Inventory getInventory() {
        int i;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.chat.format(AuctionHouse.getInstance().getMessages().getGui_er_title()));
        for (i = 0; i <= 7; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.inv.setItem(8, ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_rt(), AuctionHouse.getInstance().getMessages().getGui_buttons_rd(), new String[0]));
        for (i = 45; i <= 53; ++i) {
            this.inv.setItem(i, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        this.updateInventory();
        if (this.page != 1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            this.inv.setItem(45, previous);
        }
        if (this.listings.size() > 36 * this.page) {
            ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
            this.inv.setItem(53, next);
        }
        return this.inv;
    }

    @Override
    public void updateInventory() {
        int i;
        int start;
        this.listings.clear();
        this.listings.addAll(AuctionHouse.getInstance().getListingManager().getUnclaimedExpired(this.player.getUniqueId()));
        this.viewable = 0;
        int end = this.page * 36;
        int t = start = end - 36;
        int slot = 9;
        for (i = 9; i <= 44; ++i) {
            this.inv.setItem(i, null);
        }
        for (i = start; i <= end && this.listings.size() != t && t < end; ++t, ++i) {
            Listing listing = this.listings.get(i);
            this.inv.setItem(slot, listing.createExpiredListing(this.player));
            ++this.viewable;
            ++slot;
        }
        if (this.page != 1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            this.inv.setItem(45, previous);
        } else {
            this.inv.setItem(45, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
        if (this.listings.size() > 36 * this.page) {
            ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
            this.inv.setItem(53, next);
        } else {
            this.inv.setItem(53, ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.EMPTY_LIST, new String[0]));
        }
    }

    public List<Listing> getListings() {
        return this.listings;
    }

    public void setListings(List<Listing> listings) {
        this.listings = listings;
    }

    public Inventory getInv() {
        return this.inv;
    }

    public int getViewable() {
        return this.viewable;
    }
}

