/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis;

import java.util.ArrayList;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConfirmListGUI
implements AkarianInventory {
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final Player player;
    private final ItemStack itemStack;
    private final double price;
    private Inventory inv;

    public ConfirmListGUI(Player player, ItemStack itemStack, double price) {
        this.player = player;
        this.itemStack = itemStack;
        this.price = price;
    }

    @Override
    public void onGUIClick(Inventory inv, Player p, int slot, ItemStack item, ClickType type) {
        switch (item.getType()) {
            case LIME_STAINED_GLASS_PANE: {
                this.player.closeInventory();
                AuctionHouse.getInstance().getListingManager().create(p.getUniqueId(), this.itemStack, this.price);
                break;
            }
            case RED_STAINED_GLASS_PANE: {
                this.player.closeInventory();
            }
        }
    }

    @Override
    public void updateInventory() {
    }

    @NotNull
    public Inventory getInventory() {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)9, (String)this.chat.format("&6Confirm Listing"));
        this.inv.setItem(0, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(1, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(2, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(3, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        ArrayList<String> lore = new ArrayList<String>();
        for (String s : AuctionHouse.getInstance().getMessages().getGui_cl_lore()) {
            lore.add(s.replace("%amount%", this.chat.formatMoney(this.price)).replace("%fee%", this.chat.formatMoney(AuctionHouse.getInstance().getConfigFile().calculateListingFee(this.price))));
        }
        this.inv.setItem(4, ItemBuilder.build(this.itemStack.getType(), 1, this.chat.formatItem(this.itemStack), lore, new String[0]));
        this.inv.setItem(5, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(6, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(7, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(8, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        Inventory inventory = this.inv;
        if (inventory == null) {
            ConfirmListGUI.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/akarian/auctionhouse/guis/ConfirmListGUI", "getInventory"));
    }
}

