/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis;

import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.AuctionHouseGUI;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ConfirmBuyGUI
implements AkarianInventory {
    private final Listing listing;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private Inventory inv;
    private final Player player;
    private final AuctionHouseGUI auctionHouseGUI;

    public ConfirmBuyGUI(Player player, Listing listing, AuctionHouseGUI auctionHouseGUI) {
        this.player = player;
        this.listing = listing;
        this.auctionHouseGUI = auctionHouseGUI;
    }

    @Override
    public void onGUIClick(Inventory inventory, Player player, int i, ItemStack itemStack, ClickType clickType) {
        switch (itemStack.getType()) {
            case LIME_STAINED_GLASS_PANE: {
                player.closeInventory();
                switch (AuctionHouse.getInstance().getListingManager().buy(this.listing, player)) {
                    case -1: {
                        this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getError_deleted());
                        break;
                    }
                    case 0: {
                        this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getError_poor());
                        break;
                    }
                    case 1: {
                        this.chat.log("Listing " + this.chat.formatItem(this.listing.getItemStack()) + " has been bought by " + player.getName() + ". Creator offline.", AuctionHouse.getInstance().isDebug());
                        break;
                    }
                    case 2: {
                        this.chat.log("Listing " + this.chat.formatItem(this.listing.getItemStack()) + " has been bought by " + player.getName() + ". Creator online.", AuctionHouse.getInstance().isDebug());
                    }
                }
                break;
            }
            case RED_STAINED_GLASS_PANE: {
                player.openInventory(this.auctionHouseGUI.getInventory());
            }
        }
    }

    public Inventory getInventory() {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)9, (String)this.chat.format(AuctionHouse.getInstance().getMessages().getGui_cb_title()));
        this.inv.setItem(0, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(1, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(2, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(3, ItemBuilder.build(Material.LIME_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_cn(), AuctionHouse.getInstance().getMessages().getGui_buttons_cd(), new String[0]));
        this.inv.setItem(4, this.listing.createActiveListing(this.player));
        this.inv.setItem(5, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(6, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(7, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        this.inv.setItem(8, ItemBuilder.build(Material.RED_STAINED_GLASS_PANE, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_dn(), AuctionHouse.getInstance().getMessages().getGui_buttons_dd(), new String[0]));
        return this.inv;
    }

    @Override
    public void updateInventory() {
        this.inv.setItem(4, this.listing.createActiveListing(this.player));
    }

    public Listing getListing() {
        return this.listing;
    }

    public Inventory getInv() {
        return this.inv;
    }
}

