/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.guis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.comparators.AmountComparatorGL;
import net.akarian.auctionhouse.comparators.AmountComparatorLG;
import net.akarian.auctionhouse.comparators.CostPerComparatorGL;
import net.akarian.auctionhouse.comparators.CostPerComparatorLG;
import net.akarian.auctionhouse.comparators.PriceComparatorGL;
import net.akarian.auctionhouse.comparators.PriceComparatorLG;
import net.akarian.auctionhouse.comparators.TimeRemainingComparatorGL;
import net.akarian.auctionhouse.comparators.TimeRemainingComparatorLG;
import net.akarian.auctionhouse.guis.ConfirmBuyGUI;
import net.akarian.auctionhouse.guis.ExpireReclaimGUI;
import net.akarian.auctionhouse.guis.ListingEditGUI;
import net.akarian.auctionhouse.guis.ShulkerViewGUI;
import net.akarian.auctionhouse.guis.SortGUI;
import net.akarian.auctionhouse.guis.SortType;
import net.akarian.auctionhouse.guis.admin.ListingEditAdminGUI;
import net.akarian.auctionhouse.guis.admin.ShulkerViewAdminGUI;
import net.akarian.auctionhouse.layouts.Layout;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.AkarianInventory;
import net.akarian.auctionhouse.utils.Chat;
import net.akarian.auctionhouse.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class AuctionHouseGUI
implements AkarianInventory {
    private static final HashMap<UUID, AuctionHouseGUI> searchMap = new HashMap();
    private int page;
    private final Player player;
    private final Chat chat = AuctionHouse.getInstance().getChat();
    private final SortType sortType;
    private final boolean sortBool;
    private boolean search = false;
    private String searchStr = "";
    private List<Listing> listings;
    private Inventory inv;
    private boolean adminMode;
    private Layout layout;

    public AuctionHouseGUI(Player player, SortType sortType, boolean sortBool, int page) {
        this.player = player;
        this.sortType = sortType;
        this.sortBool = sortBool;
        this.page = page;
        this.adminMode = false;
        this.layout = AuctionHouse.getInstance().getLayoutManager().getActiveLayout();
    }

    public AuctionHouseGUI adminMode() {
        this.adminMode = true;
        return this;
    }

    public AuctionHouseGUI search(String search) {
        this.search = !search.equals("");
        this.searchStr = search;
        this.page = 1;
        return this;
    }

    @Override
    public void onGUIClick(Inventory inventory, Player player, int slot, ItemStack itemStack, ClickType clickType) {
        switch (slot) {
            case 1: {
                if (itemStack.getType() == Material.GRAY_DYE && player.hasPermission("auctionhouse.admin.manage")) {
                    this.inv.setItem(1, ItemBuilder.build(Material.LIME_DYE, 1, "&cAdmin Mode", Collections.singletonList("&aAdmin mode is enabled."), new String[0]));
                    this.adminMode = true;
                } else if (itemStack.getType() == Material.LIME_DYE && player.hasPermission("auctionhouse.admin.manage")) {
                    this.inv.setItem(1, ItemBuilder.build(Material.GRAY_DYE, 1, "&cAdmin Mode", Collections.singletonList("&cAdmin mode is disabled."), new String[0]));
                    this.adminMode = false;
                }
                return;
            }
            case 8: {
                player.closeInventory();
                return;
            }
            case 45: {
                if (this.adminMode) {
                    player.openInventory(new AuctionHouseGUI(player, this.sortType, this.sortBool, this.page - 1).adminMode().getInventory());
                } else {
                    player.openInventory(new AuctionHouseGUI(player, this.sortType, this.sortBool, this.page - 1).getInventory());
                }
                return;
            }
            case 46: {
                player.closeInventory();
                searchMap.put(player.getUniqueId(), this);
                this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getGui_ah_sl());
                this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getGui_ah_sr());
                return;
            }
            case 50: {
                player.openInventory(new ExpireReclaimGUI(player, this, 1).getInventory());
                break;
            }
            case 52: {
                player.openInventory(new SortGUI(this).getInventory());
                return;
            }
            case 53: {
                if (this.adminMode) {
                    player.openInventory(new AuctionHouseGUI(player, this.sortType, this.sortBool, this.page + 1).getInventory());
                } else {
                    player.openInventory(new AuctionHouseGUI(player, this.sortType, this.sortBool, this.page + 1).getInventory());
                }
                return;
            }
        }
        if (slot >= 8 && slot <= 45) {
            Listing listing = AuctionHouse.getInstance().getListingManager().get(itemStack);
            if (listing == null) {
                return;
            }
            if (this.adminMode) {
                if (clickType.isLeftClick()) {
                    if (clickType.isShiftClick() && itemStack.getType() == Material.SHULKER_BOX) {
                        player.openInventory(new ShulkerViewAdminGUI(listing, this).getInventory());
                        return;
                    }
                    player.openInventory(new ListingEditAdminGUI(listing, this).getInventory());
                } else if (clickType.isRightClick() && clickType.isShiftClick()) {
                    switch (AuctionHouse.getInstance().getListingManager().safeRemove(player.getUniqueId().toString(), listing)) {
                        case -1: {
                            this.chat.log("Error while trying to safe remove " + this.chat.formatItem(listing.getItemStack()), AuctionHouse.getInstance().isDebug());
                            break;
                        }
                        case 0: {
                            this.chat.log("Tried to safe remove listing " + listing.getId().toString() + " but it is not active.", AuctionHouse.getInstance().isDebug());
                            break;
                        }
                        case 1: {
                            this.chat.sendMessage((CommandSender)player, AuctionHouse.getInstance().getMessages().getSafeRemove());
                        }
                    }
                }
                return;
            }
            if (listing.getCreator().toString().equals(player.getUniqueId().toString())) {
                if (clickType.isLeftClick()) {
                    player.openInventory(new ListingEditGUI(player, listing, this).getInventory());
                } else if (clickType.isRightClick() && clickType.isShiftClick()) {
                    switch (AuctionHouse.getInstance().getListingManager().expire(listing, false, true, player.getUniqueId().toString())) {
                        case -3: {
                            this.chat.sendMessage((CommandSender)player, "&eThat item is already expired.");
                            break;
                        }
                        case -1: {
                            this.chat.log("Error while trying to safe remove " + this.chat.formatItem(listing.getItemStack()), AuctionHouse.getInstance().isDebug());
                            break;
                        }
                        case 0: {
                            this.chat.log("Tried to safe remove listing " + listing.getId().toString() + " but it is not active.", AuctionHouse.getInstance().isDebug());
                        }
                    }
                }
                return;
            }
            if (itemStack.getType() == Material.SHULKER_BOX) {
                player.openInventory(new ShulkerViewGUI(player, listing, this).getInventory());
            } else {
                player.openInventory(new ConfirmBuyGUI(player, listing, this).getInventory());
            }
        }
    }

    public Inventory getInventory() {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)this.layout.getInventorySize(), (String)this.chat.format(this.layout.getInventoryName()));
        for (Integer i : this.layout.getSpacerItems()) {
            this.inv.setItem(i.intValue(), ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.emptyList(), new String[0]));
        }
        if (this.layout.getAdminButton() != -1 && this.player.hasPermission("auctionhouse.admin.manage")) {
            if (!this.adminMode) {
                this.inv.setItem(this.layout.getAdminButton(), ItemBuilder.build(Material.GRAY_DYE, 1, "&cAdmin Mode", Collections.singletonList("&cAdmin mode is disabled."), new String[0]));
            } else {
                this.inv.setItem(this.layout.getAdminButton(), ItemBuilder.build(Material.LIME_DYE, 1, "&cAdmin Mode", Collections.singletonList("&aAdmin mode is enabled."), new String[0]));
            }
        }
        if (this.layout.getExitButton() != -1) {
            this.inv.setItem(this.layout.getExitButton(), ItemBuilder.build(Material.BARRIER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_cn(), AuctionHouse.getInstance().getMessages().getGui_ah_cd(), new String[0]));
        }
        this.updateInventory();
        if (this.layout.getPreviousPageButton() != -1) {
            if (this.page != 1) {
                ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
                this.inv.setItem(this.layout.getPreviousPageButton(), previous);
            } else if (this.layout.isSpacerPageItems()) {
                this.inv.setItem(this.layout.getPreviousPageButton(), ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.emptyList(), new String[0]));
            }
        }
        if (this.layout.getNextPageButton() != -1) {
            if (this.listings.size() > this.layout.getListingItems().size() * this.page) {
                ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
                this.inv.setItem(this.layout.getNextPageButton(), next);
            } else if (this.layout.isSpacerPageItems()) {
                this.inv.setItem(this.layout.getNextPageButton(), ItemBuilder.build(Material.GRAY_STAINED_GLASS_PANE, 1, " ", Collections.emptyList(), new String[0]));
            }
        }
        if (this.layout.getSearchButton() != -1) {
            this.inv.setItem(this.layout.getSearchButton(), ItemBuilder.build(Material.HOPPER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_sn(), AuctionHouse.getInstance().getMessages().getGui_ah_sd(), new String[0]));
        }
        ArrayList<String> infoDesc = new ArrayList<String>();
        for (String s : AuctionHouse.getInstance().getMessages().getGui_ah_id()) {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                infoDesc.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)s.replace("%balance%", this.chat.formatMoney(AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)this.player))).replace("%items%", AuctionHouse.getInstance().getListingManager().getActive().size() + "")));
                continue;
            }
            infoDesc.add(s.replace("%balance%", this.chat.formatMoney(AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)this.player))).replace("%items%", AuctionHouse.getInstance().getListingManager().getActive().size() + ""));
        }
        if (this.layout.getInfoButton() != -1) {
            this.inv.setItem(this.layout.getInfoButton(), ItemBuilder.build(Material.BOOK, 1, AuctionHouse.getInstance().getMessages().getGui_ah_in(), infoDesc, new String[0]));
        }
        if (this.layout.getExpiredItemsButton() != -1) {
            this.inv.setItem(this.layout.getExpiredItemsButton(), ItemBuilder.build(Material.CHEST, 1, AuctionHouse.getInstance().getMessages().getGui_ah_en(), AuctionHouse.getInstance().getMessages().getGui_ah_ed(), new String[0]));
        }
        if (this.layout.getSortButton() != -1) {
            this.inv.setItem(this.layout.getSortButton(), ItemBuilder.build(Material.PAPER, 1, AuctionHouse.getInstance().getMessages().getGui_ah_stn(), AuctionHouse.getInstance().getMessages().getGui_ah_std(), new String[0]));
        }
        return this.inv;
    }

    public boolean search(Listing listing) {
        if (this.search) {
            if (this.searchStr.startsWith(AuctionHouse.getInstance().getMessages().getGui_ah_st() + ":")) {
                String playerName = this.searchStr.split(":")[1];
                UUID playerUUID = Bukkit.getOfflinePlayer((String)playerName).getUniqueId();
                return listing.getCreator().toString().equalsIgnoreCase(playerUUID.toString());
            }
            return this.chat.formatItem(listing.getItemStack()).toLowerCase(Locale.ROOT).contains(this.searchStr.toLowerCase(Locale.ROOT));
        }
        return true;
    }

    private Listing[] sortedList() {
        Listing[] listings = AuctionHouse.getInstance().getListingManager().getActive().toArray(new Listing[0]);
        switch (this.sortType) {
            case OVERALL_PRICE: {
                if (!this.sortBool) {
                    Arrays.sort(listings, new PriceComparatorLG());
                    break;
                }
                Arrays.sort(listings, new PriceComparatorGL());
                break;
            }
            case TIME_LEFT: {
                if (!this.sortBool) {
                    Arrays.sort(listings, new TimeRemainingComparatorLG());
                    break;
                }
                Arrays.sort(listings, new TimeRemainingComparatorGL());
                break;
            }
            case AMOUNT: {
                if (!this.sortBool) {
                    Arrays.sort(listings, new AmountComparatorLG());
                    break;
                }
                Arrays.sort(listings, new AmountComparatorGL());
                break;
            }
            case COST_PER_ITEM: {
                if (!this.sortBool) {
                    Arrays.sort(listings, new CostPerComparatorLG());
                    break;
                }
                Arrays.sort(listings, new CostPerComparatorGL());
            }
        }
        return listings;
    }

    @Override
    public void updateInventory() {
        ArrayList<Listing> newListings = new ArrayList<Listing>();
        for (Listing listing : this.sortedList()) {
            if (!this.search(listing)) continue;
            newListings.add(listing);
        }
        this.listings = newListings;
        int end = this.page * this.layout.getListingItems().size();
        int t = end - this.layout.getListingItems().size();
        int list = 0;
        for (Integer i : this.layout.getListingItems()) {
            this.inv.setItem(i.intValue(), null);
        }
        for (Integer i : this.layout.getListingItems()) {
            if (this.listings.size() == t || t >= end) break;
            Listing listing = this.listings.get(list);
            if (this.adminMode) {
                this.inv.setItem(i.intValue(), listing.createAdminActiveListing(this.player));
            } else {
                this.inv.setItem(i.intValue(), listing.createActiveListing(this.player));
            }
            ++t;
        }
        if (this.page != 1) {
            ItemStack previous = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_ppn(), AuctionHouse.getInstance().getMessages().getGui_buttons_ppd(), new String[0]);
            this.inv.setItem(this.layout.getPreviousPageButton(), previous);
        }
        if (this.listings.size() > this.layout.getListingItems().size() * this.page) {
            ItemStack next = ItemBuilder.build(Material.NETHER_STAR, 1, AuctionHouse.getInstance().getMessages().getGui_buttons_npn(), AuctionHouse.getInstance().getMessages().getGui_buttons_npd(), new String[0]);
            this.inv.setItem(this.layout.getNextPageButton(), next);
        }
        ArrayList<String> infoDesc = new ArrayList<String>();
        for (String s : AuctionHouse.getInstance().getMessages().getGui_ah_id()) {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                infoDesc.add(PlaceholderAPI.setPlaceholders((Player)this.player, (String)s.replace("%balance%", this.chat.formatMoney(AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)this.player))).replace("%items%", AuctionHouse.getInstance().getListingManager().getActive().size() + "")));
                continue;
            }
            infoDesc.add(s.replace("%balance%", this.chat.formatMoney(AuctionHouse.getInstance().getEcon().getBalance((OfflinePlayer)this.player))).replace("%items%", AuctionHouse.getInstance().getListingManager().getActive().size() + ""));
        }
    }

    public static HashMap<UUID, AuctionHouseGUI> getSearchMap() {
        return searchMap;
    }

    public int getPage() {
        return this.page;
    }

    public Player getPlayer() {
        return this.player;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public boolean isSortBool() {
        return this.sortBool;
    }

    public boolean isSearch() {
        return this.search;
    }

    public String getSearchStr() {
        return this.searchStr;
    }

    public List<Listing> getListings() {
        return this.listings;
    }

    public void setListings(List<Listing> listings) {
        this.listings = listings;
    }

    public Inventory getInv() {
        return this.inv;
    }

    public boolean isAdminMode() {
        return this.adminMode;
    }
}

