/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.events;

import java.util.HashMap;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.SettingsGUI;
import net.akarian.auctionhouse.guis.admin.settings.DefaultPlayerSettingsGUI;
import net.akarian.auctionhouse.guis.admin.settings.ServerSettingsGUI;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.users.User;
import net.akarian.auctionhouse.utils.Chat;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class SettingsGUIEvents
implements Listener {
    HashMap<UUID, Integer> willExpireCheck = new HashMap();

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        String input = e.getMessage();
        Chat chat = AuctionHouse.getInstance().getChat();
        User user = AuctionHouse.getInstance().getUserManager().getUser(p);
        if (SettingsGUI.getTimeMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            try {
                Long.parseLong(input);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage((CommandSender)p, "&cYou must provide a valid number.");
                return;
            }
            long sec = Long.parseLong(input);
            user.getUserSettings().setAlertNearExpireTime(sec);
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(SettingsGUI.getTimeMap().get(p.getUniqueId()).getInventory());
                SettingsGUI.getTimeMap().remove(p.getUniqueId());
            });
        } else if (DefaultPlayerSettingsGUI.getTimeMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            try {
                Long.parseLong(input);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage((CommandSender)p, "&cYou must provide a valid number.");
                return;
            }
            long sec = Long.parseLong(input);
            AuctionHouse.getInstance().getConfigFile().setDps_expireTime(sec);
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(DefaultPlayerSettingsGUI.getTimeMap().get(p.getUniqueId()).getInventory());
                DefaultPlayerSettingsGUI.getTimeMap().remove(p.getUniqueId());
            });
        } else if (this.willExpireCheck.containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            if (input.equalsIgnoreCase("Y")) {
                AuctionHouse.getInstance().getConfigFile().setListingTime(this.willExpireCheck.get(p.getUniqueId()));
                Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                    p.openInventory(ServerSettingsGUI.getTimeMap().get(p.getUniqueId()).getInventory());
                    ServerSettingsGUI.getTimeMap().remove(p.getUniqueId());
                });
            } else {
                Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                    p.openInventory(ServerSettingsGUI.getTimeMap().get(p.getUniqueId()).getInventory());
                    ServerSettingsGUI.getTimeMap().remove(p.getUniqueId());
                });
            }
            this.willExpireCheck.remove(p.getUniqueId());
        } else if (ServerSettingsGUI.getTimeMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            try {
                Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage((CommandSender)p, "&cYou must provide a valid number.");
                return;
            }
            int sec = Integer.parseInt(input);
            long now = System.currentTimeMillis() / 1000L;
            int willExpire = 0;
            for (Listing listing : AuctionHouse.getInstance().getListingManager().getActive()) {
                long end = (listing.getStart() + (long)sec * 1000L) / 1000L;
                if (now <= end) continue;
                ++willExpire;
            }
            if (willExpire != 0) {
                chat.sendMessage((CommandSender)p, "&e&l! &c&lCAUTION &fChanging the the listing time to &e" + chat.formatTime(sec) + "&f will cause &e" + willExpire + "&f auction(s) to expire.");
                chat.sendMessage((CommandSender)p, "&fType Y to continue or N to cancel.");
                this.willExpireCheck.put(p.getUniqueId(), sec);
                return;
            }
            AuctionHouse.getInstance().getConfigFile().setListingTime(sec);
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(ServerSettingsGUI.getTimeMap().get(p.getUniqueId()).getInventory());
                ServerSettingsGUI.getTimeMap().remove(p.getUniqueId());
            });
        } else if (ServerSettingsGUI.getFeeMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            String dupe = input;
            try {
                Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                if (input.contains("%")) {
                    try {
                        Integer.parseInt(dupe.replace("%", ""));
                    }
                    catch (NumberFormatException ex2) {
                        chat.sendMessage((CommandSender)p, "&cYou must provide a valid percentage.");
                        return;
                    }
                }
                chat.sendMessage((CommandSender)p, "&cYou must provide a valid percentage.");
                return;
            }
            AuctionHouse.getInstance().getConfigFile().setListingFee(input);
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(ServerSettingsGUI.getFeeMap().get(p.getUniqueId()).getInventory());
                ServerSettingsGUI.getFeeMap().remove(p.getUniqueId());
            });
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Chat chat = AuctionHouse.getInstance().getChat();
        if (SettingsGUI.getTimeMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(SettingsGUI.getTimeMap().get(p.getUniqueId()).getInventory());
            SettingsGUI.getTimeMap().remove(p.getUniqueId());
        } else if (DefaultPlayerSettingsGUI.getTimeMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(DefaultPlayerSettingsGUI.getTimeMap().get(p.getUniqueId()).getInventory());
            DefaultPlayerSettingsGUI.getTimeMap().remove(p.getUniqueId());
        } else if (ServerSettingsGUI.getFeeMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(ServerSettingsGUI.getFeeMap().get(p.getUniqueId()).getInventory());
            ServerSettingsGUI.getFeeMap().remove(p.getUniqueId());
        } else if (ServerSettingsGUI.getTimeMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(ServerSettingsGUI.getTimeMap().get(p.getUniqueId()).getInventory());
            ServerSettingsGUI.getTimeMap().remove(p.getUniqueId());
        }
    }
}

