/*
 * Decompiled with CFR 0.152.
 */
package net.akarian.auctionhouse.events;

import java.util.HashMap;
import java.util.UUID;
import net.akarian.auctionhouse.AuctionHouse;
import net.akarian.auctionhouse.guis.AuctionHouseGUI;
import net.akarian.auctionhouse.guis.ListingEditGUI;
import net.akarian.auctionhouse.guis.admin.ListingEditAdminGUI;
import net.akarian.auctionhouse.guis.admin.database.transfer.ConfirmDatabaseTransfer;
import net.akarian.auctionhouse.listings.Listing;
import net.akarian.auctionhouse.utils.Chat;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class AuctionHouseGUIEvents
implements Listener {
    private static final HashMap<UUID, ConfirmDatabaseTransfer> portMap = new HashMap();
    private static final HashMap<UUID, ConfirmDatabaseTransfer> usernameMap = new HashMap();
    private static final HashMap<UUID, ConfirmDatabaseTransfer> passwordMap = new HashMap();
    private static final HashMap<UUID, ConfirmDatabaseTransfer> databaseMap = new HashMap();

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        String input = e.getMessage();
        Chat chat = AuctionHouse.getInstance().getChat();
        if (AuctionHouseGUI.getSearchMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            if (input.startsWith("seller:")) {
                String playerName = input.split(":")[1];
                UUID uUID = Bukkit.getOfflinePlayer((String)playerName).getUniqueId();
            }
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(AuctionHouseGUI.getSearchMap().get(p.getUniqueId()).search(input).getInventory());
                AuctionHouseGUI.getSearchMap().remove(p.getUniqueId());
            });
        } else if (ListingEditGUI.getPriceMap().containsKey(p.getUniqueId())) {
            double price;
            e.setCancelled(true);
            Listing listing = ListingEditGUI.getPriceMap().get(p.getUniqueId()).getListing();
            try {
                price = Double.parseDouble(input);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage((CommandSender)p, "&cYou must provide a compatible price.");
                return;
            }
            if (price <= 0.0) {
                chat.sendMessage((CommandSender)p, "&cThe price must be above $0.");
                return;
            }
            AuctionHouse.getInstance().getListingManager().setPrice(listing, price);
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(ListingEditGUI.getPriceMap().get(p.getUniqueId()).getInventory());
                ListingEditGUI.getPriceMap().remove(p.getUniqueId());
            });
        } else if (ListingEditAdminGUI.getPriceMap().containsKey(p.getUniqueId())) {
            double price;
            e.setCancelled(true);
            Listing listing = ListingEditAdminGUI.getPriceMap().get(p.getUniqueId()).getListing();
            try {
                price = Double.parseDouble(input);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage((CommandSender)p, "&cYou must provide a compatible price.");
                return;
            }
            if (price <= 0.0) {
                chat.sendMessage((CommandSender)p, "&cThe price must be above $0.");
                return;
            }
            AuctionHouse.getInstance().getListingManager().setPrice(listing, price);
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(ListingEditAdminGUI.getPriceMap().get(p.getUniqueId()).getInventory());
                ListingEditAdminGUI.getPriceMap().remove(p.getUniqueId());
            });
        } else if (ListingEditGUI.getAmountMap().containsKey(p.getUniqueId())) {
            int amount;
            e.setCancelled(true);
            Listing listing = ListingEditGUI.getAmountMap().get(p.getUniqueId()).getListing();
            try {
                amount = Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage((CommandSender)p, "&cYou must provide a compatible amount.");
                return;
            }
            if (amount <= 0) {
                chat.sendMessage((CommandSender)p, "&cThe amount must be greater than 0.");
                return;
            }
            if (amount > listing.getItemStack().getMaxStackSize()) {
                chat.sendMessage((CommandSender)p, "&cThe amount must be less than the max stack size of the item.");
                return;
            }
            switch (AuctionHouse.getInstance().getListingManager().setAmount(listing, amount, p, false)) {
                case -2: {
                    chat.sendMessage((CommandSender)p, "&cYou cannot carry the returned items. Please clear space and try again.");
                    return;
                }
                case -1: {
                    chat.sendMessage((CommandSender)p, "&cYou do not have that many items to add to this auction.");
                    return;
                }
            }
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(ListingEditGUI.getAmountMap().get(p.getUniqueId()).getInventory());
                ListingEditGUI.getAmountMap().remove(p.getUniqueId());
            });
        } else if (ListingEditAdminGUI.getAmountMap().containsKey(p.getUniqueId())) {
            int amount;
            e.setCancelled(true);
            Listing listing = ListingEditAdminGUI.getAmountMap().get(p.getUniqueId()).getListing();
            try {
                amount = Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage((CommandSender)p, "&cYou must provide a compatible amount.");
                return;
            }
            if (amount <= 0) {
                chat.sendMessage((CommandSender)p, "&cThe amount must be greater than 0.");
                return;
            }
            if (amount > listing.getItemStack().getMaxStackSize()) {
                chat.sendMessage((CommandSender)p, "&cThe amount must be less than the max stack size of the item.");
                return;
            }
            AuctionHouse.getInstance().getListingManager().setAmount(listing, amount, p, true);
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                p.openInventory(ListingEditAdminGUI.getAmountMap().get(p.getUniqueId()).getInventory());
                ListingEditAdminGUI.getAmountMap().remove(p.getUniqueId());
            });
        } else if (ConfirmDatabaseTransfer.getHostMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            AuctionHouse.getInstance().getConfigFile().setDb_host(input);
            p.resetTitle();
            p.sendTitle(chat.format("&6Enter Port"), chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_port()), 1, 600, 1);
            portMap.put(p.getUniqueId(), ConfirmDatabaseTransfer.getHostMap().get(p.getUniqueId()));
            ConfirmDatabaseTransfer.getHostMap().remove(p.getUniqueId());
        } else if (portMap.containsKey(p.getUniqueId())) {
            int i;
            e.setCancelled(true);
            try {
                i = Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                chat.sendMessage((CommandSender)p, "&e" + input + " is not a valid port. Please input a valid port.");
                return;
            }
            AuctionHouse.getInstance().getConfigFile().setDb_port(i);
            usernameMap.put(p.getUniqueId(), portMap.get(p.getUniqueId()));
            portMap.remove(p.getUniqueId());
            p.resetTitle();
            p.sendTitle(chat.format("&6Enter Username"), chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_username()), 1, 600, 1);
        } else if (usernameMap.containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            AuctionHouse.getInstance().getConfigFile().setDb_username(input);
            passwordMap.put(p.getUniqueId(), usernameMap.get(p.getUniqueId()));
            usernameMap.remove(p.getUniqueId());
            p.resetTitle();
            p.sendTitle(chat.format("&6Enter Password"), chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_password()), 1, 600, 1);
            chat.sendMessage((CommandSender)p, "&eEnter \"none\" for no password.");
        } else if (passwordMap.containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            String password = input;
            if (password.equalsIgnoreCase("none")) {
                password = "";
            }
            AuctionHouse.getInstance().getConfigFile().setDb_password(password);
            databaseMap.put(p.getUniqueId(), passwordMap.get(p.getUniqueId()));
            passwordMap.remove(p.getUniqueId());
            p.resetTitle();
            p.sendTitle(chat.format("&6Enter Database Name"), chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_database()), 1, 600, 1);
        } else if (databaseMap.containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            AuctionHouse.getInstance().getConfigFile().setDb_database(input);
            p.resetTitle();
            Bukkit.getScheduler().runTask((Plugin)AuctionHouse.getInstance(), () -> {
                databaseMap.get(p.getUniqueId()).testConnection();
                databaseMap.remove(p.getUniqueId());
            });
            AuctionHouse.getInstance().getConfigFile().saveConfig();
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Chat chat = AuctionHouse.getInstance().getChat();
        if (AuctionHouseGUI.getSearchMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(AuctionHouseGUI.getSearchMap().get(p.getUniqueId()).search("").getInventory());
            AuctionHouseGUI.getSearchMap().remove(p.getUniqueId());
        } else if (ListingEditGUI.getPriceMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(ListingEditGUI.getPriceMap().get(p.getUniqueId()).getInventory());
            ListingEditGUI.getPriceMap().remove(p.getUniqueId());
        } else if (ListingEditAdminGUI.getPriceMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(ListingEditAdminGUI.getPriceMap().get(p.getUniqueId()).getInventory());
            ListingEditAdminGUI.getPriceMap().remove(p.getUniqueId());
        } else if (ListingEditGUI.getAmountMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(ListingEditGUI.getAmountMap().get(p.getUniqueId()).getInventory());
            ListingEditGUI.getAmountMap().remove(p.getUniqueId());
        } else if (ListingEditAdminGUI.getAmountMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.openInventory(ListingEditAdminGUI.getAmountMap().get(p.getUniqueId()).getInventory());
            ListingEditAdminGUI.getAmountMap().remove(p.getUniqueId());
        } else if (ConfirmDatabaseTransfer.getHostMap().containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.resetTitle();
            p.sendTitle(chat.format("&6Enter Port"), chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_port()), 1, 600, 1);
            portMap.put(p.getUniqueId(), ConfirmDatabaseTransfer.getHostMap().get(p.getUniqueId()));
            ConfirmDatabaseTransfer.getHostMap().remove(p.getUniqueId());
        } else if (portMap.containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.resetTitle();
            p.sendTitle(chat.format("&6Enter Username"), chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_username()), 1, 600, 1);
            usernameMap.put(p.getUniqueId(), portMap.get(p.getUniqueId()));
            portMap.remove(p.getUniqueId());
        } else if (usernameMap.containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.resetTitle();
            p.sendTitle(chat.format("&6Enter Password"), chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_password()), 1, 600, 1);
            chat.sendMessage((CommandSender)p, "&eEnter \"none\" for no password.");
            passwordMap.put(p.getUniqueId(), usernameMap.get(p.getUniqueId()));
            usernameMap.remove(p.getUniqueId());
        } else if (passwordMap.containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.resetTitle();
            p.sendTitle(chat.format("&6Enter Database Name"), chat.format("&7Current: " + AuctionHouse.getInstance().getConfigFile().getDb_database()), 1, 600, 1);
            databaseMap.put(p.getUniqueId(), passwordMap.get(p.getUniqueId()));
            passwordMap.remove(p.getUniqueId());
        } else if (databaseMap.containsKey(p.getUniqueId())) {
            e.setCancelled(true);
            p.resetTitle();
            databaseMap.get(p.getUniqueId()).testConnection();
            databaseMap.remove(p.getUniqueId());
            AuctionHouse.getInstance().getConfigFile().saveConfig();
        }
    }
}

